/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.h2;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.dlight.db.h2.H2DataStorage;
import org.netbeans.modules.dlight.db.h2.RcFile;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorageFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Exceptions;

public class H2DataStorageFactory
extends SQLDataStorageFactory<H2DataStorage> {
    private static RcFile rcFile;
    static final String H2_DATA_STORAGE_TYPE = "db:sql:h2";
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();

    public H2DataStorageFactory() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType(H2_DATA_STORAGE_TYPE));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    public synchronized H2DataStorage createStorage() {
        try {
            H2DataStorage result = new H2DataStorage();
            result.connect();
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.FINE, "Storage created with the dbURL={0}", result.dbURL);
            return result;
        }
        catch (SQLException ex) {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public synchronized H2DataStorage createStorage(String uniqueKey) {
        try {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.FINE, "Create Storage with unique id={0}", uniqueKey);
            H2DataStorage result = new H2DataStorage(true, uniqueKey);
            result.connect();
            result.isPersistent = true;
            rcFile.put("h2.storages", uniqueKey, result.dbURL);
            rcFile.save();
            return result;
        }
        catch (IOException ex) {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (SQLException ex) {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.SEVERE, "Exception has been occured while trying to connect using storageUniqueID=" + uniqueKey, ex);
            return null;
        }
    }

    public synchronized H2DataStorage openStorage(String uniqueKey) {
        try {
            String dbURL = rcFile.get("h2.storages", uniqueKey);
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.FINE, "Trying to open storage with the uniqueID={0} and dbURL={1}", new String[]{uniqueKey, dbURL});
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.FINE, "Stack Trace is ", Thread.currentThread().getStackTrace());
            if (dbURL != null) {
                H2DataStorage result = new H2DataStorage(dbURL);
                result.connect();
                result.loadSchema();
                result.isPersistent = true;
                DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.FINE, "storage with the uniqueID={0} and dbURL={1} successfully OPENED", new String[]{uniqueKey, dbURL});
                return result;
            }
            return this.createStorage(uniqueKey);
        }
        catch (SQLException ex) {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getUniqueKey(H2DataStorage storage) {
        try {
            rcFile.put("h2.storages", storage.dbURL, storage.dbURL);
            rcFile.save();
            return storage.dbURL;
        }
        catch (IOException ex) {
            DLightLogger.getLogger(H2DataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public synchronized H2DataStorage openStorage(String uniqueKey, PersistentDataStorageFactory.Mode mode) {
        return this.openStorage(uniqueKey);
    }

    static {
        String rcFileName = System.getProperty("dlight.h2.rcfile");
        if (rcFileName == null) {
            String homePath = System.getProperty("user.home");
            if (homePath != null) {
                try {
                    File homeDir = new File(homePath);
                    rcFile = new RcFile(new File(homeDir, ".h2rc"));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (RcFile.FormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            try {
                rcFile = new RcFile(new File(rcFileName));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (RcFile.FormatException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

