/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.projects.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projects.EditorContextImpl;
import org.netbeans.modules.debugger.jpda.projects.LineTranslations;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private final Map<JPDABreakpoint, Set<Annotation>> breakpointToAnnotations = new IdentityHashMap<JPDABreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private boolean attachManagerListener = true;
    private RequestProcessor annotationProcessor = new RequestProcessor("Annotation Refresh", 1);
    private RequestProcessor contextWaitingProcessor = new RequestProcessor("Annotation Refresh Context Waiting", 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo != null) {
            DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
            if (dobj != null) {
                PropertyChangeListener pchl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("primaryFile".equals(evt.getPropertyName())) {
                            DataObject dobj = (DataObject)evt.getSource();
                            final FileObject newFO = dobj.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotationProcessor.post(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointAnnotationProvider.this.annotate(newFO);
                                }
                            });
                        }
                    }
                };
                dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(pchl);
                }
            }
            this.annotate(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(FileObject fo) {
        Map<JPDABreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            if (this.annotatedFiles.contains(fo)) {
                return;
            }
            Set<JPDABreakpoint> annotatedBreakpoints = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                JPDABreakpoint b = (JPDABreakpoint)breakpoint;
                if (!annotatedBreakpoints.contains(b)) {
                    b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet());
                    if (b instanceof LineBreakpoint) {
                        LineBreakpoint lb = (LineBreakpoint)b;
                        LineTranslations.getTranslations().registerForLineUpdates(lb);
                    }
                }
                this.addAnnotationTo(b, fo);
            }
            this.annotatedFiles.add(fo);
        }
        if (this.attachManagerListener) {
            this.attachManagerListener = false;
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint b = (JPDABreakpoint)breakpoint;
            b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, false, true));
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().registerForLineUpdates(lb);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint b = (JPDABreakpoint)breakpoint;
            b.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, true, false));
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lb);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (!("enabled".equals(propertyName) || "validity".equals(propertyName) || "condition".equals(propertyName) || "url".equals(propertyName) || "lineNumber".equals(propertyName) || "className".equals(propertyName) || "fieldName".equals(propertyName) || "classFilters".equals(propertyName) || "classExclusionFilters".equals(propertyName) || "methodName".equals(propertyName) || "signature".equals(propertyName))) {
            return;
        }
        JPDABreakpoint b = (JPDABreakpoint)evt.getSource();
        DebuggerManager manager = DebuggerManager.getDebuggerManager();
        Breakpoint[] bkpts = manager.getBreakpoints();
        boolean found = false;
        for (int x = 0; x < bkpts.length; ++x) {
            if (b != bkpts[x]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, true, true));
    }

    private static boolean isAnnotatable(Breakpoint b) {
        return (b instanceof LineBreakpoint || b instanceof FieldBreakpoint || b instanceof MethodBreakpoint || b instanceof ClassLoadUnloadBreakpoint) && !((JPDABreakpoint)b).isHidden();
    }

    private static String getAnnotationType(JPDABreakpoint b, boolean isConditional) {
        String annotationType;
        boolean isInvalid;
        boolean bl = isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (b instanceof LineBreakpoint) {
            annotationType = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (b instanceof FieldBreakpoint) {
            annotationType = b.isEnabled() ? "FieldBreakpoint" : "DisabledFieldBreakpoint";
        } else if (b instanceof MethodBreakpoint) {
            annotationType = b.isEnabled() ? "MethodBreakpoint" : "DisabledMethodBreakpoint";
        } else if (b instanceof ClassLoadUnloadBreakpoint) {
            annotationType = b.isEnabled() ? "ClassBreakpoint" : "DisabledClassBreakpoint";
        } else {
            throw new IllegalStateException(b.toString());
        }
        if (isInvalid && b.isEnabled()) {
            annotationType = annotationType + "_broken";
        }
        return annotationType;
    }

    private int[] getAnnotationLines(JPDABreakpoint b, FileObject fo) {
        if (b instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)b;
            try {
                if (fo.getURL().equals(new URL(lb.getURL()))) {
                    return new int[]{lb.getLineNumber()};
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        if (b instanceof FieldBreakpoint) {
            int line;
            String fieldName;
            FieldBreakpoint fb = (FieldBreakpoint)b;
            String className = fb.getClassName();
            Future<Integer> fi = EditorContextImpl.getFieldLineNumber(fo, className, fieldName = fb.getFieldName());
            if (fi != null) {
                if (!fi.isDone()) {
                    this.delayedAnnotation(b, fo, fi);
                    return null;
                }
                try {
                    line = fi.get();
                }
                catch (InterruptedException ex) {
                    return null;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            } else {
                return null;
            }
            return new int[]{line};
        }
        if (b instanceof MethodBreakpoint) {
            MethodBreakpoint mb = (MethodBreakpoint)b;
            String[] filters = mb.getClassFilters();
            int[] lns = new int[]{};
            for (int i = 0; i < filters.length; ++i) {
                Future<int[]> futurelns;
                if (filters[i].startsWith("*") || filters[i].endsWith("*") || (futurelns = EditorContextImpl.getMethodLineNumbers(fo, filters[i], mb.getClassExclusionFilters(), mb.getMethodName(), mb.getMethodSignature())) == null) continue;
                if (!futurelns.isDone()) {
                    this.delayedAnnotation2(b, fo, futurelns);
                    continue;
                }
                try {
                    int[] newlns = futurelns.get();
                    if (newlns == null) continue;
                    if (lns.length == 0) {
                        lns = newlns;
                        continue;
                    }
                    int[] ln = new int[lns.length + newlns.length];
                    System.arraycopy(lns, 0, ln, 0, lns.length);
                    System.arraycopy(newlns, 0, ln, lns.length, newlns.length);
                    lns = ln;
                    continue;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return lns;
        }
        if (b instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)b;
            String[] filters = cb.getClassFilters();
            int[] lns = new int[]{};
            for (int i = 0; i < filters.length; ++i) {
                Future<Integer> futurelns;
                if (filters[i].startsWith("*") || filters[i].endsWith("*") || (futurelns = EditorContextImpl.getClassLineNumber(fo, filters[i], cb.getClassExclusionFilters())) == null) continue;
                if (!futurelns.isDone()) {
                    this.delayedAnnotation(b, fo, futurelns);
                    continue;
                }
                try {
                    Integer newline = futurelns.get();
                    if (newline == null) continue;
                    if (lns.length == 0) {
                        lns = new int[]{newline};
                        continue;
                    }
                    int[] ln = new int[lns.length + 1];
                    System.arraycopy(lns, 0, ln, 0, lns.length);
                    ln[lns.length] = newline;
                    lns = ln;
                    continue;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return lns;
        }
        throw new IllegalStateException(b.toString());
    }

    private void delayedAnnotation(final JPDABreakpoint b, final FileObject fo, final Future<Integer> fi) {
        this.contextWaitingProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Integer line = (Integer)fi.get();
                    if (line != null) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(b, fo, new int[]{line});
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void delayedAnnotation2(final JPDABreakpoint b, final FileObject fo, final Future<int[]> futurelns) {
        this.contextWaitingProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    int[] lines = (int[])futurelns.get();
                    if (lines != null && lines.length > 0) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(b, fo, lines);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void addAnnotationTo(JPDABreakpoint b, FileObject fo) {
        int[] lines = this.getAnnotationLines(b, fo);
        this.addAnnotationTo(b, fo, lines);
    }

    private void addAnnotationTo(JPDABreakpoint b, FileObject fo, int[] lines) {
        DataObject dataObject;
        String condition;
        if (lines == null || lines.length == 0) {
            return;
        }
        if (b instanceof LineBreakpoint) {
            condition = ((LineBreakpoint)b).getCondition();
        } else if (b instanceof FieldBreakpoint) {
            condition = ((FieldBreakpoint)b).getCondition();
        } else if (b instanceof MethodBreakpoint) {
            condition = ((MethodBreakpoint)b).getCondition();
        } else if (b instanceof ClassLoadUnloadBreakpoint) {
            condition = null;
        } else {
            throw new IllegalStateException(b.toString());
        }
        boolean isConditional = condition != null && condition.trim().length() > 0;
        String annotationType = BreakpointAnnotationProvider.getAnnotationType(b, isConditional);
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfex) {
            donfex.printStackTrace();
            return;
        }
        LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lc == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> annotations = new ArrayList<DebuggerBreakpointAnnotation>();
        for (int l : lines) {
            try {
                Line line = lc.getLineSet().getCurrent(l - 1);
                DebuggerBreakpointAnnotation annotation = new DebuggerBreakpointAnnotation(annotationType, line, (Breakpoint)b);
                annotations.add(annotation);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (annotations.size() == 0) {
            return;
        }
        Set<Annotation> bpAnnotations = this.breakpointToAnnotations.get(b);
        if (bpAnnotations == null) {
            this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet(annotations));
        } else {
            bpAnnotations.addAll(annotations);
            this.breakpointToAnnotations.put(b, bpAnnotations);
        }
    }

    private void removeAnnotations(JPDABreakpoint b) {
        Set<Annotation> annotations = this.breakpointToAnnotations.remove(b);
        if (annotations == null) {
            return;
        }
        for (Annotation a : annotations) {
            a.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private final class AnnotationRefresh
    implements Runnable {
        private JPDABreakpoint b;
        private boolean remove;
        private boolean add;

        public AnnotationRefresh(JPDABreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.remove) {
                    BreakpointAnnotationProvider.this.removeAnnotations(this.b);
                    if (!this.add) {
                        BreakpointAnnotationProvider.this.breakpointToAnnotations.remove(this.b);
                    }
                }
                if (this.add) {
                    BreakpointAnnotationProvider.this.breakpointToAnnotations.put(this.b, new WeakSet());
                    for (FileObject fo : BreakpointAnnotationProvider.this.annotatedFiles) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(this.b, fo);
                    }
                }
            }
        }
    }
}

