/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.debugger.jpda.projects.FixActionProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static final boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.projects");
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private ClassPath originalSourcePath;
    private Set<String> additionalSourceRoots;
    private Set<String> platformSourceRoots;
    private ClassPath smartSteppingSourcePath;
    private String[] projectSourceRoots;
    private ClassPath unorderedOriginalSourcePath;
    private int[] sourcePathPermutation;
    private PropertyChangeSupport pcs;
    private PathRegistryListener pathRegistryListener;
    private File baseDir;
    private final Map<String, String> urlCache = new URLCacheMap();
    private final Map<String, String> urlCacheGlobal = new URLCacheMap();
    private static boolean CAN_FIX_CLASSES_AUTOMATICALLY = Boolean.getBoolean("debugger.apply-code-changes.on-save");

    public SourcePathProviderImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourcePathProviderImpl(ContextProvider contextProvider) {
        this.pcs = new PropertyChangeSupport((Object)this);
        JPDADebugger debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        HashSet<FileObject> srcRootsToListenForArtifactsUpdates = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Have properties = " + properties);
        }
        if (properties != null) {
            ClassPath additionalClassPath;
            this.baseDir = (File)properties.get("baseDir");
            this.smartSteppingSourcePath = (ClassPath)properties.get("sourcepath");
            ClassPath jdkCP = (ClassPath)properties.get("jdksources");
            if (jdkCP == null && JavaPlatform.getDefault() != null) {
                jdkCP = JavaPlatform.getDefault().getSourceFolders();
            }
            this.platformSourceRoots = SourcePathProviderImpl.getSourceRootsSet(jdkCP);
            if (this.baseDir != null) {
                additionalClassPath = this.getAdditionalClassPath(this.baseDir);
            } else {
                additionalClassPath = null;
                Exceptions.printStackTrace((Throwable)new NullPointerException("No base directory is defined. Properties = " + properties));
            }
            if (additionalClassPath != null) {
                this.smartSteppingSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, additionalClassPath});
            }
            this.unorderedOriginalSourcePath = this.smartSteppingSourcePath = jdkCP == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{jdkCP, this.smartSteppingSourcePath});
            Map<String, Integer> orderIndexes = SourcePathProviderImpl.getSourceRootsOrder(this.baseDir);
            String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
            String[] sortedOriginalRoots = new String[unorderedOriginalRoots.length];
            this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(unorderedOriginalRoots, orderIndexes, sortedOriginalRoots);
            this.originalSourcePath = this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sortedOriginalRoots);
            Set<String> disabledRoots = this.baseDir != null ? this.getDisabledSourceRoots(this.baseDir) : null;
            if (disabledRoots != null && !disabledRoots.isEmpty()) {
                ArrayList<FileObject> enabledSourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                for (FileObject fo : new HashSet<FileObject>(enabledSourcePath)) {
                    if (!disabledRoots.contains(SourcePathProviderImpl.getRoot(fo))) continue;
                    enabledSourcePath.remove(fo);
                }
                this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(enabledSourcePath.toArray(new FileObject[0]));
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            HashSet<FileObject> preferredRoots = new HashSet<FileObject>();
            preferredRoots.addAll(Arrays.asList(this.originalSourcePath.getRoots()));
            String listeningCP = (String)properties.get("listeningCP");
            if (listeningCP != null) {
                for (String cp : listeningCP.split(File.pathSeparator)) {
                    logger.log(Level.FINE, "Listening cp = '" + cp + "'");
                    File f = new File(cp);
                    f = FileUtil.normalizeFile((File)f);
                    URL entry = FileUtil.urlForArchiveOrDir((File)f);
                    if (entry == null) continue;
                    srcRootsToListenForArtifactsUpdates = new HashSet();
                    for (FileObject src : SourceForBinaryQuery.findSourceRoots((URL)entry).getRoots()) {
                        srcRootsToListenForArtifactsUpdates.add(src);
                    }
                }
            }
        } else {
            RequestProcessor rp = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
            this.pathRegistryListener = new PathRegistryListener(rp);
            GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.pathRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pathRegistryListener, (Object)JavaPlatformManager.getDefault()));
            ArrayList<FileObject> allSourceRoots = new ArrayList<FileObject>();
            HashSet<FileObject> preferredRoots = new HashSet<FileObject>();
            HashSet<FileObject> addedBinaryRoots = new HashSet<FileObject>();
            Project mainProject = OpenProjects.getDefault().getMainProject();
            this.platformSourceRoots = new HashSet<String>();
            if (mainProject != null) {
                SourceGroup[] sgs;
                for (SourceGroup sg : sgs = ProjectUtils.getSources((Project)mainProject).getSourceGroups("java")) {
                    ClassPath ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/execute");
                    if (ecp == null) {
                        ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/source");
                    }
                    if (ecp != null) {
                        FileObject[] binaryRoots;
                        for (FileObject fo : binaryRoots = ecp.getRoots()) {
                            if (addedBinaryRoots.contains(fo)) continue;
                            addedBinaryRoots.add(fo);
                            try {
                                FileObject[] roots;
                                for (FileObject fr : roots = SourceForBinaryQuery.findSourceRoots((URL)fo.getURL()).getRoots()) {
                                    if (preferredRoots.contains(fr)) continue;
                                    allSourceRoots.add(fr);
                                    preferredRoots.add(fr);
                                }
                            }
                            catch (FileStateInvalidException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    if ((ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/boot")) == null) continue;
                    this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(ecp));
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: preferred source roots = " + preferredRoots + ")");
            }
            TreeSet<FileObject> globalRoots = new TreeSet<FileObject>(new FileObjectComparator());
            globalRoots.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            for (FileObject fo : globalRoots) {
                if (preferredRoots.contains(fo)) continue;
                allSourceRoots.add(fo);
            }
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                FileObject[] roots = platforms[i].getSourceFolders().getRoots();
                int jj = roots.length;
                for (int j = 0; j < jj; ++j) {
                    if (allSourceRoots.contains(roots[j])) continue;
                    allSourceRoots.add(roots[j]);
                }
                this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(platforms[i].getSourceFolders()));
            }
            List<FileObject> additional = this.getAdditionalRemoteClassPath();
            if (additional != null) {
                allSourceRoots.addAll(additional);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SourcePathProviderImpl: GlobalPathRegistry roots = " + GlobalPathRegistry.getDefault().getSourceRoots() + ")");
                logger.fine("Platform roots:");
                for (int i = 0; i < platforms.length; ++i) {
                    logger.fine(" " + Arrays.asList(platforms[i].getSourceFolders().getRoots()).toString());
                }
                logger.fine("SourcePathProviderImpl: all source roots = " + allSourceRoots + ")");
            }
            Set<String> disabledRoots = this.getRemoteDisabledSourceRoots();
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                this.unorderedOriginalSourcePath = SourcePathProviderImpl.createClassPath(allSourceRoots.toArray(new FileObject[allSourceRoots.size()]));
                Map<String, Integer> orderIndexes = SourcePathProviderImpl.getRemoteSourceRootsOrder();
                String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
                String[] sorterOriginalRoots = new String[unorderedOriginalRoots.length];
                this.sourcePathPermutation = SourcePathProviderImpl.createPermutation(unorderedOriginalRoots, orderIndexes, sorterOriginalRoots);
                this.originalSourcePath = SourcePathProviderImpl.createClassPath(sorterOriginalRoots);
                this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
                srcRootsToListenForArtifactsUpdates = new HashSet<FileObject>(allSourceRoots);
                this.smartSteppingSourcePath = this.originalSourcePath;
                if (disabledRoots != null && !disabledRoots.isEmpty()) {
                    ArrayList<FileObject> enabledSourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
                    for (FileObject fo : new HashSet<FileObject>(enabledSourcePath)) {
                        if (!disabledRoots.contains(SourcePathProviderImpl.getRoot(fo))) continue;
                        enabledSourcePath.remove(fo);
                    }
                    this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(enabledSourcePath.toArray(new FileObject[0]));
                }
            }
        }
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("new SourcePathProviderImpl(): contextProvider = " + contextProvider + ", properties = " + properties + ", srcRootsToListenForArtifactsUpdates = " + srcRootsToListenForArtifactsUpdates);
        }
        if (srcRootsToListenForArtifactsUpdates != null) {
            final HashSet<ArtifactsUpdatedImpl> artifactsListeners = new HashSet<ArtifactsUpdatedImpl>();
            for (FileObject src : srcRootsToListenForArtifactsUpdates) {
                try {
                    artifactsListeners.add(this.addArtifactsUpdateListenerFor(debugger, src));
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (4 == (Integer)evt.getNewValue()) {
                        for (ArtifactsUpdatedImpl al : artifactsListeners) {
                            BuildArtifactMapper.removeArtifactsUpdatedListener((URL)al.getURL(), (BuildArtifactMapper.ArtifactsUpdated)al);
                        }
                    }
                }
            });
        }
    }

    private ClassPath getAdditionalClassPath(File baseDir) {
        try {
            String root = baseDir.toURI().toURL().toExternalForm();
            Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            List additionalSourceRoots = (List)sourcesProperties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(root);
            if (additionalSourceRoots == null || additionalSourceRoots.isEmpty()) {
                return null;
            }
            ArrayList<FileObject> additionalSourcePath = new ArrayList<FileObject>(additionalSourceRoots.size());
            for (String ar : additionalSourceRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(ar);
                if (fo == null || !fo.canRead()) continue;
                additionalSourcePath.add(fo);
            }
            this.additionalSourceRoots = new LinkedHashSet<String>(additionalSourceRoots);
            return SourcePathProviderImpl.createClassPath(additionalSourcePath.toArray(new FileObject[0]));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private List<FileObject> getAdditionalRemoteClassPath() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        List additionalSourceRoots = (List)sourcesProperties.getProperties("additional_source_roots").getCollection("src_roots", Collections.emptyList());
        if (additionalSourceRoots == null || additionalSourceRoots.isEmpty()) {
            return null;
        }
        ArrayList<FileObject> additionalSourcePath = new ArrayList<FileObject>(additionalSourceRoots.size());
        for (String ar : additionalSourceRoots) {
            FileObject fo = SourcePathProviderImpl.getFileObject(ar);
            if (fo == null || !fo.canRead()) continue;
            additionalSourcePath.add(fo);
        }
        this.additionalSourceRoots = new LinkedHashSet<String>(additionalSourceRoots);
        return additionalSourcePath;
    }

    private void storeAdditionalSourceRoots() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String projectRoot;
            try {
                projectRoot = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            Map map = sourcesProperties.getProperties("additional_source_roots").getMap("project", new HashMap());
            if (this.additionalSourceRoots != null) {
                map.put(projectRoot, new ArrayList<String>(this.additionalSourceRoots));
            } else {
                map.remove(projectRoot);
            }
            sourcesProperties.getProperties("additional_source_roots").setMap("project", map);
        } else if (this.additionalSourceRoots != null) {
            sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", new ArrayList<String>(this.additionalSourceRoots));
        } else {
            sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", null);
        }
    }

    private Set<String> getDisabledSourceRoots(File baseDir) {
        try {
            String root = baseDir.toURI().toURL().toExternalForm();
            Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
            return (Set)sourcesProperties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(root);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Set<String> getRemoteDisabledSourceRoots() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Set)sourcesProperties.getProperties("source_roots").getCollection("remote_disabled", Collections.emptySet());
    }

    private void storeDisabledSourceRoots(Set<String> disabledSourceRoots) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (this.baseDir != null) {
            String projectRoot;
            try {
                projectRoot = this.baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            Map map = sourcesProperties.getProperties("source_roots").getMap("project_disabled", new HashMap());
            map.put(projectRoot, disabledSourceRoots);
            sourcesProperties.getProperties("source_roots").setMap("project_disabled", map);
        } else {
            sourcesProperties.getProperties("source_roots").setCollection("remote_disabled", disabledSourceRoots);
        }
    }

    private static Map<String, Integer> getSourceRootsOrder(File baseDir) {
        try {
            String root = baseDir.toURI().toURL().toExternalForm();
            return SourcePathProviderImpl.getSourceRootsOrder(root);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    static Map<String, Integer> getSourceRootsOrder(String root) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return (Map)sourcesProperties.getProperties("source_roots").getMap("project_order", Collections.emptyMap()).get(root);
    }

    static Map<String, Integer> getRemoteSourceRootsOrder() {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        return sourcesProperties.getProperties("source_roots").getMap("remote_order", Collections.emptyMap());
    }

    private static void storeSourceRootsOrder(File baseDir, String[] roots, int[] permutation) {
        String projectRoot;
        if (baseDir != null) {
            try {
                projectRoot = baseDir.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        } else {
            projectRoot = null;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(projectRoot, roots, permutation);
    }

    static void storeSourceRootsOrder(String projectRoot, String[] roots, int[] permutation) {
        HashMap<String, Integer> sourceOrder = new HashMap<String, Integer>();
        if (roots.length != permutation.length) {
            throw new IllegalArgumentException("Incompatible array length: roots = " + roots.length + ", permutation = " + permutation.length);
        }
        for (int i = 0; i < roots.length; ++i) {
            sourceOrder.put(roots[permutation[i]], i);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.storeSourceRootsOrder():");
            logger.fine("  sourceOrder = " + sourceOrder);
        }
        SourcePathProviderImpl.storeSourceRootsOrder(projectRoot, sourceOrder);
    }

    private static void storeSourceRootsOrder(String projectRoot, Map<String, Integer> sourceOrder) {
        Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
        if (projectRoot != null) {
            Map map = sourcesProperties.getProperties("source_roots").getMap("project_order", new HashMap());
            map.put(projectRoot, sourceOrder);
            sourcesProperties.getProperties("source_roots").setMap("project_order", map);
        } else {
            sourcesProperties.getProperties("source_roots").setMap("remote_order", sourceOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String relativePath, boolean global) {
        String url;
        FileObject fo;
        Map<String, String> map;
        if (verbose) {
            System.out.println("SPPI: getURL " + relativePath + " global " + global);
        }
        relativePath = SourcePathProviderImpl.normalize(relativePath);
        if (global) {
            map = this.urlCacheGlobal;
            synchronized (map) {
                if (this.urlCacheGlobal.containsKey(relativePath)) {
                    if (verbose) {
                        System.out.println("Have cached global path for '" + relativePath + "' url = " + this.urlCacheGlobal.get(relativePath));
                    }
                    return this.urlCacheGlobal.get(relativePath);
                }
            }
        }
        map = this.urlCache;
        synchronized (map) {
            if (this.urlCache.containsKey(relativePath)) {
                if (verbose) {
                    System.out.println("Have cached path for '" + relativePath + "' url = " + this.urlCache.get(relativePath));
                }
                return this.urlCache.get(relativePath);
            }
        }
        ClassPath ss = null;
        ClassPath os = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            if (this.originalSourcePath != null) {
                ss = this.smartSteppingSourcePath;
                os = this.originalSourcePath;
            }
        }
        if (ss != null) {
            fo = ss.findResource(relativePath);
            if (fo == null && global) {
                fo = os.findResource(relativePath);
            }
            if (fo == null && global) {
                fo = GlobalPathRegistry.getDefault().findResource(relativePath);
            }
        } else {
            fo = GlobalPathRegistry.getDefault().findResource(relativePath);
        }
        if (verbose) {
            System.out.println("SPPI:   fo " + fo);
        }
        if (fo == null) {
            url = null;
        } else {
            try {
                url = fo.getURL().toString();
            }
            catch (FileStateInvalidException e) {
                if (verbose) {
                    System.out.println("SPPI:   FileStateInvalidException");
                }
                url = null;
            }
        }
        if (global) {
            Map<String, String> map2 = this.urlCacheGlobal;
            synchronized (map2) {
                if (verbose) {
                    System.out.println("Storing path into global cache for '" + relativePath + "' url = " + url);
                }
                this.urlCacheGlobal.put(relativePath, url);
                if (verbose) {
                    System.out.println("  Global cache (" + this.urlCacheGlobal.size() + ") = " + this.urlCacheGlobal);
                }
            }
        }
        Map<String, String> map3 = this.urlCache;
        synchronized (map3) {
            if (verbose) {
                System.out.println("Storing path into cache for '" + relativePath + "' url = " + url);
            }
            this.urlCache.put(relativePath, url);
            if (verbose) {
                System.out.println("  Cache = (" + this.urlCache.size() + ") " + this.urlCache);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllURLs(String relativePath, boolean global) {
        List fos;
        if (verbose) {
            System.out.println("SPPI: getURL " + relativePath + " global " + global);
        }
        relativePath = SourcePathProviderImpl.normalize(relativePath);
        if (this.originalSourcePath == null) {
            fos = new ArrayList();
            for (ClassPath cp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                fos.addAll(cp.findAllResources(relativePath));
            }
        } else {
            SourcePathProviderImpl i$ = this;
            synchronized (i$) {
                if (!global) {
                    fos = this.smartSteppingSourcePath.findAllResources(relativePath);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + fos);
                    }
                } else {
                    fos = this.originalSourcePath.findAllResources(relativePath);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + fos);
                    }
                }
            }
        }
        ArrayList<String> urls = new ArrayList<String>(fos.size());
        for (FileObject fo : fos) {
            try {
                urls.add(fo.getURL().toString());
            }
            catch (FileStateInvalidException e) {
                if (!verbose) continue;
                System.out.println("SPPI:   FileStateInvalidException for " + fo);
            }
        }
        return urls.toArray(new String[0]);
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        FileObject fo = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + url);
        }
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
            if (verbose) {
                System.out.println("SPPI:   fo " + fo);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        String relativePath = this.smartSteppingSourcePath.getResourceName(fo, directorySeparator, includeExtension);
        if (relativePath == null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp == null) {
                cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            }
            if (cp == null) {
                return null;
            }
            relativePath = cp.getResourceName(fo, directorySeparator, includeExtension);
        }
        return relativePath;
    }

    public synchronized String getSourceRoot(String url) {
        ClassPath cp;
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException ex) {
            fo = null;
        }
        FileObject[] roots = null;
        if (fo != null && fo.canRead() && (cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) != null) {
            roots = cp.getRoots();
        }
        if (roots == null) {
            roots = this.originalSourcePath.getRoots();
        }
        for (FileObject fileObject : roots) {
            try {
                String root;
                String rootURL = fileObject.getURL().toString();
                if (!url.startsWith(rootURL) || (root = SourcePathProviderImpl.getRoot(fileObject)) == null) continue;
                return root;
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] getSourceRoots(ClassPath classPath) {
        FileObject[] sourceRoots = classPath.getRoots();
        ArrayList<String> roots = new ArrayList<String>(sourceRoots.length);
        for (FileObject fo : sourceRoots) {
            String root = SourcePathProviderImpl.getRoot(fo);
            if (root == null) continue;
            roots.add(root);
        }
        return roots.toArray(new String[0]);
    }

    private static Set<String> getSourceRootsSet(ClassPath classPath) {
        FileObject[] sourceRoots = classPath.getRoots();
        HashSet<String> roots = new HashSet<String>(sourceRoots.length);
        for (FileObject fo : sourceRoots) {
            String root = SourcePathProviderImpl.getRoot(fo);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    public synchronized Set<String> getPlatformSourceRoots() {
        return Collections.unmodifiableSet(this.platformSourceRoots);
    }

    public synchronized String[] getOriginalSourceRoots() {
        return this.getSourceRoots(this.originalSourcePath);
    }

    public synchronized String[] getSourceRoots() {
        return this.getSourceRoots(this.smartSteppingSourcePath);
    }

    synchronized Set<FileObject> getSourceRootsFO() {
        return new HashSet<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
    }

    public String[] getProjectSourceRoots() {
        return this.projectSourceRoots;
    }

    public synchronized String[] getAdditionalSourceRoots() {
        return this.additionalSourceRoots == null ? new String[]{} : this.additionalSourceRoots.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderOriginalSourceRoots(int[] permutation) {
        Object object = this;
        synchronized (object) {
            String[] srcRoots = this.getOriginalSourceRoots();
            if (permutation == null) {
                for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                    this.sourcePathPermutation[i] = i;
                }
                this.originalSourcePath = this.unorderedOriginalSourcePath;
                srcRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
            } else {
                int i;
                if (srcRoots.length != permutation.length) {
                    throw new IllegalArgumentException("Bad length of permutation: " + permutation.length + ", have " + srcRoots.length + " source roots.");
                }
                int n = permutation.length;
                String[] unorderedOriginalRoots = this.getSourceRoots(this.unorderedOriginalSourcePath);
                String[] sortedOriginalRoots = new String[n];
                for (i = 0; i < n; ++i) {
                    permutation[i] = this.sourcePathPermutation[permutation[i]];
                    sortedOriginalRoots[i] = unorderedOriginalRoots[permutation[i]];
                }
                for (i = 0; i < n; ++i) {
                    this.sourcePathPermutation[i] = permutation[i];
                }
                this.originalSourcePath = SourcePathProviderImpl.createClassPath(sortedOriginalRoots);
                srcRoots = unorderedOriginalRoots;
            }
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            HashSet<String> smartSteppingRoots = new HashSet<String>(Arrays.asList(this.getSourceRoots(this.smartSteppingSourcePath)));
            String[] orderedSmartSteppingRoots = new String[smartSteppingRoots.size()];
            int i = 0;
            for (String root : this.projectSourceRoots) {
                if (!smartSteppingRoots.contains(root)) continue;
                orderedSmartSteppingRoots[i++] = root;
            }
            this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(orderedSmartSteppingRoots);
            SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, srcRoots, this.sourcePathPermutation);
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] sourceRoots, String[] additionalRoots) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(sourceRoots) + ", " + Arrays.asList(additionalRoots) + ")");
        }
        LinkedHashSet<String> newRoots = new LinkedHashSet<String>(Arrays.asList(sourceRoots));
        ClassPath[] oldCP_ptr = new ClassPath[]{null};
        ClassPath[] newCP_ptr = new ClassPath[]{null};
        Object object = this;
        synchronized (object) {
            LinkedHashSet<String> allAdditionalSourceRoots = new LinkedHashSet<String>(Arrays.asList(additionalRoots));
            int permLength = this.sourcePathPermutation.length;
            Set<String> disabledSourceRoots = this.setSourceRoots(newRoots, oldCP_ptr, newCP_ptr, allAdditionalSourceRoots);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(disabledSourceRoots);
            if (permLength != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
        if (oldCP_ptr[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", oldCP_ptr[0], newCP_ptr[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] sourceRoots) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(sourceRoots) + ")");
        }
        LinkedHashSet<String> newRoots = new LinkedHashSet<String>(Arrays.asList(sourceRoots));
        ClassPath[] oldCP_ptr = new ClassPath[]{null};
        ClassPath[] newCP_ptr = new ClassPath[]{null};
        Object object = this;
        synchronized (object) {
            int permLength = this.sourcePathPermutation.length;
            Set<String> disabledSourceRoots = this.setSourceRoots(newRoots, oldCP_ptr, newCP_ptr, null);
            this.storeAdditionalSourceRoots();
            this.storeDisabledSourceRoots(disabledSourceRoots);
            if (permLength != this.sourcePathPermutation.length) {
                SourcePathProviderImpl.storeSourceRootsOrder(this.baseDir, this.getSourceRoots(this.unorderedOriginalSourcePath), this.sourcePathPermutation);
            }
        }
        object = this.urlCache;
        synchronized (object) {
            this.urlCache.clear();
        }
        object = this.urlCacheGlobal;
        synchronized (object) {
            this.urlCacheGlobal.clear();
        }
        if (oldCP_ptr[0] != null) {
            this.pcs.firePropertyChange("sourceRoots", oldCP_ptr[0], newCP_ptr[0]);
        }
    }

    private synchronized Set<String> setSourceRoots(Set<String> newRoots, ClassPath[] oldCP_ptr, ClassPath[] newCP_ptr, Set<String> allAdditionalSourceRoots) {
        ArrayList<FileObject> sourcePath = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
        ArrayList<FileObject> sourcePathOriginal = new ArrayList<FileObject>(Arrays.asList(this.originalSourcePath.getRoots()));
        ArrayList<FileObject> unorderedSourcePathOriginal = new ArrayList<FileObject>(Arrays.asList(this.unorderedOriginalSourcePath.getRoots()));
        LinkedHashSet<String> newOriginalRoots = new LinkedHashSet<String>(newRoots);
        for (FileObject fo : sourcePathOriginal) {
            newOriginalRoots.remove(SourcePathProviderImpl.getRoot(fo));
        }
        if (!newOriginalRoots.isEmpty()) {
            LinkedHashSet<String> addedOriginalRoots = new LinkedHashSet<String>(newOriginalRoots.size());
            for (String root : newOriginalRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(root);
                if (fo == null || !fo.canRead()) continue;
                sourcePathOriginal.add(fo);
                unorderedSourcePathOriginal.add(fo);
                addedOriginalRoots.add(root);
            }
            newOriginalRoots = addedOriginalRoots;
            if (!newOriginalRoots.isEmpty()) {
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new LinkedHashSet<String>();
                }
                this.additionalSourceRoots.addAll(newOriginalRoots);
            }
        }
        LinkedHashSet<String> newSteppingRoots = new LinkedHashSet<String>(newRoots);
        for (FileObject fo : sourcePath) {
            newSteppingRoots.remove(SourcePathProviderImpl.getRoot(fo));
        }
        HashSet<FileObject> removedSteppingRoots = new HashSet<FileObject>();
        HashSet<FileObject> removedOriginalRoots = new HashSet<FileObject>();
        for (FileObject fo : sourcePath) {
            String spr = SourcePathProviderImpl.getRoot(fo);
            if (newRoots.contains(spr)) continue;
            removedSteppingRoots.add(fo);
            if (this.additionalSourceRoots == null || !this.additionalSourceRoots.contains(spr) || allAdditionalSourceRoots != null && allAdditionalSourceRoots.contains(spr)) continue;
            removedOriginalRoots.add(fo);
            this.additionalSourceRoots.remove(spr);
            if (this.additionalSourceRoots.size() != 0) continue;
            this.additionalSourceRoots = null;
        }
        if (!removedOriginalRoots.isEmpty()) {
            sourcePathOriginal.removeAll(removedOriginalRoots);
        }
        if (!newOriginalRoots.isEmpty() || !removedOriginalRoots.isEmpty()) {
            for (FileObject fo : removedOriginalRoots) {
                int i;
                int index = unorderedSourcePathOriginal.indexOf(fo);
                unorderedSourcePathOriginal.remove(index);
                int pi = this.sourcePathPermutation[index];
                for (i = 0; i < this.sourcePathPermutation.length; ++i) {
                    if (this.sourcePathPermutation[i] <= pi) continue;
                    int n = i;
                    this.sourcePathPermutation[n] = this.sourcePathPermutation[n] - 1;
                }
                for (i = index; i < this.sourcePathPermutation.length - 1; ++i) {
                    this.sourcePathPermutation[i] = this.sourcePathPermutation[i + 1];
                }
            }
            int n = this.sourcePathPermutation.length - removedOriginalRoots.size() + newOriginalRoots.size();
            int[] newSourcePathPermutation = new int[n];
            System.arraycopy(this.sourcePathPermutation, 0, newSourcePathPermutation, 0, this.sourcePathPermutation.length - removedOriginalRoots.size());
            for (int i = this.sourcePathPermutation.length - removedOriginalRoots.size(); i < n; ++i) {
                newSourcePathPermutation[i] = i;
            }
            this.sourcePathPermutation = newSourcePathPermutation;
            this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePathOriginal.toArray(new FileObject[0]));
            this.unorderedOriginalSourcePath = SourcePathProviderImpl.createClassPath(unorderedSourcePathOriginal.toArray(new FileObject[0]));
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
        }
        if (newSteppingRoots.size() > 0 || removedSteppingRoots.size() > 0) {
            for (String root : newSteppingRoots) {
                FileObject fo = SourcePathProviderImpl.getFileObject(root);
                if (fo == null || !fo.canRead()) continue;
                sourcePath.add(fo);
            }
            sourcePath.removeAll(removedSteppingRoots);
            oldCP_ptr[0] = this.smartSteppingSourcePath;
            newCP_ptr[0] = this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePath.toArray(new FileObject[0]));
        }
        HashSet<FileObject> disabledRoots = new HashSet<FileObject>(sourcePathOriginal);
        disabledRoots.removeAll(sourcePath);
        HashSet<String> disabledSourceRoots = new HashSet<String>();
        for (FileObject fo : disabledRoots) {
            disabledSourceRoots.add(SourcePathProviderImpl.getRoot(fo));
        }
        return disabledSourceRoots;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public static String normalize(String path) {
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }

    static String getRoot(FileObject fileObject) {
        File f = null;
        String path = "";
        try {
            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                f = ((JarFileSystem)fileObject.getFileSystem()).getJarFile();
                if (!fileObject.isRoot()) {
                    path = "!/" + fileObject.getPath();
                }
            } else {
                f = FileUtil.toFile((FileObject)fileObject);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (f != null) {
            return f.getAbsolutePath() + path;
        }
        return null;
    }

    private static FileObject getFileObject(String file) {
        File f = new File(file);
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        String path = null;
        if (fo == null && file.contains("!/")) {
            int index = file.indexOf("!/");
            f = new File(file.substring(0, index));
            fo = FileUtil.toFileObject((File)f);
            path = file.substring(index + "!/".length());
        }
        if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
            fo = FileUtil.getArchiveRoot((FileObject)fo);
            if (path != null) {
                fo = fo.getFileObject(path);
            }
        }
        return fo;
    }

    static int[] createPermutation(String[] roots, Map<String, Integer> orderIndexes, String[] sortedRoots) {
        int n = roots.length;
        if (orderIndexes == null) {
            int[] perm = new int[n];
            for (int i = 0; i < n; ++i) {
                sortedRoots[i] = roots[i];
                perm[i] = i;
            }
            return perm;
        }
        class IndexedRoot {
            String root;
            Integer index;
            int order;

            IndexedRoot(String root, Integer index, int order) {
                this.root = root;
                this.index = index;
                this.order = order;
            }
        }
        IndexedRoot[] indexedRoots = new IndexedRoot[n];
        for (int i = 0; i < n; ++i) {
            indexedRoots[i] = new IndexedRoot(roots[i], orderIndexes.get(roots[i]), i);
        }
        class Cmp
        implements Comparator<IndexedRoot> {
            Cmp() {
            }

            @Override
            public int compare(IndexedRoot ir1, IndexedRoot ir2) {
                Integer i1 = ir1.index;
                if (i1 == null) {
                    return 0;
                }
                Integer i2 = ir2.index;
                if (i2 == null) {
                    return 0;
                }
                return i1 - i2;
            }
        }
        Cmp cmp = new Cmp();
        Arrays.sort(indexedRoots, cmp);
        int[] perm = new int[n];
        for (int i = 0; i < n; ++i) {
            sortedRoots[i] = indexedRoots[i].root;
            perm[i] = indexedRoots[i].order;
        }
        return perm;
    }

    private ClassPath reorder(ClassPath sourcePath, final Map<String, Integer> orderIndexes) {
        String[] roots = this.getSourceRoots(sourcePath);
        class Cmp
        implements Comparator<String> {
            Cmp() {
            }

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)orderIndexes.get(o1);
                int i2 = (Integer)orderIndexes.get(o2);
                return i1 - i2;
            }
        }
        Cmp cmp = new Cmp();
        Arrays.sort(roots, cmp);
        return SourcePathProviderImpl.createClassPath(roots);
    }

    private static ClassPath createClassPath(String[] roots) {
        int n = roots.length;
        FileObject[] froots = new FileObject[n];
        for (int i = 0; i < n; ++i) {
            froots[i] = SourcePathProviderImpl.getFileObject(roots[i]);
        }
        return SourcePathProviderImpl.createClassPath(froots);
    }

    private static ClassPath createClassPath(FileObject[] froots) {
        ArrayList<PathResourceImplementation> pris = new ArrayList<PathResourceImplementation>();
        for (FileObject fo : froots) {
            if (fo == null || !fo.canRead()) continue;
            try {
                URL url = fo.getURL();
                pris.add(ClassPathSupport.createResource((URL)url));
            }
            catch (FileStateInvalidException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException iaex) {
                logger.warning(iaex.getLocalizedMessage());
            }
        }
        return ClassPathSupport.createClassPath(pris);
    }

    private ArtifactsUpdatedImpl addArtifactsUpdateListenerFor(JPDADebugger debugger, FileObject src) throws FileStateInvalidException {
        URL url = src.getURL();
        ArtifactsUpdatedImpl l = new ArtifactsUpdatedImpl(debugger, url, src);
        BuildArtifactMapper.addArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)l);
        return l;
    }

    private static final class URLCacheMap
    extends LinkedHashMap<String, String> {
        private static final int URL_CACHE_SIZE = 500;

        public URLCacheMap() {
            super(500, 0.1f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() >= 500;
        }
    }

    static final class FileObjectComparator
    implements Comparator<FileObject> {
        FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            String r1 = SourcePathProviderImpl.getRoot(fo1);
            String r2 = SourcePathProviderImpl.getRoot(fo2);
            if (r1 == null) {
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return r1.compareTo(r2);
        }
    }

    private class PathRegistryListener
    implements GlobalPathRegistryListener,
    PropertyChangeListener {
        private RequestProcessor rp;

        public PathRegistryListener(RequestProcessor rp) {
            this.rp = rp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(final GlobalPathRegistryEvent event) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.pathsAdded(event);
                    }
                });
                return;
            }
            ArrayList<FileObject> addedRoots = new ArrayList<FileObject>();
            for (ClassPath cp : event.getChangedPaths()) {
                for (FileObject fo : cp.getRoots()) {
                    addedRoots.add(fo);
                }
            }
            if (addedRoots.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    ArrayList<FileObject> sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    sourcePaths.addAll(addedRoots);
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                    sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    sourcePaths.addAll(addedRoots);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                }
                object = SourcePathProviderImpl.this.urlCache;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCache.clear();
                }
                object = SourcePathProviderImpl.this.urlCacheGlobal;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCacheGlobal.clear();
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(final GlobalPathRegistryEvent event) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.pathsRemoved(event);
                    }
                });
                return;
            }
            ArrayList<FileObject> removedRoots = new ArrayList<FileObject>();
            for (ClassPath cp : event.getChangedPaths()) {
                for (FileObject fo : cp.getRoots()) {
                    removedRoots.add(fo);
                }
            }
            if (removedRoots.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    if (SourcePathProviderImpl.this.originalSourcePath == null) {
                        return;
                    }
                    ArrayList<FileObject> sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    sourcePaths.removeAll(removedRoots);
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                    sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    sourcePaths.removeAll(removedRoots);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                }
                object = SourcePathProviderImpl.this.urlCache;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCache.clear();
                }
                object = SourcePathProviderImpl.this.urlCacheGlobal;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCacheGlobal.clear();
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (EventQueue.isDispatchThread()) {
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        PathRegistryListener.this.propertyChange(evt);
                    }
                });
                return;
            }
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            boolean changed = false;
            Object object = SourcePathProviderImpl.this;
            synchronized (object) {
                if (SourcePathProviderImpl.this.originalSourcePath == null) {
                    return;
                }
                SourcePathProviderImpl.this.platformSourceRoots.clear();
                ArrayList<FileObject> sourcePaths = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                for (JavaPlatform jp : platforms) {
                    FileObject[] roots;
                    for (FileObject fo : roots = jp.getSourceFolders().getRoots()) {
                        if (sourcePaths.contains(fo)) continue;
                        sourcePaths.add(fo);
                        changed = true;
                    }
                    SourcePathProviderImpl.this.platformSourceRoots.addAll(SourcePathProviderImpl.getSourceRootsSet(jp.getSourceFolders()));
                }
                if (changed) {
                    SourcePathProviderImpl.this.originalSourcePath = SourcePathProviderImpl.createClassPath(sourcePaths.toArray(new FileObject[0]));
                }
            }
            if (changed) {
                object = SourcePathProviderImpl.this.urlCache;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCache.clear();
                }
                object = SourcePathProviderImpl.this.urlCacheGlobal;
                synchronized (object) {
                    SourcePathProviderImpl.this.urlCacheGlobal.clear();
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }
    }

    private static class ArtifactsUpdatedImpl
    implements BuildArtifactMapper.ArtifactsUpdated {
        private Reference<JPDADebugger> debuggerRef;
        private final URL url;
        private FileObject src;

        public ArtifactsUpdatedImpl(JPDADebugger debugger, URL url, FileObject src) {
            this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
            this.url = url;
            this.src = src;
        }

        public URL getURL() {
            return this.url;
        }

        public void artifactsUpdated(Iterable<File> artifacts) {
            String error = null;
            JPDADebugger debugger = this.debuggerRef.get();
            if (debugger == null) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoJPDADebugger");
            } else if (!debugger.canFixClasses()) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_CanNotFix");
            } else if (debugger.getState() == 4) {
                error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_NoDebug");
            }
            boolean canFixClasses = Properties.getDefault().getProperties("debugger.options.JPDA").getBoolean("ApplyCodeChangesOnSave", CAN_FIX_CLASSES_AUTOMATICALLY);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("artifactsUpdated(" + artifacts + ") error = '" + error + "', canFixClasses = " + canFixClasses);
            }
            if (error == null) {
                if (!canFixClasses) {
                    for (File f : artifacts) {
                        FileObject fo = FileUtil.toFileObject((File)f);
                        if (fo == null) continue;
                        String className = ArtifactsUpdatedImpl.fileToClassName(fo);
                        FixActionProvider.ClassesToReload.getInstance().addClassToReload(debugger, this.src, className, fo);
                    }
                    return;
                }
                HashMap<String, FileObject> classes = new HashMap<String, FileObject>();
                for (File f : artifacts) {
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (fo == null) continue;
                    String className = ArtifactsUpdatedImpl.fileToClassName(fo);
                    classes.put(className, fo);
                }
                FixActionProvider.reloadClasses(debugger, classes);
            } else {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
            if (error != null && canFixClasses) {
                FixActionProvider.notifyError(error);
            }
        }

        private static String fileToClassName(FileObject fo) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
            return cp.getResourceName(fo, '.', false);
        }
    }
}

