/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.netbeans.modules.java.debug.TreeNavigatorJavaSourceFactory;
import org.netbeans.modules.java.debug.TreeNode;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TreeNavigatorProviderImpl
implements NavigatorPanel {
    private JComponent panel;
    private final ExplorerManager manager = new ExplorerManager();
    private static final AttributeSet HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(224, 224, 224)});
    private static final AttributeSet HIGHLIGHT_PREF = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, new Color(30, 255, 0)});

    public TreeNavigatorProviderImpl() {
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    TreeNavigatorProviderImpl.setHighlights(TreeNavigatorJavaSourceFactory.getInstance().getFile(), TreeNavigatorProviderImpl.this.manager);
                }
            }
        });
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TreeNavigatorProviderImpl.class, (String)"NM_Trees");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(TreeNavigatorProviderImpl.class, (String)"SD_Trees");
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            final BeanTreeView view = new BeanTreeView();
            view.setRootVisible(true);
            view.setUseSubstringInQuickSearch(true);
            view.setSelectionMode(0);
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                private final Lookup lookup;

                Panel() {
                    this.lookup = ExplorerUtils.createLookup((ExplorerManager)TreeNavigatorProviderImpl.this.manager, (ActionMap)new ActionMap());
                    this.setLayout(new BorderLayout());
                    this.add((Component)view, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return TreeNavigatorProviderImpl.this.manager;
                }

                public Lookup getLookup() {
                    return this.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public Lookup getLookup() {
        return null;
    }

    public void panelActivated(Lookup context) {
        TreeNavigatorJavaSourceFactory.getInstance().setLookup(context, new TaskImpl());
        TreeNavigatorJavaSourceFactory.CaretAwareFactoryImpl.getInstance().setTask(new SelectingTaskImpl());
    }

    public void panelDeactivated() {
        TreeNavigatorJavaSourceFactory.getInstance().setLookup(Lookup.EMPTY, null);
        TreeNavigatorJavaSourceFactory.CaretAwareFactoryImpl.getInstance().setTask(null);
    }

    static OffsetsBag getBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(TreeNavigatorProviderImpl.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(TreeNavigatorProviderImpl.class, bag);
        }
        return bag;
    }

    static void setHighlights(FileObject file, ExplorerManager manager) {
        if (file == null) {
            return;
        }
        try {
            DataObject od = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            StyledDocument doc = ec.getDocument();
            if (doc == null) {
                return;
            }
            OffsetsBag bag = new OffsetsBag((Document)doc, true);
            for (Node n : manager.getSelectedNodes()) {
                if (!(n instanceof OffsetProvider)) continue;
                OffsetProvider p = (OffsetProvider)n;
                int start = p.getStart();
                int end = p.getEnd();
                int pref = p.getPreferredPosition();
                if (start >= 0 && end >= 0) {
                    bag.addHighlight(start, end, HIGHLIGHT);
                }
                if (pref < 0) continue;
                bag.addHighlight(pref, pref + 1, HIGHLIGHT_PREF);
            }
            TreeNavigatorProviderImpl.getBag(doc).setHighlights(bag);
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger(TreeNavigatorProviderImpl.class.getName()).log(Level.FINE, null, ex);
        }
    }

    private static TreePath plainPathFor(final CompilationInfo info, int pos) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath path) {
                this.path = path;
            }
        }
        try {
            class PathFinder
            extends TreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int pos, SourcePositions sourcePositions) {
                    this.pos = pos;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    if (tree != null && this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree) >= (long)this.pos) {
                        super.scan(tree, p);
                        throw new Result(new TreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    int[] span = info.getTreeUtilities().findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    int[] span = info.getTreeUtilities().findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitMethod(node, p);
                }
            }
            new PathFinder(pos, info.getTrees().getSourcePositions()).scan(new TreePath(info.getCompilationUnit()), null);
            return null;
        }
        catch (Result result) {
            return result.path;
        }
    }

    private final class SelectingTaskImpl
    implements CancellableTask<CompilationInfo> {
        private SelectingTaskImpl() {
        }

        public void cancel() {
        }

        public void run(CompilationInfo info) throws PropertyVetoException {
            Node toSelect;
            int pos = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
            TreePath tp = TreeNavigatorProviderImpl.plainPathFor(info, pos);
            Node node = toSelect = tp != null ? TreeNode.findNode(TreeNavigatorProviderImpl.this.manager.getRootContext(), tp) : null;
            if (toSelect != null) {
                TreeNavigatorProviderImpl.this.manager.setExploredContext(toSelect);
                TreeNavigatorProviderImpl.this.manager.setSelectedNodes(new Node[]{toSelect});
            } else {
                TreeNavigatorProviderImpl.this.manager.setSelectedNodes(new Node[0]);
            }
        }
    }

    private final class TaskImpl
    implements CancellableTask<CompilationInfo> {
        private final AtomicBoolean cancel = new AtomicBoolean();

        private TaskImpl() {
        }

        public void cancel() {
            this.cancel.set(true);
        }

        public void run(CompilationInfo info) {
            this.cancel.set(false);
            Node tree = TreeNode.getTree(info, new TreePath(info.getCompilationUnit()), this.cancel);
            if (!this.cancel.get()) {
                TreeNavigatorProviderImpl.this.manager.setRootContext(tree);
            }
        }
    }
}

