/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstFalse;
import com.sun.el.parser.AstFloatingPoint;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstInteger;
import com.sun.el.parser.AstMethodSuffix;
import com.sun.el.parser.AstPropertySuffix;
import com.sun.el.parser.AstString;
import com.sun.el.parser.AstTrue;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParser;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ELTypeUtilities {
    private static final String FACES_CONTEXT_CLASS = "javax.faces.context.FacesContext";
    private static final String UI_COMPONENT_CLASS = "javax.faces.component.UIComponent";
    private final ClasspathInfo cpInfo;
    private final FileObject file;
    private static final Map<Class<? extends Node>, Set<TypeKind>> TYPES = new HashMap<Class<? extends Node>, Set<TypeKind>>();

    private static void put(Class<? extends Node> node, TypeKind ... kinds) {
        HashSet<TypeKind> kindSet = new HashSet<TypeKind>();
        kindSet.addAll(Arrays.asList(kinds));
        TYPES.put(node, kindSet);
    }

    private ELTypeUtilities(FileObject context, ClasspathInfo cpInfo) {
        assert (cpInfo != null);
        this.cpInfo = cpInfo;
        this.file = context;
    }

    public static ELTypeUtilities create(FileObject context) {
        ClasspathInfo cp = ClasspathInfo.create((FileObject)context);
        return new ELTypeUtilities(context, cp);
    }

    public static ELTypeUtilities create(FileObject context, ClasspathInfo cpInfo) {
        return new ELTypeUtilities(context, cpInfo);
    }

    public String getTypeNameFor(Element element) {
        final TypeMirror tm = this.getTypeMirrorFor(element);
        SourceTask<String> task = new SourceTask<String>(){

            public void run(CompilationController info) throws Exception {
                this.setResult(((Object)info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0])).toString());
            }
        };
        this.runTask(task);
        return (String)task.getResult();
    }

    public Element getTypeFor(Element element) {
        final TypeMirror tm = this.getTypeMirrorFor(element);
        SourceTask<Element> task = new SourceTask<Element>(){

            public void run(CompilationController info) throws Exception {
                this.setResult(info.getTypes().asElement(tm));
            }
        };
        this.runTask(task);
        return (Element)task.getResult();
    }

    public Element resolveElement(ELElement elem, Node target) {
        TypeResolverVisitor typeResolver = new TypeResolverVisitor(elem, target);
        elem.getNode().accept((NodeVisitor)typeResolver);
        return typeResolver.getResult();
    }

    public TypeMirror getReturnType(final ExecutableElement method) {
        SourceTask<TypeMirror> task = new SourceTask<TypeMirror>(){

            public void run(CompilationController info) throws Exception {
                TypeKind returnTypeKind = method.getReturnType().getKind();
                if (returnTypeKind.isPrimitive()) {
                    this.setResult(info.getTypes().getPrimitiveType(returnTypeKind));
                } else if (returnTypeKind == TypeKind.VOID) {
                    this.setResult(info.getTypes().getNoType(returnTypeKind));
                } else {
                    this.setResult(method.getReturnType());
                }
            }
        };
        this.runTask(task);
        return (TypeMirror)task.getResult();
    }

    public boolean isSameMethod(Node methodNode, ExecutableElement method) {
        String image = methodNode.getImage();
        String methodName = method.getSimpleName().toString();
        if (image == null) {
            return false;
        }
        int methodParams = method.getParameters().size();
        if (methodNode instanceof AstMethodSuffix && (methodName.equals(image) || RefactoringUtil.getPropertyName(methodName).equals(image))) {
            int methodNodeParams = ((AstMethodSuffix)methodNode).jjtGetNumChildren();
            if (method.isVarArgs()) {
                return methodParams == 1 ? true : methodNodeParams >= methodParams;
            }
            return method.getParameters().size() == methodNodeParams && this.haveSameParameters((AstMethodSuffix)methodNode, method);
        }
        if (methodNode instanceof AstPropertySuffix && (methodName.equals(image) || RefactoringUtil.getPropertyName(methodName).equals(image))) {
            if (this.isValidatorMethod(method)) {
                return true;
            }
            return method.isVarArgs() ? method.getParameters().size() == 1 : method.getParameters().isEmpty();
        }
        return false;
    }

    public TypeElement getElementForType(final String clazz) {
        SourceTask<TypeElement> task = new SourceTask<TypeElement>(){

            public void run(CompilationController info) throws Exception {
                TypeElement typeElement = info.getElements().getTypeElement(clazz);
                this.setResult(typeElement);
            }
        };
        this.runTask(task);
        return (TypeElement)task.getResult();
    }

    public List<String> getParameterNames(final ExecutableElement method) {
        SourceTask<List<String>> task = new SourceTask<List<String>>(){

            public void run(CompilationController info) throws Exception {
                ArrayList<String> result = new ArrayList<String>();
                for (VariableElement variableElement : method.getParameters()) {
                    result.add(variableElement.getSimpleName().toString());
                }
                this.setResult(result);
            }
        };
        this.runTask(task);
        return (List)task.getResult();
    }

    public String getParametersAsString(final ExecutableElement method) {
        SourceTask<String> task = new SourceTask<String>(){

            public void run(CompilationController info) throws Exception {
                StringBuilder result = new StringBuilder();
                for (VariableElement variableElement : method.getParameters()) {
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    String type = ((Object)info.getTypeUtilities().getTypeName(variableElement.asType(), new TypeUtilities.TypeNameOptions[0])).toString();
                    result.append(type);
                    result.append(" ");
                    result.append(variableElement.getSimpleName().toString());
                }
                if (result.length() > 0) {
                    result.insert(0, "(");
                    result.append(")");
                }
                this.setResult(result.toString());
            }
        };
        this.runTask(task);
        return (String)task.getResult();
    }

    public Collection<ImplicitObject> getImplicitObjects() {
        return ELPlugin.Query.getImplicitObjects(this.file);
    }

    public boolean isScopeObject(Node target) {
        if (!(target instanceof AstIdentifier)) {
            return false;
        }
        for (ImplicitObject each : this.getImplicitObjects()) {
            if (each.getType() != ImplicitObjectType.SCOPE_TYPE || !each.getName().equals(target.getImage())) continue;
            return true;
        }
        return false;
    }

    public boolean isRawObject(Node target) {
        if (!(target instanceof AstIdentifier)) {
            return false;
        }
        for (ImplicitObject each : this.getImplicitObjects()) {
            if (each.getType() != ImplicitObjectType.RAW || !each.getName().equals(target.getImage())) continue;
            return true;
        }
        return false;
    }

    private TypeMirror getTypeMirrorFor(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            return this.getReturnType((ExecutableElement)element);
        }
        return element.asType();
    }

    private void runTask(SourceTask<?> task) {
        try {
            JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]).runUserActionTask(task, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        task.setComputed(true);
    }

    private boolean isValidatorMethod(ExecutableElement method) {
        if (method.getParameters().size() != 3) {
            return false;
        }
        VariableElement param1 = method.getParameters().get(0);
        VariableElement param2 = method.getParameters().get(1);
        CharSequence param1Type = this.getTypeName(param1.asType());
        CharSequence param2Type = this.getTypeName(param2.asType());
        return FACES_CONTEXT_CLASS.equals(param1Type) && UI_COMPONENT_CLASS.equals(param2Type);
    }

    private CharSequence getTypeName(final TypeMirror type) {
        SourceTask<CharSequence> task = new SourceTask<CharSequence>(){

            public void run(CompilationController info) throws Exception {
                this.setResult(info.getTypeUtilities().getTypeName(type, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}));
            }
        };
        this.runTask(task);
        return (CharSequence)task.getResult();
    }

    private boolean haveSameParameters(AstMethodSuffix methodNode, ExecutableElement method) {
        for (int i = 0; i < methodNode.jjtGetNumChildren(); ++i) {
            Node paramNode = methodNode.jjtGetChild(i);
            if (this.isSameType(paramNode, method.getParameters().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameType(final Node paramNode, final VariableElement param) {
        SourceTask<Boolean> task = new SourceTask<Boolean>(){

            public void run(CompilationController info) throws Exception {
                TypeKind paramKind = param.asType().getKind();
                if (!paramKind.isPrimitive()) {
                    try {
                        PrimitiveType unboxedType = info.getTypes().unboxedType(param.asType());
                        paramKind = unboxedType.getKind();
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                }
                if (TYPES.containsKey(paramNode.getClass())) {
                    this.setResult(((Set)TYPES.get(paramNode.getClass())).contains((Object)paramKind));
                }
                if (paramNode instanceof AstString) {
                    CharSequence typeName = info.getTypeUtilities().getTypeName(param.asType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN});
                    this.setResult(String.class.getName().contentEquals(typeName));
                }
                this.setResult(true);
            }
        };
        this.runTask(task);
        return (Boolean)task.getResult();
    }

    private ExecutableElement getElementForProperty(Node property, Element enclosing) {
        for (ExecutableElement each : ElementFilter.methodsIn(enclosing.getEnclosedElements())) {
            if (!each.getModifiers().contains((Object)Modifier.PUBLIC) || !this.isSameMethod(property, each)) continue;
            return each;
        }
        return null;
    }

    private Element getIdentifierType(final AstIdentifier identifier, final ELElement element) {
        String tempClass = null;
        for (ImplicitObject implicitObject : this.getImplicitObjects()) {
            if (!implicitObject.getName().equals(identifier.getImage())) continue;
            if (implicitObject.getClazz() == null || implicitObject.getClazz().isEmpty()) break;
            tempClass = implicitObject.getClazz();
            break;
        }
        if (tempClass == null) {
            tempClass = ELVariableResolvers.findBeanClass(identifier.getImage(), element.getSnapshot().getSource().getFileObject());
        }
        final String clazz = tempClass;
        SourceTask<Element> task = new SourceTask<Element>(){

            public void run(CompilationController info) throws Exception {
                if (clazz != null) {
                    this.setResult(info.getElements().getTypeElement(clazz));
                    return;
                }
                int offset = element.getOriginalOffset().getStart() + identifier.startOffset();
                List<ELVariableResolver.VariableInfo> vis = ELVariableResolvers.getVariables(element.getSnapshot(), offset);
                for (ELVariableResolver.VariableInfo vi : vis) {
                    if (!identifier.getImage().equals(vi.name)) continue;
                    try {
                        Node expressionNode = ELParser.parse(vi.expression);
                        if (expressionNode == null) continue;
                        this.setResult(ELTypeUtilities.this.getReferredType(expressionNode, element.getSnapshot().getSource().getFileObject(), info));
                        return;
                    }
                    catch (ELException e) {
                    }
                }
            }
        };
        this.runTask(task);
        return (Element)task.getResult();
    }

    public Element getReferredType(Node expression, final FileObject context, final CompilationController info) {
        final Element[] result = new Element[1];
        expression.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String beanClass = ELVariableResolvers.findBeanClass(node.getImage(), context);
                    if (beanClass == null) {
                        return;
                    }
                    Element enclosing = info.getElements().getTypeElement(beanClass);
                    ExecutableElement method = null;
                    Node current = parent;
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        current = parent.jjtGetChild(i);
                        if (!(current instanceof AstPropertySuffix) && !(current instanceof AstMethodSuffix) || (method = ELTypeUtilities.this.getElementForProperty(current, enclosing)) == null) continue;
                        enclosing = info.getTypes().asElement(ELTypeUtilities.this.getReturnType(method));
                    }
                    if (method == null) {
                        return;
                    }
                    TypeMirror returnType = ELTypeUtilities.this.getReturnType(method);
                    if (returnType instanceof DeclaredType) {
                        List<? extends TypeMirror> typeArguments = ((DeclaredType)returnType).getTypeArguments();
                        Iterator<? extends TypeMirror> i$ = typeArguments.iterator();
                        if (i$.hasNext()) {
                            TypeMirror arg = i$.next();
                            result[0] = info.getTypes().asElement(arg);
                            return;
                        }
                        result[0] = info.getTypes().asElement(returnType);
                    }
                }
            }
        });
        return result[0];
    }

    private TypeElement getTypeFor(final String clazz) {
        SourceTask<TypeElement> task = new SourceTask<TypeElement>(){

            public void run(CompilationController info) throws Exception {
                this.setResult(info.getElements().getTypeElement(clazz));
            }
        };
        this.runTask(task);
        return (TypeElement)task.getResult();
    }

    static {
        ELTypeUtilities.put(AstFloatingPoint.class, TypeKind.FLOAT, TypeKind.DOUBLE);
        ELTypeUtilities.put(AstTrue.class, TypeKind.BOOLEAN);
        ELTypeUtilities.put(AstFalse.class, TypeKind.BOOLEAN);
        ELTypeUtilities.put(AstInteger.class, TypeKind.INT, TypeKind.SHORT, TypeKind.LONG);
    }

    private static abstract class SourceTask<T>
    implements Task<CompilationController> {
        private volatile T result;
        private volatile boolean computed;

        private SourceTask() {
        }

        public void setComputed(boolean computed) {
            this.computed = computed;
        }

        public T getResult() {
            assert (this.computed);
            return this.result;
        }

        public void setResult(T result) {
            this.result = result;
        }
    }

    private class TypeResolverVisitor
    implements NodeVisitor {
        private final ELElement elem;
        private final Node target;
        private Element result;

        public TypeResolverVisitor(ELElement elem, Node target) {
            this.elem = elem;
            this.target = target;
        }

        public Element getResult() {
            return this.result;
        }

        public void visit(Node node) {
            Element enclosing = null;
            if (node instanceof AstIdentifier && (enclosing = ELTypeUtilities.this.getIdentifierType((AstIdentifier)node, this.elem)) != null) {
                if (node.equals(this.target)) {
                    this.result = enclosing;
                    return;
                }
                Node parent = node.jjtGetParent();
                for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                    Node child = parent.jjtGetChild(i);
                    if (!(child instanceof AstPropertySuffix) && !(child instanceof AstMethodSuffix)) continue;
                    Parameterizable propertyType = ELTypeUtilities.this.getElementForProperty(child, enclosing);
                    if (propertyType == null && i > 0 && ELTypeUtilities.this.isScopeObject(parent.jjtGetChild(i - 1))) {
                        String clazz = ELVariableResolvers.findBeanClass(child.getImage(), this.elem.getSnapshot().getSource().getFileObject());
                        if (clazz == null) {
                            return;
                        }
                        propertyType = ELTypeUtilities.this.getTypeFor(clazz);
                    }
                    if (propertyType == null) {
                        return;
                    }
                    if (child.equals(this.target)) {
                        this.result = propertyType;
                        continue;
                    }
                    if (propertyType.getKind() == ElementKind.METHOD) {
                        final ExecutableElement method = propertyType;
                        SourceTask<Element> task = new SourceTask<Element>(){

                            public void run(CompilationController info) throws Exception {
                                this.setResult(info.getTypes().asElement(ELTypeUtilities.this.getReturnType(method)));
                            }
                        };
                        ELTypeUtilities.this.runTask(task);
                        enclosing = (Element)task.getResult();
                        if (enclosing != null) continue;
                        return;
                    }
                    enclosing = propertyType;
                }
            }
        }
    }
}

