/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ELVariableResolvers {
    private ELVariableResolvers() {
    }

    public static String findBeanClass(String beanName, FileObject context) {
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            String beanClass = eLVariableResolver.getBeanClass(beanName, context);
            if (beanClass == null) continue;
            return beanClass;
        }
        return null;
    }

    public static String findBeanName(String clazz, FileObject context) {
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            String beanName = eLVariableResolver.getBeanName(clazz, context);
            if (beanName == null) continue;
            return beanName;
        }
        return null;
    }

    public static List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject context) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            result.addAll(eLVariableResolver.getManagedBeans(context));
        }
        return result;
    }

    public static List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            result.addAll(eLVariableResolver.getVariables(snapshot, offset));
        }
        return result;
    }

    public static List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot context) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            result.addAll(eLVariableResolver.getBeansInScope(scope, context));
        }
        return result;
    }

    public static List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot context) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (ELVariableResolver eLVariableResolver : ELVariableResolvers.getResolvers()) {
            result.addAll(eLVariableResolver.getRawObjectProperties(name, context));
        }
        return result;
    }

    private static Collection<? extends ELVariableResolver> getResolvers() {
        return Lookup.getDefault().lookupAll(ELVariableResolver.class);
    }
}

