/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.Node;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.web.el.ELElement;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class RefactoringUtil {
    private RefactoringUtil() {
    }

    public static CompilationInfo getCompilationInfo(TreePathHandle handle, final AbstractRefactoring refactoring) {
        CompilationInfo existing = (CompilationInfo)refactoring.getRefactoringSource().lookup(CompilationInfo.class);
        if (existing != null) {
            return existing;
        }
        ClasspathInfo cpInfo = (ClasspathInfo)refactoring.getContext().lookup(ClasspathInfo.class);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{handle.getFileObject()});
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController co) throws Exception {
                    co.toPhase(JavaSource.Phase.RESOLVED);
                    refactoring.getContext().add((Object)co);
                }

                public void cancel() {
                }
            }, false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return (CompilationInfo)refactoring.getContext().lookup(CompilationInfo.class);
    }

    static String encodeAndHighlight(String text, OffsetRange expressionOffset, OffsetRange nodeOffset) {
        StringBuilder result = new StringBuilder(text.length() + 7);
        String expression = text.substring(expressionOffset.getStart(), expressionOffset.getEnd());
        result.append(RefactoringUtil.encodeAngleBrackets(text.substring(0, expressionOffset.getStart())));
        result.append(RefactoringUtil.highlight(expression, nodeOffset));
        result.append(RefactoringUtil.encodeAngleBrackets(text.substring(expressionOffset.getEnd(), text.length())));
        return result.toString();
    }

    private static String encodeAngleBrackets(String str) {
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String highlight(String text, OffsetRange offsetRange) {
        StringBuilder result = new StringBuilder(text.length() + 7);
        result.append(text.substring(0, offsetRange.getStart()));
        result.append("<b>");
        result.append(RefactoringUtil.encodeAngleBrackets(((Object)text.subSequence(offsetRange.getStart(), offsetRange.getEnd())).toString()));
        result.append("</b>");
        result.append(text.substring(offsetRange.getEnd(), text.length()));
        return result.toString();
    }

    public static String getPropertyName(String accessor) {
        return RefactoringUtil.getPropertyName(accessor, false);
    }

    public static String getPropertyName(String accessor, boolean includeSetter) {
        Parameters.notEmpty((CharSequence)"accessor", (CharSequence)accessor);
        int prefixLength = RefactoringUtil.getPrefixLength(accessor, includeSetter);
        String withoutPrefix = accessor.substring(prefixLength);
        if (withoutPrefix.isEmpty()) {
            return accessor;
        }
        char firstChar = withoutPrefix.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return accessor;
        }
        if (withoutPrefix.length() > 1 && Character.isUpperCase(withoutPrefix.charAt(1))) {
            return withoutPrefix;
        }
        return Character.toLowerCase(firstChar) + withoutPrefix.substring(1);
    }

    private static int getPrefixLength(String accessor, boolean includeSetter) {
        ArrayList<String> accessorPrefixes = new ArrayList<String>();
        accessorPrefixes.add("get");
        if (includeSetter) {
            accessorPrefixes.add("set");
        }
        accessorPrefixes.add("is");
        for (String prefix : accessorPrefixes) {
            if (!accessor.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    static PositionRef[] getPostionRefs(ELElement elem, Node targetNode) {
        int startOffset = elem.getOriginalOffset().getStart() + targetNode.startOffset();
        int endOffset = startOffset + targetNode.getImage().length();
        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)elem.getSnapshot().getSource().getFileObject());
        PositionRef start = editor.createPositionRef(startOffset, Position.Bias.Forward);
        PositionRef end = editor.createPositionRef(endOffset, Position.Bias.Backward);
        return new PositionRef[]{start, end};
    }
}

