/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.Node;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.refactoring.ELRefactoringPlugin;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class WhereUsedQueryElement
extends SimpleRefactoringElementImplementation {
    private final FileObject file;
    private final String reference;
    private final ELElement eLElement;
    private final ELRefactoringPlugin.ParserResultHolder parserResult;
    private final Node targetNode;

    public WhereUsedQueryElement(FileObject file, String reference, ELElement eLElement, Node targetNode, ELRefactoringPlugin.ParserResultHolder parserResult) {
        this.file = file;
        this.reference = reference;
        this.eLElement = eLElement;
        this.parserResult = parserResult;
        this.targetNode = targetNode;
    }

    public String getText() {
        return this.reference;
    }

    public String getDisplayText() {
        try {
            CharSequence text = this.parserResult.topLevelSnapshot.getText();
            OffsetRange orig = this.eLElement.getOriginalOffset();
            int astLineStart = GsfUtilities.getRowStart((CharSequence)text, (int)orig.getStart());
            int astLineEnd = GsfUtilities.getRowEnd((CharSequence)text, (int)orig.getEnd());
            OffsetRange nodeOffset = new OffsetRange(this.targetNode.startOffset(), this.targetNode.endOffset());
            int expressionStart = orig.getStart() - astLineStart;
            int expressionEnd = expressionStart + (orig.getEnd() - orig.getStart());
            OffsetRange expressionOffset = new OffsetRange(expressionStart, expressionEnd);
            CharSequence line = text.subSequence(astLineStart, astLineEnd);
            return RefactoringUtil.encodeAndHighlight(((Object)line).toString(), expressionOffset, nodeOffset).trim();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.eLElement.getExpression();
        }
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.file);
    }

    public FileObject getParentFile() {
        return this.file;
    }

    public PositionBounds getPosition() {
        PositionRef[] position = RefactoringUtil.getPostionRefs(this.eLElement, this.targetNode);
        return new PositionBounds(position[0], position[1]);
    }
}

