/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNamespace;
import org.netbeans.tax.TreeParentNode;

public class TreeNamespaceContext {
    private TreeElement element;
    private static Map definedNS = new HashMap();

    protected TreeNamespaceContext(TreeElement element) {
        this.element = element;
    }

    public String getURI(String prefix) {
        TreeElement parentElement;
        TreeParentNode parentNode;
        TreeNamespace ns = (TreeNamespace)definedNS.get(prefix);
        if (ns != null) {
            return ns.getURI();
        }
        TreeNamedObjectMap attrs = this.element.getAttributes();
        if (attrs != null) {
            Iterator it = attrs.iterator();
            while (it.hasNext()) {
                TreeAttribute next = (TreeAttribute)it.next();
                TreeName name = next.getTreeName();
                if (!("xmlns".equals(name.getPrefix()) ? prefix.equals(name.getName()) : "xmlns".equals(name.getQualifiedName()))) continue;
                return next.getValue();
            }
        }
        if ((parentNode = this.element.getParentNode()) instanceof TreeElement && (parentElement = (TreeElement)parentNode) != null) {
            return parentElement.getNamespaceContext().getURI(prefix);
        }
        return null;
    }

    static {
        TreeNamespace namespace = TreeNamespace.XML_NAMESPACE;
        definedNS.put(namespace.getPrefix(), namespace);
        namespace = TreeNamespace.XMLNS_NAMESPACE;
        definedNS.put(namespace.getPrefix(), namespace);
    }
}

