/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class NbApplicationAdapter
implements ApplicationListener {
    private static final String OPTIONS_ACTION = "Actions/Window/org-netbeans-modules-options-OptionsWindowAction.instance";
    private static final String ABOUT_ACTION = "Actions/Help/org-netbeans-core-actions-AboutAction.instance";
    private static final String EXIT_ACTION = "Actions/System/org-netbeans-core-actions-SystemExit.instance";
    private static ApplicationListener al = null;

    private NbApplicationAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install() {
        boolean wasDesignTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(false);
            al = new NbApplicationAdapter();
            Application.getApplication().addApplicationListener(al);
            Application.getApplication().setEnabledAboutMenu(true);
            Application.getApplication().setEnabledPreferencesMenu(true);
        }
        finally {
            Beans.setDesignTime(wasDesignTime);
        }
    }

    static void uninstall() {
        if (al != null) {
            Application.getApplication().removeApplicationListener(al);
            al = null;
        }
    }

    public void handleAbout(ApplicationEvent e) {
        e.setHandled(this.performAction(ABOUT_ACTION));
    }

    public void handleOpenApplication(ApplicationEvent e) {
    }

    public void handleOpenFile(ApplicationEvent e) {
        FileObject obj;
        boolean result = false;
        String fname = e.getFilename();
        File f = new File(fname);
        if (f.exists() && !f.isDirectory() && (obj = FileUtil.toFileObject((File)f)) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)obj);
                OpenCookie oc = (OpenCookie)dob.getLookup().lookup(OpenCookie.class);
                result = oc != null;
                if (result) {
                    oc.open();
                } else {
                    EditCookie ec = (EditCookie)dob.getLookup().lookup(EditCookie.class);
                    result = ec != null;
                    if (result) {
                        ec.edit();
                    } else {
                        ViewCookie v = (ViewCookie)dob.getLookup().lookup(ViewCookie.class);
                        result = v != null;
                        if (result) {
                            v.view();
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, fname, ex);
            }
        }
        e.setHandled(result);
    }

    public void handlePreferences(ApplicationEvent e) {
        e.setHandled(this.performAction(OPTIONS_ACTION));
    }

    public void handlePrintFile(ApplicationEvent e) {
    }

    public void handleQuit(ApplicationEvent e) {
        e.setHandled(!this.performAction(EXIT_ACTION));
    }

    public void handleReOpenApplication(ApplicationEvent e) {
    }

    private boolean performAction(String key) {
        return this.performAction(key, null);
    }

    private boolean performAction(String key, String command) {
        Action a = this.findAction(key);
        if (a == null) {
            return false;
        }
        if (command == null) {
            command = "foo";
        }
        ActionEvent ae = new ActionEvent(this, 1001, command);
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return false;
        }
    }

    private Action findAction(String key) {
        FileObject fo = FileUtil.getConfigFile((String)key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    return (Action)instance;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

