/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class TooltipWindow
extends JWindow
implements AWTEventListener {
    private static final int SCREEN_BORDER = 20;
    private final JComponent content;

    public TooltipWindow(Window parent, JComponent content) {
        super(parent);
        this.content = content;
    }

    public void show(Point location) {
        GraphicsDevice device;
        GraphicsConfiguration gc;
        GraphicsDevice[] gds;
        this.add(this.content);
        this.pack();
        Dimension dim = this.getSize();
        Rectangle screenBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] arr$ = gds = ge.getScreenDevices();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(screenBounds = (gc = (device = arr$[i$]).getDefaultConfiguration()).getBounds()).contains(location); ++i$) {
        }
        if (location.y + dim.height + 20 > screenBounds.y + screenBounds.height) {
            dim.height = screenBounds.y + screenBounds.height - (location.y + 20);
        }
        if (location.x + dim.width + 20 > screenBounds.x + screenBounds.width) {
            dim.width = screenBounds.x + screenBounds.width - (location.x + 20);
        }
        this.setSize(dim);
        this.setLocation(location.x, location.y - 1);
        this.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501) {
            this.onClick(event);
        } else if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27) {
            this.shutdown();
        }
    }

    private void onClick(AWTEvent event) {
        Component component = (Component)event.getSource();
        Window w = SwingUtilities.windowForComponent(component);
        if (w != this) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.dispose();
    }
}

