/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Image;
import java.io.CharConversionException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNodeChildren;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class TestMethodNode
extends AbstractNode {
    private static final boolean INLINE_RESULTS = Boolean.valueOf(System.getProperty("gsf.testrunner.inline_result", "true"));
    protected final Testcase testcase;
    protected final Project project;

    public TestMethodNode(Testcase testcase, Project project) {
        this(testcase, project, null);
    }

    protected TestMethodNode(Testcase testcase, Project project, Lookup lookup) {
        super((Children)(testcase.getTrouble() != null ? new TestMethodNodeChildren(testcase) : Children.LEAF), lookup);
        this.testcase = testcase;
        this.project = project;
        this.setDisplayName();
        if (TestsuiteNode.DISPLAY_TOOLTIPS) {
            this.setShortDescription(TestsuiteNode.toTooltipText(testcase.getOutput()));
        }
    }

    private void setDisplayName() {
        int status;
        int n = this.testcase.getTrouble() == null ? 0 : (status = this.testcase.getTrouble().isError() ? 1 : 2);
        if (status == 0 && this.testcase.getTimeMillis() < 0L) {
            this.setDisplayName(this.testcase.getName());
            return;
        }
        String[] noTimeKeys = new String[]{null, "MSG_TestMethodError", "MSG_TestMethodFailed"};
        String[] timeKeys = new String[]{"MSG_TestMethodPassed_time", "MSG_TestMethodError_time", "MSG_TestMethodFailed_time"};
        this.setDisplayName(this.testcase.getTimeMillis() < 0L ? NbBundle.getMessage(TestMethodNode.class, (String)noTimeKeys[status], (Object)this.testcase.getName()) : NbBundle.getMessage(TestMethodNode.class, (String)timeKeys[status], (Object)this.testcase.getName(), (Object)new Float((float)this.testcase.getTimeMillis() / 1000.0f)));
    }

    Testcase getTestCase() {
        return this.testcase;
    }

    public String getHtmlDisplayName() {
        Status status = this.testcase.getStatus();
        StringBuffer buf = new StringBuffer(60);
        buf.append(this.testcase.getName());
        buf.append("&nbsp;&nbsp;");
        buf.append("<font color='#");
        buf.append(status.getHtmlDisplayColor() + "'>");
        String cause = null;
        if (INLINE_RESULTS && this.testcase.getTrouble() != null && this.testcase.getTrouble().getStackTrace() != null && this.testcase.getTrouble().getStackTrace().length > 0) {
            try {
                cause = XMLUtil.toElementContent((String)this.testcase.getTrouble().getStackTrace()[0]).replace("\n", "&nbsp;");
            }
            catch (CharConversionException ex) {
                cause = null;
            }
        }
        if (cause != null) {
            cause = TestsuiteNode.cutLine(cause, TestsuiteNode.MAX_MSG_LINE_LENGTH, true);
            buf.append(NbBundle.getMessage(TestMethodNode.class, (String)DisplayNameMapper.getCauseKey(status), (Object)cause));
        } else {
            buf.append(this.testcase.getTimeMillis() < 0L ? NbBundle.getMessage(TestMethodNode.class, (String)DisplayNameMapper.getNoTimeKey(status)) : NbBundle.getMessage(TestMethodNode.class, (String)DisplayNameMapper.getTimeKey(status), (Object)new Float((float)this.testcase.getTimeMillis() / 1000.0f)));
        }
        buf.append("</font>");
        return buf.toString();
    }

    public Action getPreferredAction() {
        return null;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new DiffViewAction(this.testcase)};
    }

    public Image getIcon(int type) {
        if (Status.PENDING == this.testcase.getStatus()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
        }
        if (Status.SKIPPED == this.testcase.getStatus()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
        }
        if (this.failed()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning_16.png");
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_16.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean failed() {
        return this.testcase.getStatus().equals((Object)Status.FAILED) || this.testcase.getStatus().equals((Object)Status.ERROR);
    }

    private static final class DisplayNameMapper {
        private static final Map<Status, String> NO_TIME_KEYS = DisplayNameMapper.initNoTimeKeys();
        private static final Map<Status, String> TIME_KEYS = DisplayNameMapper.initTimeKeys();
        private static final Map<Status, String> CAUSE_KEYS = DisplayNameMapper.initCauseKeys();

        private DisplayNameMapper() {
        }

        private static Map<Status, String> initNoTimeKeys() {
            HashMap<Status, String> result = new HashMap<Status, String>(4);
            result.put(Status.PASSED, "MSG_TestMethodPassed_HTML");
            result.put(Status.ERROR, "MSG_TestMethodError_HTML");
            result.put(Status.FAILED, "MSG_TestMethodFailed_HTML");
            result.put(Status.PENDING, "MSG_TestMethodPending_HTML");
            result.put(Status.SKIPPED, "MSG_TestMethodSkipped_HTML");
            return result;
        }

        private static Map<Status, String> initTimeKeys() {
            HashMap<Status, String> result = new HashMap<Status, String>(4);
            result.put(Status.PASSED, "MSG_TestMethodPassed_HTML_time");
            result.put(Status.ERROR, "MSG_TestMethodError_HTML_time");
            result.put(Status.FAILED, "MSG_TestMethodFailed_HTML_time");
            result.put(Status.PENDING, "MSG_TestMethodPending_HTML_time");
            result.put(Status.SKIPPED, "MSG_TestMethodSkipped_HTML_time");
            return result;
        }

        private static Map<Status, String> initCauseKeys() {
            HashMap<Status, String> result = new HashMap<Status, String>(4);
            result.put(Status.PASSED, "MSG_TestMethodPassed_HTML_cause");
            result.put(Status.ERROR, "MSG_TestMethodError_HTML_cause");
            result.put(Status.FAILED, "MSG_TestMethodFailed_HTML_cause");
            result.put(Status.PENDING, "MSG_TestMethodPending_HTML_cause");
            result.put(Status.SKIPPED, "MSG_TestMethodSkipped_HTML_cause");
            return result;
        }

        static String getCauseKey(Status status) {
            return CAUSE_KEYS.get((Object)status);
        }

        static String getNoTimeKey(Status status) {
            return NO_TIME_KEYS.get((Object)status);
        }

        static String getTimeKey(Status status) {
            return TIME_KEYS.get((Object)status);
        }
    }
}

