/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.ClassMarker;
import org.netbeans.lib.profiler.marker.CompositeMarker;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.marker.PackageMarker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.categories.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.categories.definitions.CustomCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.PackageCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SingleTypeCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SubtypeCategoryDefinition;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.openide.filesystems.FileObject;

public class MarkerProcessor
extends CategoryDefinitionProcessor
implements Marker {
    private static final Logger LOGGER = Logger.getLogger(MarkerProcessor.class.getName());
    private MethodMarker mMarker = new MethodMarker();
    private ClassMarker cMarker = new ClassMarker();
    private PackageMarker pMarker = new PackageMarker();
    private CompositeMarker cmMarker = new CompositeMarker();
    private Project project;
    private ClasspathInfo cpInfo;
    private JavaSource js;

    public MarkerProcessor(Project project) {
        this.project = project;
        this.cpInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)true);
        this.js = this.cpInfo != null ? JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]) : null;
    }

    @Override
    public void process(SubtypeCategoryDefinition def) {
        if (def.getExcludes() == null && def.getIncludes() == null) {
            this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getAssignedMark());
        } else {
            if (def.getExcludes() != null) {
                this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getExcludes(), false, def.getAssignedMark());
            }
            if (def.getIncludes() != null) {
                this.addInterfaceMarker(this.mMarker, def.getTypeName(), def.getIncludes(), true, def.getAssignedMark());
            }
        }
    }

    @Override
    public void process(SingleTypeCategoryDefinition def) {
        if (def.getExcludes() == null && def.getIncludes() == null) {
            this.cMarker.addClassMark(def.getTypeName(), def.getAssignedMark());
        } else {
            if (def.getExcludes() != null) {
                this.addTypeMarker(this.mMarker, def.getTypeName(), def.getExcludes(), false, def.getAssignedMark());
            }
            if (def.getIncludes() != null) {
                this.addTypeMarker(this.mMarker, def.getTypeName(), def.getIncludes(), true, def.getAssignedMark());
            }
        }
    }

    @Override
    public void process(CustomCategoryDefinition def) {
        this.cmMarker.addMarker(def.getCustomMarker());
    }

    @Override
    public void process(PackageCategoryDefinition def) {
        this.pMarker.addPackageMark(def.getPackageName(), def.getAssignedMark(), def.isRecursive());
    }

    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> mappings = new ArrayList<MarkMapping>();
        mappings.addAll(Arrays.asList(this.mMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.cMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.pMarker.getMappings()));
        mappings.addAll(Arrays.asList(this.cmMarker.getMappings()));
        return mappings.toArray(new MarkMapping[mappings.size()]);
    }

    public Mark[] getMarks() {
        HashSet<Mark> marks = new HashSet<Mark>();
        marks.addAll(Arrays.asList(this.mMarker.getMarks()));
        marks.addAll(Arrays.asList(this.cMarker.getMarks()));
        marks.addAll(Arrays.asList(this.pMarker.getMarks()));
        marks.addAll(Arrays.asList(this.cmMarker.getMarks()));
        return marks.toArray(new Mark[marks.size()]);
    }

    protected void addInterfaceMarker(MethodMarker marker, String interfaceName, Mark mark) {
        this.addInterfaceMarker(marker, interfaceName, null, false, mark);
    }

    protected void addInterfaceMarker(final MethodMarker marker, final String interfaceName, final String[] methodNameRestriction, final boolean inclusive, final Mark mark) {
        try {
            if (this.js != null) {
                this.js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        MarkerProcessor.this.doAddInterfaceMarker(marker, interfaceName, methodNameRestriction, inclusive, mark, controller);
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker marker, final String[] interfaceNames, final Mark mark) {
        try {
            if (this.js != null) {
                this.js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        for (String interfaceName : interfaceNames) {
                            MarkerProcessor.this.doAddInterfaceMarker(marker, interfaceName, null, false, mark, controller);
                        }
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker marker, final String[] interfaceNames, final String[] methodNameRestriction, final boolean inclusive, final Mark mark) {
        try {
            if (this.js != null) {
                this.js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        for (String interfaceName : interfaceNames) {
                            MarkerProcessor.this.doAddInterfaceMarker(marker, interfaceName, methodNameRestriction, inclusive, mark, controller);
                        }
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void addTypeMarker(MethodMarker marker, String type, Mark mark) {
        this.addTypeMarker(marker, type, new String[0], false, mark);
    }

    protected void addTypeMarker(final MethodMarker marker, final String type, String[] methodNameRestriction, final boolean inclusive, final Mark mark) {
        final ArrayList restrictors = methodNameRestriction != null ? Arrays.asList(methodNameRestriction) : new ArrayList();
        try {
            if (this.js != null) {
                this.js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws Exception {
                        TypeElement typeElement = controller.getElements().getTypeElement(type);
                        MarkerProcessor.this.addTypeMethods(marker, typeElement, restrictors, inclusive, mark, controller);
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void addImplementorMethods(MethodMarker marker, TypeElement superElement, Collection<String> restrictors, boolean inclusive, Mark mark, CompilationController controller) {
        try {
            HashSet tmpImplementors;
            controller.toPhase(JavaSource.Phase.RESOLVED);
            EnumSet<ClassIndex.SearchKind> kind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
            EnumSet<ClassIndex.SearchScope> scope = EnumSet.allOf(ClassIndex.SearchScope.class);
            HashSet<String> adjustedRestrictors = new HashSet<String>();
            for (ExecutableElement method : ElementFilter.methodsIn(controller.getElements().getAllMembers(superElement))) {
                if (superElement.getKind() == ElementKind.INTERFACE && controller.getElementUtilities().enclosingTypeElement((Element)method).equals(controller.getElements().getTypeElement(Object.class.getCanonicalName())) || method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                String methodName = method.getSimpleName().toString();
                if (inclusive) {
                    if (!restrictors.contains(methodName)) continue;
                    adjustedRestrictors.add(methodName);
                    continue;
                }
                if (restrictors.contains(methodName)) continue;
                adjustedRestrictors.add(methodName);
            }
            HashSet allImplementors = new HashSet();
            HashSet implementors = controller.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)superElement), kind, scope);
            do {
                tmpImplementors = new HashSet();
                allImplementors.addAll(implementors);
                for (ElementHandle element : implementors) {
                    tmpImplementors.addAll(controller.getClasspathInfo().getClassIndex().getElements(element, kind, scope));
                }
            } while (!(implementors = tmpImplementors).isEmpty());
            for (ElementHandle handle : allImplementors) {
                TypeElement implementor = (TypeElement)handle.resolve((CompilationInfo)controller);
                this.addTypeMethods(marker, implementor, adjustedRestrictors, true, mark, controller);
            }
        }
        catch (IOException e) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addImplementorMethods", e);
        }
    }

    private void addTypeMethods(MethodMarker marker, TypeElement type, Collection<String> restrictors, boolean inclusive, Mark mark, CompilationController controller) {
        if (marker == null || type == null || restrictors == null || mark == null || controller == null) {
            return;
        }
        try {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (ExecutableElement method : ElementFilter.methodsIn(controller.getElements().getAllMembers(type))) {
                if (method.getKind() != ElementKind.METHOD || method.getModifiers().contains((Object)Modifier.ABSTRACT) || (!inclusive || !restrictors.contains(method.getSimpleName().toString())) && (inclusive || restrictors.contains(method.getSimpleName().toString()))) continue;
                try {
                    marker.addMethodMark(ElementUtilities.getBinaryName((TypeElement)type), method.getSimpleName().toString(), SourceUtils.getVMMethodSignature((ExecutableElement)method, (CompilationInfo)controller), mark);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addTypeMethods", e);
        }
    }

    private void doAddInterfaceMarker(MethodMarker marker, String interfaceName, String[] methodNameRestriction, boolean inclusive, Mark mark, CompilationController controller) throws IllegalArgumentException {
        ArrayList<String> restrictors = methodNameRestriction != null ? Arrays.asList(methodNameRestriction) : new ArrayList<String>();
        TypeElement superElement = controller.getElements().getTypeElement(interfaceName);
        if (superElement == null) {
            LOGGER.fine("Couldn't resolve type: " + interfaceName);
            return;
        }
        switch (superElement.getKind()) {
            case INTERFACE: {
                this.addImplementorMethods(marker, superElement, restrictors, inclusive, mark, controller);
                break;
            }
            case CLASS: {
                this.addTypeMethods(marker, superElement, restrictors, inclusive, mark, controller);
                if (superElement.getModifiers().contains((Object)Modifier.FINAL)) break;
                this.addImplementorMethods(marker, superElement, restrictors, inclusive, mark, controller);
            }
        }
    }
}

