/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapPatterns;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveFieldNode;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.util.NbBundle;

public class HeapWalkerNodeFactory {
    private static final String NONE_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoneString");
    private static final String NO_FIELDS_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoFieldsString");
    private static final String NO_REFERENCES_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoReferencesString");
    private static final String NO_ITEMS_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoItemsString");
    private static final String SEARCHING_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_SearchingString");
    private static final String OUT_OF_MEMORY_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_OutOfMemoryString");
    private static final String ARRAY_CONTAINER_NAME_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_ArrayContainerNameString");
    private static final String ARRAY_CONTAINER_VALUE_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_ArrayContainerValueString");
    public static final int ITEMS_COLLAPSE_UNIT_SIZE = 500;
    public static final int ITEMS_COLLAPSE_THRESHOLD = 2000;
    public static final int ITEMS_COLLAPSE_UNIT_THRESHOLD = 5000;

    public static HeapWalkerNode createArrayItemContainerNode(final ArrayNode array, final int startIndex, final int endIndex) {
        return new AbstractHeapWalkerNode(array){

            @Override
            protected String computeName() {
                return MessageFormat.format(ARRAY_CONTAINER_NAME_STRING, startIndex, endIndex);
            }

            @Override
            protected String computeType() {
                return BrowserUtils.getArrayItemType(array.getType());
            }

            @Override
            protected String computeValue() {
                return MessageFormat.format(ARRAY_CONTAINER_VALUE_STRING, endIndex - startIndex + 1);
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            protected HeapWalkerNode[] computeChildren() {
                return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
            }

            protected ChildrenComputer getChildrenComputer() {
                return new ChildrenComputer(){

                    @Override
                    public HeapWalkerNode[] computeChildren() {
                        int itemsCount = endIndex - startIndex + 1;
                        HeapWalkerNode[] children = new HeapWalkerNode[itemsCount];
                        boolean primitiveArray = array instanceof PrimitiveArrayNode;
                        List values = primitiveArray ? ((PrimitiveArrayInstance)array.getInstance()).getValues() : ((ObjectArrayInstance)array.getInstance()).getValues();
                        for (int i = 0; i < itemsCount; ++i) {
                            children[i] = primitiveArray ? HeapWalkerNodeFactory.createPrimitiveArrayItemNode((PrimitiveArrayNode)array, startIndex + i, (String)values.get(startIndex + i)) : HeapWalkerNodeFactory.createObjectArrayItemNode((ObjectArrayNode)array, startIndex + i, (Instance)values.get(startIndex + i));
                        }
                        return children;
                    }
                };
            }
        };
    }

    public static ClassNode createClassNode(JavaClass javaClass, String name, HeapWalkerNode parent) {
        return new ClassNode(javaClass, name, parent, parent == null ? 1 : parent.getMode());
    }

    public static HeapWalkerFieldNode createFieldNode(FieldValue fieldValue, HeapWalkerNode parent) {
        if (fieldValue instanceof ObjectFieldValue) {
            Instance instance = ((ObjectFieldValue)fieldValue).getInstance();
            if (instance instanceof PrimitiveArrayInstance) {
                return new PrimitiveArrayFieldNode((ObjectFieldValue)fieldValue, parent);
            }
            if (instance instanceof ObjectArrayInstance) {
                return new ObjectArrayFieldNode((ObjectFieldValue)fieldValue, parent);
            }
            return new ObjectFieldNode((ObjectFieldValue)fieldValue, parent);
        }
        return new PrimitiveFieldNode(fieldValue, parent);
    }

    public static HeapWalkerInstanceNode createInstanceNode(Instance instance, String name, HeapWalkerNode parent) {
        int mode;
        int n = mode = parent == null ? 1 : parent.getMode();
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode((PrimitiveArrayInstance)instance, name, parent, mode);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode((ObjectArrayInstance)instance, name, parent, mode);
        }
        return new ObjectNode(instance, name, parent, mode);
    }

    public static HeapWalkerNode createNoFieldsNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return NO_FIELDS_STRING;
            }

            @Override
            protected String computeType() {
                return NONE_STRING;
            }

            @Override
            protected String computeValue() {
                return NONE_STRING;
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoFieldsNode(HeapWalkerNode node) {
        return NO_FIELDS_STRING.equals(node.getName());
    }

    public static HeapWalkerNode createNoItemsNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return NO_ITEMS_STRING;
            }

            @Override
            protected String computeType() {
                return NONE_STRING;
            }

            @Override
            protected String computeValue() {
                return NONE_STRING;
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoItemsNode(HeapWalkerNode node) {
        return NO_ITEMS_STRING.equals(node.getName());
    }

    public static HeapWalkerNode createNoReferencesNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return NO_REFERENCES_STRING;
            }

            @Override
            protected String computeType() {
                return NONE_STRING;
            }

            @Override
            protected String computeValue() {
                return NONE_STRING;
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoReferencesNode(HeapWalkerNode node) {
        return NO_REFERENCES_STRING.equals(node.getName());
    }

    public static HeapWalkerNode createOOMNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return OUT_OF_MEMORY_STRING;
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return Utils.ERROR_ICON;
            }
        };
    }

    public static boolean isOOMNode(HeapWalkerNode node) {
        return OUT_OF_MEMORY_STRING.equals(node.getName());
    }

    public static HeapWalkerNode createObjectArrayItemNode(ObjectArrayNode array, int itemIndex, Instance instance) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.ArrayItem(itemIndex, (PrimitiveArrayInstance)instance, (HeapWalkerNode)array);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.ArrayItem(itemIndex, (ObjectArrayInstance)instance, (HeapWalkerNode)array);
        }
        return new ObjectNode.ArrayItem(itemIndex, instance, (HeapWalkerNode)array);
    }

    public static HeapWalkerNode createPrimitiveArrayItemNode(PrimitiveArrayNode array, int itemIndex, String value) {
        return new PrimitiveFieldNode.ArrayItem(itemIndex, BrowserUtils.getArrayItemType(array.getType()), value, array);
    }

    public static HeapWalkerNode createProgressNode(HeapWalkerNode parent) {
        return new AbstractHeapWalkerNode(parent){

            @Override
            protected String computeName() {
                return SEARCHING_STRING;
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return BrowserUtils.ICON_PROGRESS;
            }
        };
    }

    public static boolean isProgressNode(HeapWalkerNode node) {
        return SEARCHING_STRING.equals(node.getName());
    }

    public static HeapWalkerNode[] createReferences(InstanceNode parent) {
        HeapWalkerNode[] referenceNodes = null;
        List references = parent.getReferences();
        referenceNodes = HeapPatterns.processReferencePatterns(parent, references);
        if (referenceNodes != null) {
            return referenceNodes;
        }
        if (references.size() == 0) {
            referenceNodes = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(parent)};
        } else {
            referenceNodes = new HeapWalkerNode[references.size()];
            for (int i = 0; i < referenceNodes.length; ++i) {
                referenceNodes[i] = HeapWalkerNodeFactory.createReferenceNode((Value)references.get(i), parent);
            }
        }
        return referenceNodes;
    }

    public static HeapWalkerNode createReferenceNode(Value value, HeapWalkerNode parent) {
        if (value instanceof ObjectFieldValue) {
            return new ObjectFieldNode((ObjectFieldValue)value, parent);
        }
        if (value instanceof ArrayItemValue) {
            ArrayItemValue arrayValue = (ArrayItemValue)value;
            return new ObjectArrayNode.ArrayItem(arrayValue.getIndex(), (ObjectArrayInstance)arrayValue.getDefiningInstance(), parent);
        }
        return null;
    }

    public static ClassNode createRootClassNode(JavaClass javaClass, String name, final Runnable refresher, int mode, final Heap heap) {
        return new ClassNode.RootNode(javaClass, name, null, mode){

            @Override
            public void refreshView() {
                refresher.run();
            }

            @Override
            public GCRoot getGCRoot(Instance inst) {
                return heap.getGCRoot(inst);
            }

            @Override
            public JavaClass getJavaClassByID(long javaclassId) {
                return heap.getJavaClassByID(javaclassId);
            }
        };
    }

    public static HeapWalkerInstanceNode createRootInstanceNode(Instance instance, String name, final Runnable refresher, int mode, final Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.RootNode((PrimitiveArrayInstance)instance, name, null, mode){

                @Override
                public void refreshView() {
                    refresher.run();
                }

                @Override
                public GCRoot getGCRoot(Instance inst) {
                    return heap.getGCRoot(inst);
                }

                @Override
                public JavaClass getJavaClassByID(long javaclassId) {
                    return heap.getJavaClassByID(javaclassId);
                }
            };
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.RootNode((ObjectArrayInstance)instance, name, null, mode){

                @Override
                public void refreshView() {
                    refresher.run();
                }

                @Override
                public GCRoot getGCRoot(Instance inst) {
                    return heap.getGCRoot(inst);
                }

                @Override
                public JavaClass getJavaClassByID(long javaclassId) {
                    return heap.getJavaClassByID(javaclassId);
                }
            };
        }
        return new ObjectNode.RootNode(instance, name, null, mode){

            @Override
            public void refreshView() {
                refresher.run();
            }

            @Override
            public GCRoot getGCRoot(Instance inst) {
                return heap.getGCRoot(inst);
            }

            @Override
            public JavaClass getJavaClassByID(long javaclassId) {
                return heap.getJavaClassByID(javaclassId);
            }
        };
    }

    public static boolean isMessageNode(HeapWalkerNode node) {
        return HeapWalkerNodeFactory.isNoFieldsNode(node) || HeapWalkerNodeFactory.isNoItemsNode(node) || HeapWalkerNodeFactory.isNoReferencesNode(node) || HeapWalkerNodeFactory.isNoReferencesNode(node) || HeapWalkerNodeFactory.isOOMNode(node) || HeapWalkerNodeFactory.isProgressNode(node);
    }
}

