/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;

public class GlobalProfilingPointsProcessor
implements DataManagerListener {
    private static GlobalProfilingPointsProcessor defaultInstance;
    private List<TimedGlobalProfilingPoint> scheduledTimedPPs = new LinkedList<TimedGlobalProfilingPoint>();
    private List<TriggeredGlobalProfilingPoint> scheduledTriggeredPPs = new LinkedList<TriggeredGlobalProfilingPoint>();
    private ProfilingSettings profilingSettings;
    private Project profiledProject;
    private GlobalProfilingPoint[] gpp;
    private boolean isRunning = false;
    private long currentHeapSize;
    private long currentHeapUsage;
    private long currentLoadedClasses;
    private long currentSurvGen;
    private long currentTime = System.currentTimeMillis();

    public void dataChanged() {
        this.processTelemetryEvent();
    }

    public void dataReset() {
        this.processTelemetryEvent();
    }

    static synchronized GlobalProfilingPointsProcessor getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new GlobalProfilingPointsProcessor();
        }
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyProfilingStateChanged() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            boolean profilingInProgress = ProfilingPointsManager.getDefault().isProfilingInProgress();
            boolean sessionInProgress = ProfilingPointsManager.getDefault().isProfilingSessionInProgress();
            if (sessionInProgress && !profilingInProgress) {
                if (this.isRunning) {
                    this.stop();
                }
                this.init();
            } else if (profilingInProgress) {
                if (!this.isRunning) {
                    this.start();
                }
            } else {
                this.stop();
            }
        }
    }

    private boolean anyProfilingPointsScheduled() {
        return this.scheduledTimedPPs.size() > 0 || this.scheduledTriggeredPPs.size() > 0;
    }

    private void checkForStop() {
        if (!this.anyProfilingPointsScheduled()) {
            this.stop();
        }
    }

    private void init() {
        this.profiledProject = NetBeansProfiler.getDefaultNB().getProfiledProject();
        this.profilingSettings = NetBeansProfiler.getDefaultNB().getLastProfilingSettings();
        if (this.profiledProject != null && this.profilingSettings.useProfilingPoints()) {
            for (GlobalProfilingPoint pp : this.gpp = ProfilingPointsManager.getDefault().createGlobalProfilingConfiguration(this.profiledProject, this.profilingSettings)) {
                this.scheduleProfilingPoint(pp);
            }
        }
    }

    private void initListeners() {
        NetBeansProfiler.getDefaultNB().getVMTelemetryManager().addDataListener((DataManagerListener)this);
    }

    private void processTelemetryEvent() {
        MonitoredData data = NetBeansProfiler.getDefaultNB().getVMTelemetryManager().getLastData();
        if (data != null) {
            this.processTimeEvent();
            long currentMaxHeap = NetBeansProfiler.getDefaultNB().getVMTelemetryManager().maxHeapSize;
            this.currentHeapSize = data.getTotalMemory();
            long currentUsedHeap = this.currentHeapSize - data.getFreeMemory();
            this.currentHeapUsage = Math.round((double)currentUsedHeap / (double)currentMaxHeap * 100.0);
            this.currentSurvGen = data.getNSurvivingGenerations();
            this.currentLoadedClasses = data.getLoadedClassesCount();
            this.processTriggeredProfilingPoints();
        }
    }

    private void processTimeEvent() {
        this.currentTime = System.currentTimeMillis();
        this.processTimedProfilingPoints();
    }

    private void processTimedProfilingPoint(TimedGlobalProfilingPoint tgpp, List<TimedGlobalProfilingPoint> rescheduledTimedPPs) {
        tgpp.hit(this.currentTime);
        this.scheduleTimedProfilingPoint(tgpp, rescheduledTimedPPs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedProfilingPoints() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            this.checkForStop();
            if (this.isRunning) {
                LinkedList<TimedGlobalProfilingPoint> rescheduledTimedPPs = new LinkedList<TimedGlobalProfilingPoint>();
                for (TimedGlobalProfilingPoint tgpp : this.scheduledTimedPPs) {
                    if (this.timeConditionMet(tgpp.getCondition())) {
                        this.processTimedProfilingPoint(tgpp, rescheduledTimedPPs);
                        continue;
                    }
                    rescheduledTimedPPs.add(tgpp);
                }
                this.scheduledTimedPPs.clear();
                this.scheduledTimedPPs.addAll(rescheduledTimedPPs);
            }
        }
    }

    private void processTriggeredProfilingPoint(TriggeredGlobalProfilingPoint tgpp, List<TriggeredGlobalProfilingPoint> rescheduledTriggeredPPs) {
        TriggeredGlobalProfilingPoint.TriggerCondition condition = tgpp.getCondition();
        if (!condition.isTriggered()) {
            condition.setTriggered(true);
            long hitValue = -1L;
            if (condition.getMetric() == 2) {
                hitValue = this.currentHeapSize;
            } else if (condition.getMetric() == 1) {
                hitValue = this.currentHeapUsage;
            } else if (condition.getMetric() == 3) {
                hitValue = this.currentSurvGen;
            } else if (condition.getMetric() == 4) {
                hitValue = this.currentLoadedClasses;
            }
            tgpp.hit(hitValue);
        } else {
            condition.setTriggered(false);
        }
        if (!condition.isOnetime()) {
            this.scheduleTriggeredProfilingPoint(tgpp, rescheduledTriggeredPPs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTriggeredProfilingPoints() {
        GlobalProfilingPointsProcessor globalProfilingPointsProcessor = this;
        synchronized (globalProfilingPointsProcessor) {
            this.checkForStop();
            if (this.isRunning) {
                LinkedList<TriggeredGlobalProfilingPoint> rescheduledTriggeredPPs = new LinkedList<TriggeredGlobalProfilingPoint>();
                for (TriggeredGlobalProfilingPoint tgpp : this.scheduledTriggeredPPs) {
                    if (this.triggerConditionMet(tgpp.getCondition())) {
                        this.processTriggeredProfilingPoint(tgpp, rescheduledTriggeredPPs);
                        continue;
                    }
                    rescheduledTriggeredPPs.add(tgpp);
                }
                this.scheduledTriggeredPPs.clear();
                this.scheduledTriggeredPPs.addAll(rescheduledTriggeredPPs);
            }
        }
    }

    private void reset() {
        this.gpp = null;
        this.profiledProject = null;
        this.profilingSettings = null;
        this.scheduledTimedPPs.clear();
        this.scheduledTriggeredPPs.clear();
    }

    private void resetListeners() {
        NetBeansProfiler.getDefaultNB().getVMTelemetryManager().removeDataListener((DataManagerListener)this);
    }

    private void scheduleProfilingPoint(GlobalProfilingPoint gpp) {
        if (gpp instanceof TimedGlobalProfilingPoint) {
            this.scheduleTimedProfilingPoint((TimedGlobalProfilingPoint)gpp, this.scheduledTimedPPs);
        } else if (gpp instanceof TriggeredGlobalProfilingPoint) {
            this.scheduleTriggeredProfilingPoint((TriggeredGlobalProfilingPoint)gpp, this.scheduledTriggeredPPs);
        }
    }

    private void scheduleTimedProfilingPoint(TimedGlobalProfilingPoint gpp, List<TimedGlobalProfilingPoint> timedPPs) {
        TimedGlobalProfilingPoint.TimeCondition tc = gpp.getCondition();
        long currentTime = System.currentTimeMillis();
        long scheduledTime = tc.getScheduledTime();
        boolean repeats = tc.getRepeats();
        long periodTime = tc.getPeriodTime();
        switch (tc.getPeriodUnits()) {
            case 1: {
                periodTime *= 60000L;
                break;
            }
            case 2: {
                periodTime *= 3600000L;
                break;
            }
        }
        if (scheduledTime < currentTime) {
            if (!repeats) {
                return;
            }
            long factor = (long)Math.ceil((double)(currentTime - scheduledTime) / (double)periodTime);
            scheduledTime += factor * periodTime;
        }
        if (scheduledTime >= currentTime) {
            tc.setScheduledTime(scheduledTime);
            timedPPs.add(gpp);
        }
    }

    private void scheduleTriggeredProfilingPoint(TriggeredGlobalProfilingPoint gpp, List<TriggeredGlobalProfilingPoint> triggeredPPs) {
        triggeredPPs.add(gpp);
    }

    private void start() {
        if (this.profiledProject == null || this.gpp == null || this.gpp.length == 0 || !this.anyProfilingPointsScheduled()) {
            this.reset();
            return;
        }
        this.isRunning = true;
        this.initListeners();
    }

    private void stop() {
        this.isRunning = false;
        this.resetListeners();
        this.reset();
    }

    private boolean timeConditionMet(TimedGlobalProfilingPoint.TimeCondition condition) {
        return condition.getScheduledTime() <= this.currentTime;
    }

    private boolean triggerConditionMet(TriggeredGlobalProfilingPoint.TriggerCondition condition) {
        if (condition.getMetric() == 2) {
            return condition.isTriggered() ? condition.getValue() >= this.currentHeapSize : condition.getValue() < this.currentHeapSize;
        }
        if (condition.getMetric() == 1) {
            return condition.isTriggered() ? condition.getValue() >= this.currentHeapUsage : condition.getValue() < this.currentHeapUsage;
        }
        if (condition.getMetric() == 3) {
            return condition.isTriggered() ? condition.getValue() >= this.currentSurvGen : condition.getValue() < this.currentSurvGen;
        }
        if (condition.getMetric() == 4) {
            return condition.isTriggered() ? condition.getValue() >= this.currentLoadedClasses : condition.getValue() < this.currentLoadedClasses;
        }
        return false;
    }
}

