/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.table.HTMLLabelTableCellRenderer;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;

public abstract class ProfilingPoint {
    static final String PROPERTY_NAME = "p_name";
    static final String PROPERTY_ENABLED = "p_enabled";
    static final String PROPERTY_PROJECT = "p_project";
    static final String PROPERTY_RESULTS = "p_results";
    static final String PROPERTY_CUSTOM = "p_custom";
    private final ProfilingPointFactory factory;
    private Project project;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResultsRenderer resultsRenderer;
    private String name;
    private boolean enabled = true;
    private final AtomicBoolean uninitialized;

    ProfilingPoint(String name, Project project, ProfilingPointFactory factory) {
        this(name, project, factory, false);
    }

    ProfilingPoint(String name, Project project, ProfilingPointFactory factory, boolean existing) {
        this.name = name;
        this.project = project;
        this.factory = factory;
        this.uninitialized = new AtomicBoolean(!existing);
    }

    public final ProfilingPointFactory getFactory() {
        return this.factory;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.getChangeSupport().firePropertyChange(PROPERTY_ENABLED, !this.enabled, this.enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        if (this.name.equals(name) || name == null) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        this.getChangeSupport().firePropertyChange(PROPERTY_NAME, oldName, this.name);
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isValid() {
        return true;
    }

    public abstract boolean hasResults();

    public abstract void hideResults();

    public abstract void showResults(URL var1);

    public ResultsRenderer getResultsRenderer() {
        if (this.resultsRenderer == null) {
            this.resultsRenderer = new ResultsRenderer();
        }
        return this.resultsRenderer;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void customize() {
        final ValidityAwarePanel customizer = this.getCustomizer();
        if (!ProfilingPointsManager.getDefault().customize(customizer, new Runnable(){

            @Override
            public void run() {
                ProfilingPoint.this.setValues(customizer);
            }
        })) {
            if (this.uninitialized.compareAndSet(true, false)) {
                ProfilingPointsManager.getDefault().removeProfilingPoint(this);
            }
        } else {
            this.uninitialized.compareAndSet(true, false);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean supportsProfilingSettings(ProfilingSettings profilingSettings) {
        return (profilingSettings.getProfilingType() == 8 || profilingSettings.getProfilingType() == 16) && this.getFactory().supportsCPU() || (profilingSettings.getProfilingType() == 2 || profilingSettings.getProfilingType() == 4) && this.getFactory().supportsMemory() || profilingSettings.getProfilingType() == 1 && this.getFactory().supportsMonitor();
    }

    public String toString() {
        return this.getName();
    }

    protected abstract String getResultsText();

    protected abstract void updateCustomizer(ValidityAwarePanel var1);

    protected PropertyChangeSupport getChangeSupport() {
        return this.propertyChangeSupport;
    }

    abstract void setValues(ValidityAwarePanel var1);

    abstract void reset();

    ValidityAwarePanel getCustomizer() {
        ValidityAwarePanel customizer = this.getFactory().getCustomizer();
        if (customizer != null) {
            this.updateCustomizer(customizer);
        }
        return customizer;
    }

    public class ResultsRenderer
    extends HTMLLabelTableCellRenderer {
        private JTable lastTable;

        public ResultsRenderer() {
            this(11, false);
        }

        public ResultsRenderer(int horizontalAlignment, boolean persistent) {
            super(horizontalAlignment, persistent);
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ResultsRenderer(this.getHorizontalAlignment(), true).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public void dispatchMouseEvent(MouseEvent e) {
            this.label.dispatchEvent((AWTEvent)SwingUtilities.convertMouseEvent((Component)((Object)this), e, (Component)this.label));
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            this.lastTable = table;
            this.label.setText(ProfilingPoint.this.getResultsText());
        }

        protected void handleCursor(Cursor cursor) {
            if (this.lastTable != null) {
                this.lastTable.setCursor(cursor);
            }
        }

        protected void handleLink(URL url) {
            ProfilingPoint.this.showResults(url);
        }
    }
}

