/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ProfilerOptionsPanel
extends JPanel
implements ActionListener {
    private static final String USE_PROJECT_JVM_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_UseProjectJvmText");
    private static final String KEY_OPEN_ALWAYS = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenAlways");
    private static final String KEY_OPEN_MONITORING = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenMonitoring");
    private static final String KEY_OPEN_NEVER = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenNever");
    private static final String ENGINE_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_EngineSettingsBorderText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_JavaPlatformLabelText");
    private static final String MANAGE_PLATFORMS_BUTTON_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ManagePlatformsButtonName");
    private static final String COMM_PORT_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CommPortLabelText");
    private static final String WINDOWS_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_WindowsSettingsBorderText");
    private static final String TELEMETRY_OVERVIEW_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TelemetryOverviewLabelText");
    private static final String THREADS_VIEW_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewLabelText");
    private static final String THREADS_VIEW_HINT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewHintText");
    private static final String LIVE_RESULTS_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_LiveResultsLabelText");
    private static final String CPU_CHCKBOX_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CpuChckBoxText");
    private static final String MEMORY_CHCKBOX_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_MemoryChckBoxText");
    private static final String SNAPSHOTS_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_SnapshotsSettingsBorderText");
    private static final String OPEN_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OpenSnapshotRadioText");
    private static final String SAVE_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_SaveSnapshotRadioText");
    private static final String OPEN_SAVE_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OpenSaveSnapshotRadioText");
    private static final String RESET_HINT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ResetHintText");
    private static final String RESET_BUTTON_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ResetButtonName");
    private static final String PORT_NO_SPINNER_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_PortNoSpinnerAccessDescr");
    private static final String CPU_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CpuLiveResultsCheckboxAccessDescr");
    private static final String MEMORY_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_MemoryLiveResultsCheckboxAccessDescr");
    private static final String TELEMETRY_OVERVIEW_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TelemetryOverviewComboAccessDescr");
    private static final String THREADS_VIEW_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewComboAccessDescr");
    private static final String OOME_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeBorderText");
    private static final String OOME_NOTHING_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeNothingText");
    private static final String OOME_PROJECT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeProjectText");
    private static final String OOME_CUSTOM_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomText");
    private static final String OOME_TEMP_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeTempText");
    private static final String OOME_CUSTOM_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomAccessDescr");
    private static final String OOME_CUSTOM_TEXTFIELD_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomTextfieldAccessDescr");
    private static final String OOME_CUSTOM_BUTTON_ACCESS_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomButtonAccessName");
    private static final String CHOOSE_DUMPDIR_CAPTION = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ChooseDumpDirCaption");
    private static final String ENABLE_ANALYSIS_CHECKBOX = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_EnableAnalysisCheckbox");
    private static final String TAKING_SNAPSHOT_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TakingSnapshotLabelText");
    private static final String TAKING_SNAPSHOT_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TakingSnapshotComboAccessDescr");
    private static final String OOME_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeComboAccessDescr");
    private static final String HEAPWALKER_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_HeapWalkerLabelText");
    private static final String JAVA_PLAFORM_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_JavaPlatformComboAccessDescr");
    private ArrayList supportedJavaPlatforms = new ArrayList();
    private ArrayList supportedJavaPlatformsNames = new ArrayList();
    private JButton managePlatformsButton;
    private JButton oomeDetectionChooseDirButton;
    private JButton resetConfirmationsButton;
    private JCheckBox cpuLiveResultsCheckbox;
    private JCheckBox enableHeapWalkerAnalysisCheckbox;
    private JCheckBox memoryLiveResultsCheckbox;
    private JComboBox javaPlatformCombo;
    private JComboBox oomeCombo;
    private JComboBox openThreadsViewCombo;
    private JComboBox takingSnapshotCombo;
    private JComboBox telemetryOverviewCombo;
    private JExtendedSpinner portNoSpinner;
    private JTextField oomeDetectionDirTextField;

    public ProfilerOptionsPanel() {
        this.initComponents();
    }

    public JavaPlatform getSelectedJavaPlatform() {
        int selectedJavaPlatformIndex = this.javaPlatformCombo.getSelectedIndex();
        if (selectedJavaPlatformIndex == -1 || selectedJavaPlatformIndex == 0) {
            return null;
        }
        return (JavaPlatform)this.supportedJavaPlatforms.get(--selectedJavaPlatformIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetConfirmationsButton) {
            ProfilerIDESettings.getInstance().clearDoNotShowAgainMap();
            this.resetConfirmationsButton.setEnabled(false);
        } else if (e.getSource() == this.managePlatformsButton) {
            JavaPlatform platform = this.getSelectedJavaPlatform();
            PlatformsCustomizer.showCustomizer((JavaPlatform)platform);
            this.updateJavaPlatformComboItems();
        } else if (e.getSource() == this.oomeDetectionChooseDirButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(this.oomeDetectionDirTextField.getText()));
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(CHOOSE_DUMPDIR_CAPTION);
            if (chooser.showOpenDialog(SwingUtilities.getRoot(this)) == 0) {
                this.oomeDetectionDirTextField.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void applySettings(ProfilerIDESettings pis) {
        pis.setPortNo(((Number)this.portNoSpinner.getValue()).intValue());
        JavaPlatform sel = this.getSelectedJavaPlatform();
        pis.setJavaPlatformForProfiling(sel == null ? null : sel.getDisplayName());
        pis.setDisplayLiveResultsCPU(this.cpuLiveResultsCheckbox.isSelected());
        pis.setDisplayLiveResultsMemory(this.memoryLiveResultsCheckbox.isSelected());
        Object takingSnapshotSelected = this.takingSnapshotCombo.getSelectedItem();
        pis.setAutoOpenSnapshot(takingSnapshotSelected == OPEN_SNAPSHOT_RADIO_TEXT || takingSnapshotSelected == OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        pis.setAutoSaveSnapshot(takingSnapshotSelected == SAVE_SNAPSHOT_RADIO_TEXT || takingSnapshotSelected == OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        Object oomeSelected = this.oomeCombo.getSelectedItem();
        if (oomeSelected == OOME_NOTHING_TEXT) {
            pis.setOOMDetectionMode(0);
        } else if (oomeSelected == OOME_PROJECT_TEXT) {
            pis.setOOMDetectionMode(2);
        } else if (oomeSelected == OOME_TEMP_TEXT) {
            pis.setOOMDetectionMode(1);
        } else if (oomeSelected == OOME_CUSTOM_TEXT) {
            pis.setOOMDetectionMode(3);
        }
        pis.setCustomHeapdumpPath(this.oomeDetectionDirTextField.getText());
        pis.setHeapWalkerAnalysisEnabled(this.enableHeapWalkerAnalysisCheckbox.isSelected());
        if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_ALWAYS) {
            pis.setTelemetryOverviewBehavior(1);
        } else if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_MONITORING) {
            pis.setTelemetryOverviewBehavior(2);
        } else {
            pis.setTelemetryOverviewBehavior(3);
        }
        if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_ALWAYS) {
            pis.setThreadsViewBehavior(1);
        } else if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_MONITORING) {
            pis.setThreadsViewBehavior(2);
        } else {
            pis.setThreadsViewBehavior(3);
        }
    }

    public boolean currentSettingsEquals(ProfilerIDESettings settings) {
        if (((Number)this.portNoSpinner.getValue()).intValue() != settings.getPortNo()) {
            return false;
        }
        if (this.cpuLiveResultsCheckbox.isSelected() != settings.getDisplayLiveResultsCPU()) {
            return false;
        }
        if (this.memoryLiveResultsCheckbox.isSelected() != settings.getDisplayLiveResultsMemory()) {
            return false;
        }
        if (settings.getAutoOpenSnapshot() && settings.getAutoSaveSnapshot() && this.takingSnapshotCombo.getSelectedItem() != OPEN_SAVE_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (settings.getAutoOpenSnapshot() && this.takingSnapshotCombo.getSelectedItem() != OPEN_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (settings.getAutoSaveSnapshot() && this.takingSnapshotCombo.getSelectedItem() != SAVE_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 0 && this.oomeCombo.getSelectedItem() != OOME_NOTHING_TEXT) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 2 && this.oomeCombo.getSelectedItem() != OOME_PROJECT_TEXT) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 1 && this.oomeCombo.getSelectedItem() != OOME_TEMP_TEXT) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 3 && this.oomeCombo.getSelectedItem() != OOME_CUSTOM_TEXT) {
            return false;
        }
        if (!this.oomeDetectionDirTextField.getText().equals(settings.getCustomHeapdumpPath())) {
            return false;
        }
        if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_ALWAYS ? settings.getTelemetryOverviewBehavior() != 1 : (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_MONITORING ? settings.getTelemetryOverviewBehavior() != 2 : this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_NEVER && settings.getTelemetryOverviewBehavior() != 3)) {
            return false;
        }
        if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_ALWAYS ? settings.getThreadsViewBehavior() != 1 : (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_MONITORING ? settings.getThreadsViewBehavior() != 2 : this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_NEVER && settings.getThreadsViewBehavior() != 3)) {
            return false;
        }
        JavaPlatform sel = this.getSelectedJavaPlatform();
        if (sel == null ? settings.getJavaPlatformForProfiling() != null : !sel.getDisplayName().equals(settings.getJavaPlatformForProfiling())) {
            return false;
        }
        return settings.getHeapWalkerAnalysisEnabled() == this.enableHeapWalkerAnalysisCheckbox.isSelected();
    }

    public void init(ProfilerIDESettings pis) {
        this.resetConfirmationsButton.setEnabled(true);
        this.updateJavaPlatformComboItems();
        this.portNoSpinner.setValue((Object)pis.getPortNo());
        if (pis.getJavaPlatformForProfiling() != null) {
            this.javaPlatformCombo.setSelectedItem(pis.getJavaPlatformForProfiling());
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
        this.cpuLiveResultsCheckbox.setSelected(pis.getDisplayLiveResultsCPU());
        this.memoryLiveResultsCheckbox.setSelected(pis.getDisplayLiveResultsMemory());
        if (pis.getAutoOpenSnapshot() && pis.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        } else if (pis.getAutoOpenSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(OPEN_SNAPSHOT_RADIO_TEXT);
        } else if (pis.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(SAVE_SNAPSHOT_RADIO_TEXT);
        }
        if (pis.getOOMDetectionMode() == 0) {
            this.oomeCombo.setSelectedItem(OOME_NOTHING_TEXT);
        } else if (pis.getOOMDetectionMode() == 2) {
            this.oomeCombo.setSelectedItem(OOME_PROJECT_TEXT);
        } else if (pis.getOOMDetectionMode() == 1) {
            this.oomeCombo.setSelectedItem(OOME_TEMP_TEXT);
        } else if (pis.getOOMDetectionMode() == 3) {
            this.oomeCombo.setSelectedItem(OOME_CUSTOM_TEXT);
        }
        this.oomeDetectionDirTextField.setText(pis.getCustomHeapdumpPath());
        this.enableHeapWalkerAnalysisCheckbox.setSelected(pis.getHeapWalkerAnalysisEnabled());
        switch (pis.getTelemetryOverviewBehavior()) {
            case 1: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_ALWAYS);
                break;
            }
            case 2: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_MONITORING);
                break;
            }
            default: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_NEVER);
            }
        }
        switch (pis.getThreadsViewBehavior()) {
            case 1: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_ALWAYS);
                break;
            }
            case 2: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_MONITORING);
                break;
            }
            default: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_NEVER);
            }
        }
        this.updateEnabling();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup oomeRadiosGroup = new ButtonGroup();
        CategorySeparator generalSeparator = new CategorySeparator(ENGINE_SETTINGS_BORDER_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 6);
        this.add((Component)generalSeparator, gridBagConstraints);
        JLabel javaPlatformLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)javaPlatformLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(JAVA_PLAFORM_COMBO_ACCESS_DESCR);
        javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.managePlatformsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatformsButton, (String)MANAGE_PLATFORMS_BUTTON_NAME);
        this.managePlatformsButton.getAccessibleContext().setAccessibleDescription(MANAGE_PLATFORMS_BUTTON_NAME);
        this.managePlatformsButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 3, 0, 6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.managePlatformsButton, gridBagConstraints);
        JLabel portNoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)portNoLabel, (String)COMM_PORT_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)portNoLabel, gridBagConstraints);
        this.portNoSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        portNoLabel.setLabelFor((Component)this.portNoSpinner);
        if (this.portNoSpinner.getAccessibleContext() != null) {
            this.portNoSpinner.getAccessibleContext().setAccessibleDescription(PORT_NO_SPINNER_ACCESS_DESCR);
        }
        this.portNoSpinner.fixAccessibility();
        this.portNoSpinner.setModel((SpinnerModel)new SpinnerNumberModel(5140, 1, 65535, 1));
        this.portNoSpinner.setPreferredSize(new Dimension(this.portNoSpinner.getPreferredSize().width, this.javaPlatformCombo.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portNoSpinner, gridBagConstraints);
        CategorySeparator profilingStartSeparator = new CategorySeparator(WINDOWS_SETTINGS_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.add((Component)profilingStartSeparator, gridBagConstraints);
        JLabel telemetryOverviewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)telemetryOverviewLabel, (String)TELEMETRY_OVERVIEW_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)telemetryOverviewLabel, gridBagConstraints);
        this.telemetryOverviewCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        telemetryOverviewLabel.setLabelFor(this.telemetryOverviewCombo);
        this.telemetryOverviewCombo.getAccessibleContext().setAccessibleDescription(TELEMETRY_OVERVIEW_COMBO_ACCESS_DESCR);
        this.telemetryOverviewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{KEY_OPEN_ALWAYS, KEY_OPEN_MONITORING, KEY_OPEN_NEVER}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.telemetryOverviewCombo, gridBagConstraints);
        JLabel openThreadsViewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)openThreadsViewLabel, (String)THREADS_VIEW_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)openThreadsViewLabel, gridBagConstraints);
        this.openThreadsViewCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        openThreadsViewLabel.setLabelFor(this.openThreadsViewCombo);
        this.openThreadsViewCombo.getAccessibleContext().setAccessibleDescription(THREADS_VIEW_COMBO_ACCESS_DESCR + THREADS_VIEW_HINT_TEXT);
        this.openThreadsViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{KEY_OPEN_ALWAYS, KEY_OPEN_MONITORING, KEY_OPEN_NEVER}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.openThreadsViewCombo, gridBagConstraints);
        int maxWidth = Math.max(this.telemetryOverviewCombo.getPreferredSize().width, this.openThreadsViewCombo.getPreferredSize().width) + 15;
        int maxHeight = Math.max(this.telemetryOverviewCombo.getPreferredSize().height, this.openThreadsViewCombo.getPreferredSize().height);
        this.telemetryOverviewCombo.setPreferredSize(new Dimension(maxWidth, maxHeight));
        this.openThreadsViewCombo.setPreferredSize(new Dimension(maxWidth, maxHeight));
        JLabel liveResultsLabel = new JLabel(LIVE_RESULTS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)liveResultsLabel, gridBagConstraints);
        JPanel liveResultsPanel = new JPanel();
        liveResultsPanel.setLayout(new GridLayout(1, 2, 0, 0));
        this.cpuLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.cpuLiveResultsCheckbox, (String)CPU_CHCKBOX_TEXT);
        this.cpuLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(CPU_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR);
        liveResultsPanel.add(this.cpuLiveResultsCheckbox);
        this.memoryLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.memoryLiveResultsCheckbox, (String)MEMORY_CHCKBOX_TEXT);
        this.memoryLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(MEMORY_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR);
        liveResultsPanel.add(this.memoryLiveResultsCheckbox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)liveResultsPanel, gridBagConstraints);
        CategorySeparator miscellaneousSeparator = new CategorySeparator(SNAPSHOTS_SETTINGS_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)miscellaneousSeparator, gridBagConstraints);
        JLabel takingSnapshotLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)takingSnapshotLabel, (String)TAKING_SNAPSHOT_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)takingSnapshotLabel, gridBagConstraints);
        this.takingSnapshotCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        takingSnapshotLabel.setLabelFor(this.takingSnapshotCombo);
        this.takingSnapshotCombo.getAccessibleContext().setAccessibleDescription(TAKING_SNAPSHOT_COMBO_ACCESS_DESCR);
        this.takingSnapshotCombo.setModel(new DefaultComboBoxModel<String>(new String[]{OPEN_SNAPSHOT_RADIO_TEXT, SAVE_SNAPSHOT_RADIO_TEXT, OPEN_SAVE_SNAPSHOT_RADIO_TEXT}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.takingSnapshotCombo, gridBagConstraints);
        JLabel oomeDetectionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)oomeDetectionLabel, (String)OOME_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)oomeDetectionLabel, gridBagConstraints);
        this.oomeCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        oomeDetectionLabel.setLabelFor(this.oomeCombo);
        this.oomeCombo.getAccessibleContext().setAccessibleDescription(OOME_COMBO_ACCESS_DESCR);
        this.oomeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProfilerOptionsPanel.this.updateEnabling();
            }
        });
        this.oomeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{OOME_NOTHING_TEXT, OOME_PROJECT_TEXT, OOME_TEMP_TEXT, OOME_CUSTOM_TEXT}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.oomeCombo, gridBagConstraints);
        int maxWidth1 = Math.max(this.takingSnapshotCombo.getPreferredSize().width, this.oomeCombo.getPreferredSize().width);
        int maxHeight1 = Math.max(this.takingSnapshotCombo.getPreferredSize().height, this.oomeCombo.getPreferredSize().height);
        this.takingSnapshotCombo.setPreferredSize(new Dimension(maxWidth1, maxHeight1));
        this.oomeCombo.setPreferredSize(new Dimension(maxWidth1, maxHeight1));
        JPanel oomeDetectionPanel = new JPanel(new GridBagLayout());
        this.oomeDetectionDirTextField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((ProfilerOptionsPanel)ProfilerOptionsPanel.this).oomeDetectionChooseDirButton.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
            }
        };
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleName(OOME_CUSTOM_ACCESS_DESCR);
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleDescription(OOME_CUSTOM_TEXTFIELD_ACCESS_DESCR);
        this.oomeDetectionDirTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        oomeDetectionPanel.add((Component)this.oomeDetectionDirTextField, gridBagConstraints);
        this.oomeDetectionChooseDirButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.oomeDetectionChooseDirButton, (String)"&...");
        this.oomeDetectionChooseDirButton.getAccessibleContext().setAccessibleName(OOME_CUSTOM_BUTTON_ACCESS_NAME);
        this.oomeDetectionChooseDirButton.addActionListener(this);
        this.oomeDetectionChooseDirButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 17;
        oomeDetectionPanel.add((Component)this.oomeDetectionChooseDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)oomeDetectionPanel, gridBagConstraints);
        JLabel heapWalkerLabel = new JLabel(HEAPWALKER_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)heapWalkerLabel, gridBagConstraints);
        this.enableHeapWalkerAnalysisCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.enableHeapWalkerAnalysisCheckbox, (String)ENABLE_ANALYSIS_CHECKBOX);
        this.enableHeapWalkerAnalysisCheckbox.getAccessibleContext().setAccessibleDescription(ENABLE_ANALYSIS_CHECKBOX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.enableHeapWalkerAnalysisCheckbox, gridBagConstraints);
        JPanel resetConfirmationsPanel = new JPanel(new GridBagLayout());
        JTextArea resetConfirmationsArea = new JTextArea(RESET_HINT_TEXT){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 1;
                return size;
            }
        };
        resetConfirmationsArea.setOpaque(false);
        resetConfirmationsArea.setWrapStyleWord(true);
        resetConfirmationsArea.setLineWrap(true);
        resetConfirmationsArea.setEnabled(false);
        resetConfirmationsArea.setFont(UIManager.getFont("Label.font"));
        resetConfirmationsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        resetConfirmationsPanel.add((Component)resetConfirmationsArea, gridBagConstraints);
        this.resetConfirmationsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.resetConfirmationsButton, (String)RESET_BUTTON_NAME);
        this.resetConfirmationsButton.getAccessibleContext().setAccessibleDescription(RESET_HINT_TEXT);
        this.resetConfirmationsButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        resetConfirmationsPanel.add((Component)this.resetConfirmationsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)resetConfirmationsPanel, gridBagConstraints);
    }

    private void updateEnabling() {
        boolean customOOMEdirSelected = this.oomeCombo.getSelectedItem() == OOME_CUSTOM_TEXT;
        this.oomeDetectionDirTextField.setEnabled(customOOMEdirSelected);
        this.oomeDetectionChooseDirButton.setEnabled(customOOMEdirSelected);
    }

    private void updateJavaPlatformComboItems() {
        this.updateJavaPlatforms();
        Object selectedJavaPlatform = this.javaPlatformCombo.getSelectedItem();
        this.javaPlatformCombo.removeAllItems();
        DefaultComboBoxModel<Object> javaPlatformComboModel = new DefaultComboBoxModel<Object>(this.supportedJavaPlatformsNames.toArray());
        javaPlatformComboModel.insertElementAt(USE_PROJECT_JVM_TEXT, 0);
        this.javaPlatformCombo.setModel(javaPlatformComboModel);
        if (selectedJavaPlatform != null) {
            this.javaPlatformCombo.setSelectedItem(selectedJavaPlatform);
        }
    }

    private void updateJavaPlatforms() {
        this.supportedJavaPlatforms.clear();
        this.supportedJavaPlatformsNames.clear();
        for (JavaPlatform supportedJavaPlatform : JavaPlatformSelector.getSupportedPlatforms()) {
            String supportedJavaPlatformName = supportedJavaPlatform.getDisplayName();
            if (this.supportedJavaPlatformsNames.contains(supportedJavaPlatformName)) continue;
            this.supportedJavaPlatforms.add(supportedJavaPlatform);
            this.supportedJavaPlatformsNames.add(supportedJavaPlatformName);
        }
        this.supportedJavaPlatforms.addAll(JavaPlatformSelector.getSupportedPlatforms());
    }

    private static class CategorySeparator
    extends JPanel {
        private JLabel captionLabel;
        private JSeparator captionSeparator;

        public CategorySeparator(String caption) {
            this.initComponents();
            this.captionLabel.setText(caption);
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.captionLabel = new JLabel();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.captionLabel, constraints);
            this.captionSeparator = new JSeparator();
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 10;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)this.captionSeparator, constraints);
        }
    }
}

