/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.ProjectUtilities;

public class Utils {
    public static Dimension DIMENSION_SMALLEST = new Dimension(0, 0);
    private static int defaultSpinnerHeight = -1;

    public static AttachSettings getAttachSettings(Project project) {
        AttachSettings attachSettings = null;
        try {
            attachSettings = NetBeansProfiler.loadAttachSettings(project);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return attachSettings;
    }

    public static boolean isCPUSettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isCPUSettings(settings.getProfilingType());
    }

    public static boolean isCPUSettings(int type) {
        return type == 8 || type == 16 || type == 32;
    }

    public static int getDefaultSpinnerHeight() {
        if (defaultSpinnerHeight == -1) {
            defaultSpinnerHeight = new JTextField().getPreferredSize().height;
        }
        return defaultSpinnerHeight;
    }

    public static boolean isMemorySettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isMemorySettings(settings.getProfilingType());
    }

    public static boolean isMemorySettings(int type) {
        return type == 2 || type == 4;
    }

    public static boolean isMonitorSettings(ProfilingSettings settings) {
        if (settings == null) {
            return false;
        }
        return Utils.isMonitorSettings(settings.getProfilingType());
    }

    public static boolean isMonitorSettings(int type) {
        return type == 1;
    }

    public static String getProjectName(Project project) {
        if (project == null) {
            return SelectProfilingTask.EXTERNAL_APPLICATION_STRING;
        }
        ProjectInformation pi = ProjectUtils.getInformation((Project)project);
        return pi.getDisplayName();
    }

    public static SelectProfilingTask.SettingsConfigurator getSettingsConfigurator(Project project) {
        ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
        SelectProfilingTask.SettingsConfigurator configurator = ptp.getSettingsConfigurator();
        if (configurator == null) {
            return DefaultSettingsConfigurator.SHARED_INSTANCE;
        }
        return configurator;
    }

    public static JPanel createFillerPanel() {
        JPanel fillerPanel = new JPanel(new FlowLayout(0, 0, 3)){

            @Override
            public Dimension getPreferredSize() {
                return DIMENSION_SMALLEST;
            }
        };
        fillerPanel.setOpaque(false);
        return fillerPanel;
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator horizontalSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        return horizontalSeparator;
    }

    public static AttachSettings selectAttachSettings(Project project) {
        AttachSettings attachSettings = Utils.getAttachSettings(project);
        if (attachSettings == null) {
            attachSettings = new AttachSettings();
        }
        return AttachWizard.getDefault().configure(attachSettings);
    }
}

