/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class AppClientActionProvider
extends BaseActionProvider {
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto", "run.single.method", "debug.single.method"};
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public AppClientActionProvider(AppClientProject appClientProject, UpdateHelper updateHelper) {
        super((Project)appClientProject, updateHelper, appClientProject.evaluator(), appClientProject.getSourceRoots(), appClientProject.getTestSourceRoots(), appClientProject.getAntProjectHelper(), (BaseActionProvider.Callback)new BaseActionProvider.CallbackImpl(appClientProject.getClassPathProvider()));
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return false;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public String[] getTargetNames(String string, Lookup lookup, Properties properties, boolean bl) throws IllegalArgumentException {
        if (string.equals("run") || string.equals("redeploy") || string.equals("debug") || string.equals("debug.single") || string.equals("run.single")) {
            if (!this.isSelectedServer()) {
                String string2 = NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 2));
                return null;
            }
            if (this.isDebugged()) {
                properties.setProperty("is.debugged", "true");
            }
            if (string.equals("redeploy")) {
                properties.setProperty("forceRedeploy", "true");
            } else {
                properties.setProperty("forceRedeploy", "false");
            }
        }
        return super.getTargetNames(string, lookup, properties, bl);
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        boolean bl = super.isActionEnabled(string, lookup);
        if (bl && string.equals(COMMAND_VERIFY)) {
            return ((AppClientProject)this.getProject()).getCarModule().hasVerifierSupport();
        }
        if (string.equals("run") || string.equals("debug")) {
            return bl && this.isSelectedServer() && !this.isTargetServerRemote();
        }
        return bl;
    }

    private boolean isSelectedServer() {
        String[] stringArray;
        String string;
        String string2 = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string2 != null && (string = Deployment.getDefault().getServerID(string2)) != null) {
            return true;
        }
        string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (string != null && (stringArray = Deployment.getDefault().getInstancesOfServer(string)).length > 0) {
            this.setServerInstance(stringArray[0]);
            return true;
        }
        return false;
    }

    private void setServerInstance(String string) {
        AppClientProjectProperties.setServerInstance((AppClientProject)this.getProject(), this.getAntProjectHelper(), string);
    }

    private boolean isDebugged() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo serverDebugInfo = j2eeModuleProvider.getServerDebugInfo();
        if (serverDebugInfo == null) {
            return false;
        }
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            Object object;
            Session session = sessionArray[i];
            if (session == null || (object = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? attachingDICookie.getSharedMemoryName().equalsIgnoreCase(serverDebugInfo.getShmemName()) : attachingDICookie.getHostName().equalsIgnoreCase(serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
        String string = instanceProperties.getProperty("DOMAIN");
        String string2 = instanceProperties.getProperty("LOCATION");
        return "".equals(string) && "".equals(string2);
    }
}

