/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import org.netbeans.modules.dlight.api.execution.DLightSessionConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.support.NativeExecutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.core.ui.components.SelectExecutableTargetDialog;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class DLightRunExecutableAction
extends AbstractAction {
    protected SelectExecutableTargetDialog dialog = null;
    private DLightToolkitManagement.DLightSessionHandler session;

    public DLightRunExecutableAction() {
        super(NbBundle.getMessage(DLightRunExecutableAction.class, (String)"DLightRunExecutableAction.Name"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/core/ui/resources/runProject24.png", (boolean)false));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = new SelectExecutableTargetDialog();
        }
        Frame frame = WindowManager.getDefault().getMainWindow();
        this.dialog.show(frame);
        int res = this.dialog.getResult();
        if (res == 0) {
            String pname = this.dialog.getProgramName();
            String pargs = this.dialog.getProgramArguments();
            String pdir = this.dialog.getWorkingDirectory();
            String[] args = pargs.split(" ");
            if (pname != null) {
                NativeExecutableTargetConfiguration targetConf = new NativeExecutableTargetConfiguration(pname, args, null);
                targetConf.setWorkingDirectory(pdir);
                targetConf.putInfo("service.storage.dlight.run", "true");
                DLightConfiguration configuration = DLightConfigurationManager.getInstance().getConfigurationByName("DLight");
                NativeExecutableTarget target = new NativeExecutableTarget(targetConf);
                DLightSessionConfiguration sessionConfiguration = new DLightSessionConfiguration();
                sessionConfiguration.setDLightTarget((DLightTarget)target);
                sessionConfiguration.setDLightConfiguration(configuration);
                sessionConfiguration.setSessionName(pname);
                final Future handle = DLightToolkitManagement.getInstance().createSession(sessionConfiguration);
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DLightRunExecutableAction.this.session = (DLightToolkitManagement.DLightSessionHandler)handle.get();
                            DLightToolkitManagement.getInstance().startSession(DLightRunExecutableAction.this.session);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, (String)("DLight Session for " + target.toString()));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

