/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelIncludesExcludes;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.java.j2seproject.ui.wizards.WizardSettings;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewJ2SEProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private WizardType type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public NewJ2SEProjectWizardIterator() {
        this(WizardType.APP);
    }

    public NewJ2SEProjectWizardIterator(WizardType type) {
        this.type = type;
    }

    public static NewJ2SEProjectWizardIterator library() {
        return new NewJ2SEProjectWizardIterator(WizardType.LIB);
    }

    public static NewJ2SEProjectWizardIterator existing() {
        return new NewJ2SEProjectWizardIterator(WizardType.EXT);
    }

    private WizardDescriptor.Panel[] createPanels() {
        switch (this.type) {
            case EXT: {
                return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new PanelSourceFolders.Panel(), new PanelIncludesExcludes()};
            }
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        switch (this.type) {
            case EXT: {
                return new String[]{NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject"), NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots"), NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_PanelIncludesExcludes")};
            }
        }
        return new String[]{NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    public Set<?> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start(4);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF == null) {
            throw new NullPointerException("projdir == null, props:" + this.wiz.getProperties());
        }
        dirF = FileUtil.normalizeFile((File)dirF);
        String name = (String)this.wiz.getProperty("name");
        String mainClass = (String)this.wiz.getProperty("mainClass");
        String librariesDefinition = (String)this.wiz.getProperty("sharedLibraries");
        if (librariesDefinition != null) {
            if (!librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + "nblibraries.properties";
        }
        handle.progress(NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        switch (this.type) {
            case EXT: {
                File[] sourceFolders = (File[])this.wiz.getProperty("sourceRoot");
                File[] testFolders = (File[])this.wiz.getProperty("testRoot");
                String buildScriptName = (String)this.wiz.getProperty("buildScriptName");
                AntProjectHelper h = J2SEProjectGenerator.createProject(dirF, name, sourceFolders, testFolders, MANIFEST_FILE, librariesDefinition, buildScriptName);
                EditableProperties ep = h.getProperties("nbproject/project.properties");
                String includes = (String)this.wiz.getProperty("includes");
                if (includes == null) {
                    includes = "**";
                }
                ep.setProperty("includes", includes);
                String excludes = (String)this.wiz.getProperty("excludes");
                if (excludes == null) {
                    excludes = "";
                }
                ep.setProperty("excludes", excludes);
                h.putProperties("nbproject/project.properties", ep);
                handle.progress(2);
                for (File f : sourceFolders) {
                    FileObject srcFo = FileUtil.toFileObject((File)f);
                    if (srcFo == null) continue;
                    resultSet.add(srcFo);
                }
                break;
            }
            default: {
                AntProjectHelper h = J2SEProjectGenerator.createProject(dirF, name, mainClass, this.type == WizardType.APP ? MANIFEST_FILE : null, librariesDefinition);
                handle.progress(2);
                if (mainClass == null || mainClass.length() <= 0) break;
                try {
                    FileObject sourcesRoot = h.getProjectDirectory().getFileObject("src");
                    FileObject mainClassFo = this.getMainClassFO(sourcesRoot, mainClass);
                    assert (mainClassFo != null) : "sourcesRoot: " + sourcesRoot + ", mainClass: " + mainClass;
                    resultSet.add(mainClassFo);
                    break;
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        switch (this.type) {
            case APP: {
                NewJ2SEProjectWizardIterator.createManifest(dir, false);
                break;
            }
            case EXT: {
                NewJ2SEProjectWizardIterator.createManifest(dir, true);
            }
        }
        handle.progress(3);
        int ind = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case APP: {
                WizardSettings.setNewApplicationCount(ind);
                break;
            }
            case LIB: {
                WizardSettings.setNewLibraryCount(ind);
                break;
            }
            case EXT: {
                WizardSettings.setNewProjectCount(ind);
            }
        }
        resultSet.add(dir);
        handle.progress(NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        SharableLibrariesUtils.setLastProjectSharable((librariesDefinition != null ? 1 : 0) != 0);
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            switch (this.type) {
                case EXT: {
                    this.wiz.putProperty("sourceRoot", null);
                    this.wiz.putProperty("testRoot", null);
                }
            }
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getMainClassFO(FileObject sourcesRoot, String mainClass) {
        mainClass = mainClass.replace('.', '/');
        return sourcesRoot.getFileObject(mainClass + ".java");
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, boolean skeepIfExists) throws IOException {
        if (skeepIfExists && dir.getFileObject(MANIFEST_FILE) != null) {
            return;
        }
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static enum WizardType {
        APP,
        LIB,
        EXT;

    }
}

