/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.jdesktop.application.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class ActionManager {
    private static Map<Project, ActionManager> ams;
    private Map<String, List<ProxyAction>> actions;
    private List<ProxyAction> actionList;
    private Map<String, List<RADComponent>> boundComponents = new HashMap<String, List<RADComponent>>();
    private List<PropertyChangeListener> pcls;
    private List<ActionChangedListener> acls;
    private FileObject root;
    private Project project;
    private static List<FileObject> scanQueue;
    private static Timer rescanTimer;
    private static final String TASK_CLASS_TEMPLATE = "    private class MyTask extends org.jdesktop.application.Task<Object, Void> {\n        MyTask(org.jdesktop.application.Application app) {\n            // Runs on the EDT.  Copy GUI state that\n            // doInBackground() depends on from parameters\n            // to MyTask fields, here.\n            super(app);\n__CTOR_CODE__        }\n        @Override protected Object doInBackground() {\n            // Your Task's code here.  This method runs\n            // on a background thread, so don't reference\n            // the Swing GUI from here.\n            return null;  // return your result\n        }\n        @Override protected void succeeded(Object result) {\n            // Runs on the EDT.  Update the GUI based on\n            // the result computed by doInBackground().\n        }\n    }\n";
    private static Set<FormModel> registeredForms;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionManager getActionManager(FileObject fileInProject) {
        Project proj;
        ActionManager am;
        if (ams == null) {
            ams = Collections.synchronizedMap(new HashMap());
        }
        if ((am = ams.get(proj = ActionManager.getProject(fileInProject))) != null || !ActionManager.canHaveActions(fileInProject)) return am;
        Class<ActionManager> clazz = ActionManager.class;
        synchronized (ActionManager.class) {
            if (ams.get(proj) != null) return am;
            ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(fileInProject);
            am = new ActionManager(proj, root);
            ams.put(proj, am);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return am;
        }
    }

    public static ActionManager getActionManager(Project project) {
        Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
        if (srcs == null) {
            return null;
        }
        SourceGroup[] groups = srcs.getSourceGroups("java");
        if (groups != null && groups.length > 0) {
            return ActionManager.getActionManager(groups[0].getRootFolder());
        }
        return null;
    }

    static boolean canHaveActions(FileObject fileInProject) {
        return AppFrameworkSupport.isFrameworkLibAvailable(fileInProject);
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject getApplicationClassFile() {
        String appClassName = AppFrameworkSupport.getApplicationClassName(this.getRoot());
        return appClassName == null ? null : this.getFileForClass(appClassName);
    }

    private ActionManager(Project project, FileObject root) {
        this.project = project;
        this.root = root;
        this.actionList = new ArrayList<ProxyAction>();
        this.pcls = new ArrayList<PropertyChangeListener>();
        this.acls = new ArrayList<ActionChangedListener>();
        this.actions = new HashMap<String, List<ProxyAction>>();
    }

    public FileObject getRoot() {
        return this.root;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcls.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcls.remove(pcl);
    }

    public void addActionChangedListener(ActionChangedListener acl) {
        this.acls.add(acl);
    }

    public void removeActionChangedListener(ActionChangedListener acl) {
        this.acls.remove(acl);
    }

    public void rescan() {
        this.actions = new HashMap<String, List<ProxyAction>>();
        FileObject root = this.getRoot();
        if (root != null) {
            ActionManager.scanFolderForActions(root, this.actions);
        }
        this.actionList.clear();
        for (String appClsName : this.actions.keySet()) {
            this.actionList.addAll((Collection<ProxyAction>)this.actions.get(appClsName));
        }
        this.fireStructureChanged();
    }

    public static synchronized void lazyRescan(FileObject fo) {
        if (scanQueue != null && !scanQueue.contains(fo)) {
            scanQueue.add(fo);
        }
    }

    private static synchronized void startAutoRescan() {
        if (scanQueue == null) {
            scanQueue = Collections.synchronizedList(new ArrayList());
            rescanTimer = new Timer(3000, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList queue;
                    if (scanQueue == null || scanQueue.isEmpty()) {
                        return;
                    }
                    List list = scanQueue;
                    synchronized (list) {
                        queue = new ArrayList(scanQueue);
                        scanQueue.clear();
                    }
                    for (FileObject fo : queue) {
                        if (fo == null || !fo.isValid()) continue;
                        String className = AppFrameworkSupport.getClassNameForFile(fo);
                        ActionManager am = ActionManager.getActionManager(fo);
                        Map actions = am.actions;
                        if (actions.containsKey(className)) {
                            List oldActions = (List)actions.get(className);
                            for (ProxyAction oldAct : oldActions) {
                                Iterator ait = am.actionList.iterator();
                                while (ait.hasNext()) {
                                    if (!ActionManager.actionsMatch((ProxyAction)ait.next(), oldAct)) continue;
                                    ait.remove();
                                }
                            }
                            actions.remove(className);
                        }
                        ActionManager.getActionsFromFile(fo, actions);
                        if (actions.containsKey(className)) {
                            List newActions = (List)actions.get(className);
                            am.actionList.addAll(newActions);
                        }
                        am.fireStructureChanged();
                    }
                }
            });
            rescanTimer.start();
        }
    }

    private static synchronized void stopAutoRescan() {
        if (scanQueue != null) {
            rescanTimer.stop();
            scanQueue = null;
            rescanTimer = null;
        }
    }

    public List<ProxyAction> getAllActions() {
        return this.actionList;
    }

    public Collection<String> getAllClasses() {
        return this.actions.keySet();
    }

    public List<ProxyAction> getActions(String defClass, boolean rescan) {
        List<ProxyAction> list;
        if (rescan) {
            ActionManager.getActionsFromFile(this.getFileForClass(defClass), this.actions);
        }
        return (list = this.actions.get(defClass)) != null ? list : Collections.emptyList();
    }

    public static List<ProxyAction> getActions(FileObject sourceFile, boolean rescan) {
        ActionManager am = ActionManager.getActionManager(sourceFile);
        if (rescan) {
            ActionManager.getActionsFromFile(sourceFile, am.actions);
        }
        return am.getActions(AppFrameworkSupport.getClassNameForFile(sourceFile), false);
    }

    void jumpToActionSource(ProxyAction action) {
        FileObject sourceFile = this.getFileForClass(action.getClassname());
        try {
            Integer result = (Integer)new ActionMethodTask<Integer>(sourceFile, action.getMethodName()){

                @Override
                Integer run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                    return (int)controller.getTrees().getSourcePositions().getStartPosition(controller.getCompilationUnit(), methodTree);
                }
            }.execute();
            int position = result;
            Line lineObj = null;
            EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)sourceFile).getCookie(EditorCookie.class);
            if (editorCookie != null) {
                if (editorCookie.getDocument() == null) {
                    editorCookie.openDocument();
                }
                editorCookie.open();
                StyledDocument doc = editorCookie.getDocument();
                String sub = doc.getText(position, doc.getLength() - position);
                int i = sub.indexOf(123);
                if (i >= 0) {
                    while (++i < sub.length()) {
                        if (sub.charAt(i) <= ' ') continue;
                        position += i;
                        break;
                    }
                }
                Line.Set lineSet = editorCookie.getLineSet();
                int line = doc.getParagraphElement(0).getParentElement().getElementIndex(position);
                lineObj = lineSet.getCurrent(line);
            }
            if (lineObj == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                lineObj.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ActionManager.class.getName()).log(Level.INFO, null, ex);
        }
    }

    boolean isExistingMethod(String className, String methodName) {
        FileObject sourceFile = this.getFileForClass(className);
        try {
            Boolean result = (Boolean)new ActionMethodTask<Boolean>(sourceFile, methodName){

                @Override
                Boolean run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                    return true;
                }
            }.execute();
            return Boolean.TRUE.equals(result);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    boolean createActionMethod(final ProxyAction action) {
        if (this.isExistingMethod(action.getClassname(), action.getMethodName())) {
            return true;
        }
        try {
            String newTaskName;
            String taskName;
            final FileObject sourceFile = this.getFileForClass(action.getClassname());
            if (action.isTaskEnabled()) {
                taskName = ActionManager.taskNameForAction(action);
                newTaskName = this.getNonExistingTaskName(action.getClassname(), taskName);
            } else {
                taskName = null;
                newTaskName = null;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)sourceFile);
            ModificationResult result = js.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    MethodTree newMethod;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cut = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    for (Tree tree : cut.getTypeDecls()) {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                        ClassTree classT = (ClassTree)tree;
                        if (!sourceFile.getName().equals(classT.getSimpleName().toString())) continue;
                        classTree = classT;
                        break;
                    }
                    if (classTree == null) {
                        return;
                    }
                    TreeMaker make = workingCopy.getTreeMaker();
                    AnnotationTree annotationTree = ActionManager.createAnnotation(action, make, workingCopy);
                    ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(annotationTree));
                    if (action.isTaskEnabled()) {
                        boolean hasAppGetter = AppFrameworkSupport.isViewClass(classTree, (CompilationController)workingCopy);
                        newMethod = make.Method(methodModifiers, (CharSequence)action.getMethodName(), (Tree)make.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{\n" + ActionManager.getTaskInstantiationCode(taskName, sourceFile, hasAppGetter) + "}", null);
                    } else {
                        newMethod = make.Method(methodModifiers, (CharSequence)action.getMethodName(), (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), make.Block(Collections.emptyList(), false), null);
                    }
                    int insertIndex = -1;
                    List<? extends Tree> members = classTree.getMembers();
                    int index = members.size();
                    ListIterator<? extends Tree> it = members.listIterator(index);
                    while (it.hasPrevious()) {
                        Tree t = it.previous();
                        if (t.getKind() == Tree.Kind.METHOD || TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                            insertIndex = index;
                            break;
                        }
                        --index;
                    }
                    ClassTree modifiedClassTree = insertIndex < 0 ? make.addClassMember(classTree, (Tree)newMethod) : make.insertClassMember(classTree, insertIndex, (Tree)newMethod);
                    workingCopy.rewrite((Tree)classTree, (Tree)modifiedClassTree);
                }
            });
            result.commit();
            if (newTaskName != null) {
                DataObject dobj = DataObject.find((FileObject)sourceFile);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec == null) {
                    return false;
                }
                if (ec.getDocument() == null) {
                    ec.openDocument();
                }
                StyledDocument doc = ec.getDocument();
                Integer methodEndPosition = (Integer)new ActionMethodTask<Integer>(sourceFile, action.getMethodName()){

                    @Override
                    Integer run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                        return (int)controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), methodTree);
                    }
                }.execute();
                Element docRoot = doc.getDefaultRootElement();
                int pos = docRoot.getElement(docRoot.getElementIndex(methodEndPosition + 1)).getStartOffset();
                StringBuilder buf = new StringBuilder();
                buf.append("\n").append(this.getTaskClassImplCode(newTaskName, null)).append("\n");
                doc.insertString(pos, buf.toString(), null);
            }
            this.generateProperties(action, sourceFile);
            return true;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    private static String taskNameForAction(ProxyAction action) {
        String actionName = action.getId();
        return actionName.substring(0, 1).toUpperCase() + actionName.substring(1) + "Task";
    }

    private String getNonExistingTaskName(String className, final String taskName) {
        FileObject sourceFile = this.getFileForClass(className);
        try {
            String result = (String)new ClassTask<String>(sourceFile){

                @Override
                String run(CompilationController controller, ClassTree classTree, TypeElement classElement) {
                    for (TypeElement el : ElementFilter.typesIn(classElement.getEnclosedElements())) {
                        if (!el.getSimpleName().toString().equals(taskName)) continue;
                        return null;
                    }
                    return taskName;
                }
            }.execute();
            return result;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return taskName;
        }
    }

    private static AnnotationTree createAnnotation(ProxyAction action, TreeMaker make, WorkingCopy workingCopy) {
        LinkedList<AssignmentTree> annAttrs = new LinkedList<AssignmentTree>();
        for (String attrName : ProxyAction.getAnnotationAttributeNames()) {
            ExpressionTree expTree;
            if (!action.isAnnotationAttributeSet(attrName)) continue;
            Object value = action.getAnnotationAttributeValue(attrName);
            if (value instanceof String) {
                expTree = make.Literal(value);
            } else {
                if (!(value instanceof ProxyAction.BlockingType)) continue;
                expTree = make.MemberSelect((ExpressionTree)make.MemberSelect(make.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), (CharSequence)"BlockingScope"), (CharSequence)value.toString());
            }
            IdentifierTree identTree = make.Identifier((CharSequence)attrName);
            AssignmentTree attrTree = make.Assignment((ExpressionTree)identTree, expTree);
            annAttrs.add(attrTree);
        }
        return make.Annotation((Tree)make.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Action")), annAttrs);
    }

    private static String getTaskInstantiationCode(String taskName, FileObject sourceFile, boolean hasAppGetter) {
        return "return new " + taskName + "(" + (hasAppGetter ? "getApplication()" : AppFrameworkSupport.getApplicationCode(sourceFile)) + ");\n";
    }

    private String getTaskClassImplCode(String taskName, String ctorCode) {
        if (ctorCode == null) {
            ctorCode = "";
        }
        if (ctorCode.length() > 0 && !ctorCode.endsWith("\n")) {
            ctorCode = ctorCode + "\n";
        }
        if (ctorCode.length() > 0) {
            StringBuilder buf = new StringBuilder();
            String indent = "            ";
            int index = 0;
            boolean lineStart = true;
            for (int i = 0; i < ctorCode.length(); ++i) {
                char c = ctorCode.charAt(i);
                if (c == '\n') {
                    if (lineStart) {
                        buf.append("\n");
                    } else {
                        buf.append(ctorCode.substring(index, i + 1));
                    }
                    lineStart = true;
                    index = i + 1;
                    continue;
                }
                if (c <= ' ' || !lineStart) continue;
                buf.append(indent);
                lineStart = false;
                index = i;
            }
            ctorCode = buf.toString();
        }
        return TASK_CLASS_TEMPLATE.replace("__CTOR_CODE__", ctorCode).replace("MyTask", taskName);
    }

    public List<RADComponent> getBoundComponents(ProxyAction act) {
        if (!this.boundComponents.containsKey(this.getKey(act))) {
            return new ArrayList<RADComponent>();
        }
        return this.boundComponents.get(this.getKey(act));
    }

    public void removeAllBoundComponents(FormModel model) {
        for (String key : this.boundComponents.keySet()) {
            List<RADComponent> comps = this.boundComponents.get(key);
            Iterator<RADComponent> it = comps.iterator();
            while (it.hasNext()) {
                RADComponent comp = it.next();
                if (comp == null || comp.getFormModel() != model) continue;
                it.remove();
            }
        }
    }

    public void addNewAction(ProxyAction act) {
        List<ProxyAction> list = this.actions.get(act.getClassname());
        if (list == null) {
            list = new ArrayList<ProxyAction>();
            this.actions.put(act.getClassname(), list);
        }
        list.add(act);
        this.actionList.add(act);
        this.fireStructureChanged();
    }

    private boolean safeReplace(List<ProxyAction> actions, ProxyAction action) {
        for (int i = 0; i < this.actionList.size(); ++i) {
            ProxyAction target = this.actionList.get(i);
            if (!ActionManager.actionsMatch(action, target)) continue;
            this.actionList.remove(target);
            this.actionList.add(i, action);
            return true;
        }
        return false;
    }

    public void updateAction(ProxyAction action) {
        List<ProxyAction> actions = this.getActions(action.getClassname(), false);
        boolean replaced = false;
        for (ProxyAction a : actions) {
            if (!a.getId().equals(action.getId())) continue;
            int n = actions.indexOf(a);
            if (n >= 0) {
                actions.remove(n);
                actions.add(n, action);
            }
            for (int i = 0; i < this.actionList.size(); ++i) {
                ProxyAction target = this.actionList.get(i);
                if (!ActionManager.actionsMatch(action, target)) continue;
                this.actionList.remove(target);
                this.actionList.add(i, action);
            }
            replaced = true;
            break;
        }
        if (this.getFileForClass(action.getClassname()) == null) {
            replaced = this.safeReplace(this.actionList, action);
        }
        if (!replaced) {
            if (this.getFileForClass(action.getClassname()) != null) {
                actions.add(action);
            }
            this.actionList.add(action);
        }
        if (this.getFileForClass(action.getClassname()) != null) {
            this.updateActionMethod(action, this.getFileForClass(action.getClassname()));
        }
        this.fireActionChanged(action);
        List<RADComponent> boundList = this.getBoundComponents(action);
        for (RADComponent comp : boundList) {
            RADProperty prop;
            if (comp == null || (prop = comp.getBeanProperty("action")) == null) continue;
            try {
                if (!(prop.getValue() instanceof ProxyAction)) continue;
                prop.setValue(null);
                prop.setValue((Object)action);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ActionManager.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(ActionManager.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }

    private void updateActionMethod(final ProxyAction action, final FileObject sourceFile) {
        try {
            String[] oldBodyText;
            String newTaskName;
            String taskName;
            if (action.isTaskEnabled()) {
                taskName = ActionManager.taskNameForAction(action);
                newTaskName = this.getNonExistingTaskName(action.getClassname(), taskName);
                oldBodyText = new String[1];
            } else {
                taskName = null;
                newTaskName = null;
                oldBodyText = null;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)sourceFile);
            ModificationResult result = js.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cut = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    for (Tree tree : cut.getTypeDecls()) {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                        ClassTree classT = (ClassTree)tree;
                        if (!sourceFile.getName().equals(classT.getSimpleName().toString())) continue;
                        classTree = classT;
                        break;
                    }
                    if (classTree == null) {
                        return;
                    }
                    Trees trees = workingCopy.getTrees();
                    TypeElement typeElement = (TypeElement)trees.getElement(trees.getPath(cut, classTree));
                    MethodTree method = null;
                    ExecutableElement methodEl = null;
                    AnnotationTree annotation = null;
                    for (ExecutableElement el : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        if (!el.getSimpleName().toString().equals(action.getMethodName()) || !el.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                        MethodTree mt = trees.getTree(el);
                        for (AnnotationTree annotationTree : mt.getModifiers().getAnnotations()) {
                            TypeElement annEl = (TypeElement)trees.getElement(trees.getPath(cut, annotationTree.getAnnotationType()));
                            if (!annEl.getQualifiedName().toString().equals("org.jdesktop.application.Action")) continue;
                            annotation = annotationTree;
                            break;
                        }
                        if (annotation == null) continue;
                        method = mt;
                        methodEl = el;
                        break;
                    }
                    if (method == null) {
                        return;
                    }
                    TreeMaker make = workingCopy.getTreeMaker();
                    AnnotationTree newAnnotation = ActionManager.createAnnotation(action, make, workingCopy);
                    workingCopy.rewrite(annotation, (Tree)newAnnotation);
                    if (ActionManager.isAsyncActionMethod(methodEl) != action.isTaskEnabled()) {
                        MethodTree newMethod;
                        BlockTree body = method.getBody();
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        int start = (int)sourcePositions.getStartPosition(cut, body);
                        int end = (int)sourcePositions.getEndPosition(cut, body);
                        String bodyText = ActionManager.getMethodBodyWithoutBraces(workingCopy.getText().substring(start, end));
                        if (action.isTaskEnabled()) {
                            if (newTaskName != null) {
                                oldBodyText[0] = bodyText;
                                bodyText = "";
                            } else {
                                bodyText = ActionManager.getCommentedBodyText(bodyText);
                            }
                            boolean hasAppGetter = AppFrameworkSupport.isViewClass(classTree, (CompilationController)workingCopy);
                            newMethod = make.Method(method.getModifiers(), (CharSequence)method.getName(), (Tree)make.QualIdent((javax.lang.model.element.Element)workingCopy.getElements().getTypeElement("org.jdesktop.application.Task")), method.getTypeParameters(), method.getParameters(), method.getThrows(), "{\n" + ActionManager.getTaskInstantiationCode(taskName, sourceFile, hasAppGetter) + bodyText + "}", null);
                        } else {
                            newMethod = make.Method(method.getModifiers(), (CharSequence)method.getName(), (Tree)make.PrimitiveType(TypeKind.VOID), method.getTypeParameters(), method.getParameters(), method.getThrows(), "{\n" + ActionManager.getCommentedBodyText(bodyText) + "}", null);
                        }
                        workingCopy.rewrite((Tree)method, (Tree)newMethod);
                    }
                }
            });
            result.commit();
            DataObject dobj = DataObject.find((FileObject)sourceFile);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec == null) {
                return;
            }
            if (ec.getDocument() == null) {
                ec.openDocument();
            }
            StyledDocument doc = ec.getDocument();
            if (newTaskName != null) {
                Integer methodEndPosition = (Integer)new ActionMethodTask<Integer>(sourceFile, action.getMethodName()){

                    @Override
                    Integer run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                        return (int)controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), methodTree);
                    }
                }.execute();
                Element docRoot = doc.getDefaultRootElement();
                int pos = docRoot.getElement(docRoot.getElementIndex(methodEndPosition) + 1).getStartOffset();
                doc.insertString(pos, "\n" + this.getTaskClassImplCode(newTaskName, oldBodyText[0]), null);
            }
            this.generateProperties(action, sourceFile);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private void generateProperties(ProxyAction action, FileObject sourceFile) {
        String enabledProperty;
        if (action.isAnnotationAttributeSet("enabledProperty") && !ActionManager.findBooleanProperty(enabledProperty = (String)action.getAnnotationAttributeValue("enabledProperty"), sourceFile)) {
            ActionManager.generatePropertyGetterAndSetter(enabledProperty, sourceFile);
        }
        if (action.isAnnotationAttributeSet("selectedProperty") && !ActionManager.findBooleanProperty(enabledProperty = (String)action.getAnnotationAttributeValue("selectedProperty"), sourceFile)) {
            ActionManager.generatePropertyGetterAndSetter(enabledProperty, sourceFile);
        }
    }

    private static boolean findBooleanProperty(String enabledProperty, FileObject sourceFile) {
        List<String> props = ActionManager.findBooleanProperties(sourceFile);
        for (String prop : props) {
            if (!prop.equals(enabledProperty)) continue;
            return true;
        }
        return false;
    }

    private static boolean generatePropertyGetterAndSetter(String propertyName, FileObject sourceFile) {
        try {
            int pos;
            DataObject dobj = DataObject.find((FileObject)sourceFile);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec == null) {
                return false;
            }
            if (ec.getDocument() == null) {
                ec.openDocument();
            }
            StyledDocument doc = ec.getDocument();
            if (ec instanceof FormEditorSupport) {
                doc = ec.getDocument();
                pos = ((FormEditorSupport)ec).getVariablesSection().getStartPosition().getOffset();
            } else {
                Integer result = (Integer)new ClassTask<Integer>(sourceFile){

                    @Override
                    Integer run(CompilationController controller, ClassTree classTree, TypeElement classElement) {
                        return (int)controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), classTree);
                    }
                }.execute();
                Element docRoot = doc.getDefaultRootElement();
                pos = docRoot.getElement(docRoot.getElementIndex(result)).getStartOffset();
            }
            String code = ActionManager.getPropertyGetterAndSetterBodyText(propertyName);
            doc.insertString(pos, code.toString(), null);
            return true;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    private static String getPropertyGetterAndSetterBodyText(String prop) {
        StringBuilder buf = new StringBuilder();
        String indent = "    ";
        String getterName = "is" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        String setterName = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        buf.append(indent).append("private boolean ").append(prop).append(" = false;\n");
        buf.append(indent).append("public boolean ").append(getterName).append("() {\n");
        buf.append(indent).append(indent).append("return ").append(prop).append(";\n");
        buf.append(indent).append("}\n");
        buf.append("\n");
        buf.append(indent).append("public void ").append(setterName).append("(boolean b) {\n");
        buf.append(indent).append(indent).append("boolean old = ").append(getterName).append("();\n");
        buf.append(indent).append(indent).append("this.").append(prop).append(" = b;\n");
        buf.append(indent).append(indent).append("firePropertyChange(\"").append(prop).append("\", old, ").append(getterName).append("());\n");
        buf.append(indent).append("}\n\n");
        return buf.toString();
    }

    private static String getCommentedBodyText(String bodyText) {
        bodyText = ActionManager.getMethodBodyWithoutBraces(bodyText);
        StringBuilder buf = new StringBuilder();
        int lineStart = 0;
        for (int i = 0; i < bodyText.length(); ++i) {
            char c = bodyText.charAt(i);
            if (c != '\n' && i + 1 != bodyText.length()) continue;
            buf.append("// ");
            buf.append(bodyText.substring(lineStart, i + 1));
            lineStart = i + 1;
        }
        return buf.toString();
    }

    private static String getMethodBodyWithoutBraces(String bodyText) {
        char c;
        int i;
        int first = -1;
        int last = -1;
        for (i = 0; i < bodyText.length() && ((c = bodyText.charAt(i)) <= ' ' || c == '{' && first < 0); ++i) {
            if (c == '\n' && first >= 0) {
                first = i + 1;
                break;
            }
            if (c != '{') continue;
            first = i + 1;
        }
        for (i = bodyText.length() - 1; i >= 0 && ((c = bodyText.charAt(i)) <= ' ' || c == '}' && last < 0); --i) {
            if (c == '\n' && first >= 0) {
                last = i + 1;
                break;
            }
            if (c != '}') continue;
            last = i;
        }
        return bodyText.substring(first >= 0 ? first : 0, last >= 0 ? last : bodyText.length());
    }

    private static int[] getAnnotationPositions(ProxyAction action, FileObject sourceFile) throws IOException {
        return (int[])new ActionMethodTask<int[]>(sourceFile, action.getMethodName()){

            @Override
            int[] run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                CompilationUnitTree cut = controller.getCompilationUnit();
                Trees trees = controller.getTrees();
                ModifiersTree modifiers = methodTree.getModifiers();
                for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                    TypeElement annEl = (TypeElement)trees.getElement(trees.getPath(cut, annotationTree.getAnnotationType()));
                    if (!annEl.getQualifiedName().toString().equals("org.jdesktop.application.Action")) continue;
                    SourcePositions positions = trees.getSourcePositions();
                    return new int[]{(int)positions.getStartPosition(cut, annotationTree), (int)positions.getEndPosition(cut, annotationTree)};
                }
                return null;
            }
        }.execute();
    }

    public void deleteAction(ProxyAction action) {
        FileObject formfile;
        String defClass = action.getClassname();
        FileObject file = this.getFileForClass(defClass);
        DesignResourceMap map = ResourceUtils.getDesignResourceMap(file, true);
        Collection<String> col = map.collectKeys(action.getId() + "\\..*", true);
        for (String s : col) {
            ResourceValueImpl res = map.getResourceValue(s, String.class);
            if (res == null) continue;
            map.removeResourceValue(res);
        }
        Iterator<ProxyAction> it = this.getActions(defClass, false).iterator();
        while (it.hasNext()) {
            ProxyAction a = it.next();
            if (!a.getId().equals(action.getId())) continue;
            it.remove();
            Iterator<ProxyAction> it2 = this.actionList.iterator();
            while (it2.hasNext()) {
                ProxyAction pact = it2.next();
                if (!ActionManager.actionsMatch(pact, a)) continue;
                it2.remove();
            }
            break block3;
        }
        if (this.hasFormFile(file) && (formfile = this.getFormFile(file)).canRead()) {
            try {
                FormModel mod = this.getFormModel(formfile);
                this.deleteAction(action, mod);
            }
            catch (Exception ex) {
                Logger.getLogger(ActionManager.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        ActionManager.deleteActionAnnotation(action, file);
    }

    private static void deleteActionAnnotation(ProxyAction action, FileObject sourceFile) {
        try {
            int lineEnd;
            int[] positions = ActionManager.getAnnotationPositions(action, sourceFile);
            if (positions == null) {
                return;
            }
            DataObject dobj = DataObject.find((FileObject)sourceFile);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec == null) {
                return;
            }
            StyledDocument doc = ec.getDocument();
            int startPos = positions[0];
            int endPos = positions[1];
            String annotationText = doc.getText(startPos, endPos - startPos);
            Element docRoot = doc.getDefaultRootElement();
            Element line = docRoot.getElement(docRoot.getElementIndex(startPos));
            int lineStart = line.getStartOffset();
            if (doc.getText(lineStart, (lineEnd = line.getEndOffset()) - lineStart).trim().equals(annotationText)) {
                startPos = lineStart;
                endPos = lineEnd;
            }
            doc.remove(startPos, endPos - startPos);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void addRADComponent(ProxyAction act, RADComponent comp) {
        if (comp == null) {
            return;
        }
        if (!this.boundComponents.containsKey(this.getKey(act))) {
            this.boundComponents.put(this.getKey(act), new ArrayList());
        }
        if (this.boundComponents.get(this.getKey(act)).contains(comp)) {
            return;
        }
        this.boundComponents.get(this.getKey(act)).add(comp);
        this.fireActionChanged(act);
    }

    void removeRADComponent(ProxyAction act, RADComponent radComponent) {
        if (this.boundComponents.containsKey(this.getKey(act))) {
            this.boundComponents.get(this.getKey(act)).remove(radComponent);
        }
        this.fireActionChanged(act);
    }

    private static Project getProject(FileObject fileInProject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        return project;
    }

    private static void scanFolderForActions(FileObject folder, Map<String, List<ProxyAction>> classNameToActions) {
        for (FileObject fo : folder.getChildren()) {
            if (fo.isFolder()) {
                ActionManager.scanFolderForActions(fo, classNameToActions);
                continue;
            }
            if (!fo.getExt().equalsIgnoreCase("java")) continue;
            ActionManager.getActionsFromFile(fo, classNameToActions);
        }
    }

    private static void getActionsFromFile(FileObject sourceFile, Map<String, List<ProxyAction>> classNameToActions) {
        if (sourceFile == null) {
            return;
        }
        try {
            List result = (List)new ClassTask<List<ProxyAction>>(sourceFile){

                @Override
                List<ProxyAction> run(CompilationController controller, ClassTree classTree, TypeElement classElement) {
                    LinkedList<TypeElement> classList = new LinkedList<TypeElement>();
                    Tree superT = classTree.getExtendsClause();
                    if (superT != null) {
                        TreePath superTPath = controller.getTrees().getPath(controller.getCompilationUnit(), superT);
                        javax.lang.model.element.Element superEl = controller.getTrees().getElement(superTPath);
                        while (superEl != null && superEl.getKind() == ElementKind.CLASS) {
                            TypeElement superClassEl = (TypeElement)superEl;
                            classList.add(0, superClassEl);
                            TypeMirror superType = superClassEl.getSuperclass();
                            superEl = superType.getKind() == TypeKind.DECLARED ? ((DeclaredType)superType).asElement() : null;
                        }
                    }
                    classList.add(classElement);
                    ArrayList<ProxyAction> list = null;
                    for (TypeElement cls : classList) {
                        for (ExecutableElement el : ElementFilter.methodsIn(cls.getEnclosedElements())) {
                            Action ann;
                            if (!el.getModifiers().contains((Object)Modifier.PUBLIC) || (ann = el.getAnnotation(Action.class)) == null) continue;
                            String name = el.getSimpleName().toString();
                            if (ann.name() != null && !"".equals(ann.name())) {
                                name = ann.name();
                            }
                            ProxyAction action = new ProxyAction(cls.getQualifiedName().toString(), name, el.getSimpleName().toString());
                            ActionManager.initActionFromAnnotation(action, el, ann);
                            if (list == null) {
                                list = new ArrayList<ProxyAction>();
                            }
                            list.add(action);
                        }
                    }
                    return list;
                }
            }.execute();
            DesignResourceMap resourceMap = ResourceUtils.getDesignResourceMap(sourceFile, true);
            if (result != null && !result.isEmpty() && resourceMap != null) {
                String className = AppFrameworkSupport.getClassNameForFile(sourceFile);
                classNameToActions.put(className, result);
                for (ProxyAction action : result) {
                    action.setResourceMap(resourceMap);
                    action.loadFromResourceMap();
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        ActionManager.startAutoRescan();
    }

    static List<String> findBooleanProperties(FileObject fo) {
        try {
            return (List)new ClassTask<List<String>>(fo){

                @Override
                List<String> run(CompilationController controller, ClassTree classTree, TypeElement classElement) {
                    ArrayList<String> props = new ArrayList<String>();
                    for (ExecutableElement el : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
                        if (!el.getModifiers().contains((Object)Modifier.PUBLIC) || !TypeKind.BOOLEAN.equals((Object)el.getReturnType().getKind())) continue;
                        String name = el.getSimpleName().toString();
                        if (name.startsWith("is") && name.length() > 2) {
                            props.add(Introspector.decapitalize(name.substring(2)));
                            continue;
                        }
                        if (!name.startsWith("get") || name.length() <= 3) continue;
                        props.add(Introspector.decapitalize(name.substring(3)));
                    }
                    return props;
                }
            }.execute();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return new ArrayList<String>();
        }
    }

    static void initActionFromSource(final ProxyAction action, FileObject sourceFile) {
        try {
            new ActionMethodTask<Object>(sourceFile, action.getMethodName()){

                @Override
                Object run(CompilationController controller, MethodTree methodTree, ExecutableElement methodElement) {
                    Action ann = methodElement.getAnnotation(Action.class);
                    if (ann != null) {
                        ActionManager.initActionFromAnnotation(action, methodElement, ann);
                    }
                    return null;
                }
            }.execute();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    static void initActionFromAnnotation(ProxyAction action, ExecutableElement methodElement, Action annotation) {
        boolean returnsTask = ActionManager.isAsyncActionMethod(methodElement);
        action.setTaskEnabled(returnsTask);
        action.setEnabledName(annotation.enabledProperty());
        action.setSelectedName(annotation.selectedProperty());
        action.setBlockingType(ProxyAction.BlockingType.valueOf(annotation.block().toString()));
    }

    private static boolean isAsyncActionMethod(ExecutableElement methodElement) {
        TypeMirror retType = methodElement.getReturnType();
        return retType.getKind() != TypeKind.VOID;
    }

    private void deleteAction(ProxyAction action, FormModel mod) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        List comps = mod.getComponentList();
        for (RADComponent comp : comps) {
            ProxyAction pact;
            RADProperty prop = comp.getBeanProperty("action");
            if (prop == null || !ActionManager.actionsMatch(pact = (ProxyAction)prop.getValue(), action)) continue;
            prop.setValue(null);
        }
    }

    FileObject getFileForClass(String className) {
        return AppFrameworkSupport.getFileForClass(this.getRoot(), className);
    }

    private FormModel getFormModel(FileObject formfile) throws DataObjectNotFoundException {
        FormDataObject obj = (FormDataObject)FormDataObject.find((FileObject)formfile);
        if (!obj.getFormEditor().isOpened()) {
            obj.getFormEditor().loadForm();
        }
        FormModel mod = obj.getFormEditor().getFormModel();
        return mod;
    }

    private boolean hasFormFile(FileObject file) {
        return file.existsExt("form");
    }

    private FileObject getFormFile(FileObject javaFile) {
        return javaFile.getParent().getFileObject(javaFile.getName() + ".form");
    }

    public static boolean actionsMatch(ProxyAction pact, ProxyAction action) {
        if (pact == null || action == null) {
            return false;
        }
        return pact.getId().equals(action.getId()) && pact.getClassname().equals(action.getClassname());
    }

    private String getKey(ProxyAction act) {
        if (act == null) {
            return "null";
        }
        String s = (act.getId() + ":" + act.getClassname()).intern();
        return s;
    }

    private void fireStructureChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyChangeEvent pce = new PropertyChangeEvent(ActionManager.this, "allActions", null, ActionManager.this.actions);
                for (PropertyChangeListener pcl : ActionManager.this.pcls) {
                    pcl.propertyChange(pce);
                }
            }
        });
    }

    private void fireActionChanged(final ProxyAction act) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionChangedListener acl : ActionManager.this.acls) {
                    acl.actionChanged(act);
                }
            }
        });
    }

    public static void registerFormModel(FormModel formModel, final FileObject sourceFile) {
        if (formModel == null) {
            return;
        }
        if (sourceFile == null) {
            return;
        }
        if (registeredForms.contains(formModel)) {
            return;
        }
        formModel.addFormModelListener(new FormModelListener(){

            public void formChanged(FormModelEvent[] events) {
                if (events != null) {
                    for (FormModelEvent e : events) {
                        if (e.getChangeType() != 3) continue;
                        ActionManager am = ActionManager.getActionManager(sourceFile);
                        if (am != null) {
                            am.removeAllBoundComponents(e.getFormModel());
                        }
                        final 16 ths = this;
                        final FormModel mod = e.getFormModel();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                mod.removeFormModelListener(ths);
                                registeredForms.remove(mod);
                                if (registeredForms.isEmpty()) {
                                    ActionManager.stopAutoRescan();
                                    ams.clear();
                                }
                            }
                        });
                    }
                }
            }
        });
        registeredForms.add(formModel);
    }

    static boolean anyFormOpened() {
        return registeredForms != null && !registeredForms.isEmpty();
    }

    static {
        registeredForms = new HashSet<FormModel>();
    }

    static abstract class ActionMethodTask<T>
    extends ClassTask<T> {
        String methodName;

        ActionMethodTask(FileObject sourceFile, String methodName) {
            super(sourceFile);
            this.methodName = methodName;
        }

        @Override
        T run(CompilationController controller, ClassTree classTree, TypeElement classElement) {
            for (ExecutableElement el : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
                if (!el.getSimpleName().toString().equals(this.methodName) || !el.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                MethodTree mTree = controller.getTrees().getTree(el);
                return this.run(controller, mTree, el);
            }
            return null;
        }

        abstract T run(CompilationController var1, MethodTree var2, ExecutableElement var3);
    }

    static abstract class ClassTask<T>
    implements CancellableTask<CompilationController> {
        FileObject sourceFile;
        private T result;

        ClassTask(FileObject sourceFile) {
            this.sourceFile = sourceFile;
        }

        T execute() throws IOException {
            JavaSource.forFileObject((FileObject)this.sourceFile).runUserActionTask((Task)this, true);
            return this.result;
        }

        abstract T run(CompilationController var1, ClassTree var2, TypeElement var3);

        public void cancel() {
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                ClassTree classT = (ClassTree)tree;
                if (!this.sourceFile.getName().equals(classT.getSimpleName().toString())) continue;
                TreePath classTPath = controller.getTrees().getPath(controller.getCompilationUnit(), classT);
                TypeElement classEl = (TypeElement)controller.getTrees().getElement(classTPath);
                this.result = this.run(controller, classT, classEl);
                return;
            }
        }
    }

    public static interface ActionChangedListener {
        public void actionChanged(ProxyAction var1);
    }
}

