/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class ResourceUtils {
    private static Map<FileObject, DesignResourceMap> resources;
    static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";
    static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    static final String CODE_MARK_END = "*/\n\\0";

    private ResourceUtils() {
    }

    static DesignResourceMap createDesignResourceMap(FileObject srcFile, ClassLoader classLoader) {
        ClassPath cp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        if (classLoader == null) {
            classLoader = cp.getClassLoader(true);
        }
        DesignResourceMap resMap = null;
        String appClassName = AppFrameworkSupport.getApplicationClassName(srcFile);
        String bundleName = ResourceUtils.getBundleName(appClassName);
        if (bundleName != null) {
            resMap = new DesignResourceMap(ResourceUtils.getAppDefaultResourceMap(srcFile, appClassName), classLoader, srcFile, new String[]{bundleName}, 0);
        }
        String srcClassName = cp.getResourceName(srcFile, '.', false);
        bundleName = ResourceUtils.getBundleName(srcClassName);
        resMap = new DesignResourceMap((ResourceMap)resMap, classLoader, srcFile, new String[]{bundleName}, 2);
        if (resources == null) {
            resources = new HashMap<FileObject, DesignResourceMap>();
        }
        resources.put(srcFile, resMap);
        return resMap;
    }

    static DesignResourceMap getDesignResourceMap(FileObject srcFile, boolean createNew) {
        DesignResourceMap resMap;
        DesignResourceMap designResourceMap = resMap = resources != null ? resources.get(srcFile) : null;
        if (resMap == null && createNew) {
            resMap = ResourceUtils.createDesignResourceMap(srcFile, null);
        }
        return resMap;
    }

    private static ResourceMap getAppDefaultResourceMap(FileObject srcFile, String appClassName) {
        FileObject appFO = AppFrameworkSupport.getFileForClass(srcFile, appClassName);
        appClassName = Application.class.getName();
        String[] bundleNames = new String[]{ResourceUtils.getBundleName(appClassName)};
        return new ResourceMap(null, ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute").getClassLoader(true), bundleNames);
    }

    static DesignResourceMap getAppDesignResourceMap(Project project) {
        String appClassName = AppFrameworkSupport.getApplicationClassName(project);
        if (appClassName != null) {
            String bundleName = ResourceUtils.getBundleName(appClassName);
            ClassPath cp = AppFrameworkSupport.getSourcePath(project);
            FileObject fo = cp.findResource(appClassName.replace('.', '/') + ".java");
            return new DesignResourceMap(null, cp.getClassLoader(true), fo, new String[]{bundleName}, 0);
        }
        return null;
    }

    static DesignResourceMap unregisterDesignResourceMap(FileObject srcFile) {
        return resources != null ? resources.remove(srcFile) : null;
    }

    static String getResourceMapCode(FileObject srcFile) {
        return CODE_MARK_VARIABLE_SUBST + AppFrameworkSupport.getApplicationCode(srcFile) + ".getContext().getResourceMap(" + srcFile.getName() + ".class)" + CODE_MARK_VARIABLE_SUBST + ResourceMap.class.getName() + CODE_MARK_VARIABLE_SUBST + "resourceMap";
    }

    private static String getBundleName(String className) {
        if (className == null) {
            return null;
        }
        int i = className.lastIndexOf(46);
        return i > 0 ? className.substring(0, i) + ".resources" + className.substring(i) : "resources." + className;
    }

    private static FileObject getResourceFile(FileObject srcFile, String bundleFileResName, boolean completeClassPath) {
        FileObject resFO;
        ClassPath scp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (scp != null && (resFO = scp.findResource(bundleFileResName)) != null) {
            return resFO;
        }
        if (completeClassPath) {
            ClassPath ecp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
            for (ClassPath.Entry e : ecp.entries()) {
                SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)e.getURL());
                FileObject[] sourceRoots = r.getRoots();
                for (int i = 0; i < sourceRoots.length; ++i) {
                    FileObject resFO2;
                    ClassPath cp = ClassPath.getClassPath((FileObject)sourceRoots[i], (String)"classpath/source");
                    if (cp == null || (resFO2 = cp.findResource(bundleFileResName)) == null) continue;
                    return resFO2;
                }
            }
        }
        return null;
    }

    static PropertiesDataObject getPropertiesDataObject(FileObject srcFile, String bundleName, boolean completeClassPath) {
        FileObject bundleFile;
        if (bundleName == null) {
            return null;
        }
        if (bundleName.startsWith("/")) {
            bundleName = bundleName.substring(1);
        } else if (bundleName.contains(".")) {
            bundleName = bundleName.replace('.', '/');
        }
        if (!bundleName.toLowerCase().endsWith(".properties")) {
            bundleName = bundleName + ".properties";
        }
        if ((bundleFile = ResourceUtils.getResourceFile(srcFile, bundleName, completeClassPath)) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)bundleFile);
                if (dobj instanceof PropertiesDataObject) {
                    return (PropertiesDataObject)dobj;
                }
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return null;
    }

    static PropertiesDataObject getPropertiesDataObject(FileObject srcFile) {
        ClassPath cp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        String srcClassName = cp.getResourceName(srcFile, '.', false);
        String bundleName = ResourceUtils.getBundleName(srcClassName);
        return ResourceUtils.getPropertiesDataObject(srcFile, bundleName, false);
    }

    static BundleStructure getBundleStructure(FileObject srcFile, String bundleName) {
        PropertiesDataObject pdo = ResourceUtils.getPropertiesDataObject(srcFile, bundleName, false);
        return pdo != null ? pdo.getBundleStructure() : null;
    }

    static FileObject createResourcesFolder(FileObject srcFile) throws IOException {
        SourceGroup grp;
        Project owner = FileOwnerQuery.getOwner((FileObject)srcFile);
        if (owner != null && (grp = SourceGroupModifier.createSourceGroup((Project)owner, (String)"resources", (String)"main")) != null) {
            FileObject root = JavadocAndSourceRootDetection.findPackageRoot((FileObject)srcFile);
            String path = FileUtil.getRelativePath((FileObject)root, (FileObject)srcFile.getParent());
            return FileUtil.createFolder((FileObject)grp.getRootFolder(), (String)(path + "/resources"));
        }
        return FileUtil.createFolder((FileObject)srcFile.getParent(), (String)"resources");
    }

    static PropertiesDataObject createPropertiesDataObject(FileObject srcFile, String bundleName) throws IOException {
        SourceGroup grp;
        if (bundleName == null) {
            return null;
        }
        if (bundleName.toLowerCase().endsWith(".properties")) {
            bundleName = bundleName.substring(0, bundleName.length() - ".properties".length());
        }
        if (bundleName.contains(".")) {
            bundleName = bundleName.replace('.', '/');
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)srcFile);
        FileObject folder = null;
        if (owner != null && (grp = SourceGroupModifier.createSourceGroup((Project)owner, (String)"resources", (String)"main")) != null) {
            folder = grp.getRootFolder();
        }
        if (folder == null) {
            folder = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source").getRoots()[0];
        }
        return Util.createPropertiesDataObject(folder, (String)bundleName);
    }

    static String getValueAsString(Object value) {
        if (value == null) {
            return "${null}";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Color) {
            Color c = (Color)value;
            return "" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue();
        }
        if (value instanceof Font) {
            Font f = (Font)value;
            String style = f.isBold() ? (f.isItalic() ? "BoldItalic" : "Bold") : (f.isItalic() ? "Italic" : "Plain");
            return f.getName() + "-" + style + "-" + f.getSize();
        }
        return null;
    }
}

