/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureProjectVisualPanel
extends JPanel
implements DocumentListener,
PropertyChangeListener,
ExplorerManager.Provider {
    private ConfigureProjectPanel wizardPanel;
    private ExplorerManager explorerManager;
    private boolean configuring;
    private String currentLibrariesLocation;
    private String projectLocation;
    private JLabel appNameLabel;
    private JTextField appNameTextField;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private HtmlBrowser descBrowser;
    private JButton libFolderButton;
    private JCheckBox libFolderCheckBox;
    private JLabel libFolderLabel;
    private JTextField libFolderTextField;
    private JLabel libHintLabel;
    private JCheckBox mainProjectCheckBox;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JSeparator separator;
    private ListView shellList;
    private JLabel shellListLabel;

    public ConfigureProjectVisualPanel(ConfigureProjectPanel panel) {
        this.wizardPanel = panel;
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(this.getTemplatesRootNode());
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.shellList.setPopupAllowed(false);
        this.shellList.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.appNameTextField.getDocument().addDocumentListener(this);
        this.libFolderCheckBox.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.libFolderTextField.setText(this.currentLibrariesLocation);
        this.libFolderCheckBoxActionPerformed(null);
    }

    void setConfig(File projectLocation, String projectName, String appName) {
        this.configuring = true;
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.setSelectionStart(0);
        this.projectNameTextField.setSelectionEnd(projectName.length());
        if (appName != null) {
            this.appNameTextField.setText(appName);
        }
        if (this.explorerManager.getSelectedNodes().length == 0) {
            Node[] nodes = this.explorerManager.getRootContext().getChildren().getNodes(true);
            try {
                this.explorerManager.setSelectedNodes(new Node[]{nodes[0]});
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        this.configuring = false;
        this.wizardPanel.visualPanelChanged(false);
    }

    File getProjectDirectory() {
        return new File(this.createdFolderTextField.getText());
    }

    String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    String getApplicationClassName() {
        return this.appNameTextField.getText();
    }

    FileObject getSelectedTemplate() {
        Node[] selected = this.explorerManager.getSelectedNodes();
        if (selected.length == 1) {
            return ConfigureProjectVisualPanel.fileFromNode(selected[0]);
        }
        return null;
    }

    boolean isSetMainProject() {
        return this.mainProjectCheckBox.isSelected();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("selectedNodes")) {
            FileObject template;
            if (!this.configuring) {
                this.wizardPanel.visualPanelChanged(true);
            }
            URL url = (template = this.getSelectedTemplate()) != null ? (URL)template.getAttribute("instantiatingWizardURL") : null;
            this.descBrowser.setURL(url);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void updateTexts(DocumentEvent e) {
        if (e.getDocument() == this.projectNameTextField.getDocument() || e.getDocument() == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
            if (e.getDocument() == this.projectNameTextField.getDocument()) {
                String projClassName = ConfigureProjectVisualPanel.getClassNameFromProject(projectName);
                String packageName = projClassName.toLowerCase();
                String appClassName = !packageName.contains("application") && !projClassName.endsWith("App") ? projClassName + "App" : projClassName;
                if (Character.isLowerCase(appClassName.charAt(0))) {
                    appClassName = appClassName.substring(0, 1).toUpperCase() + appClassName.substring(1);
                }
                this.appNameTextField.setText(packageName + "." + appClassName);
                return;
            }
        }
        if (!this.configuring) {
            this.wizardPanel.visualPanelChanged(false);
        }
    }

    private static String getClassNameFromProject(String projectName) {
        if (!Utilities.isJavaIdentifier((String)projectName)) {
            StringBuilder buf = new StringBuilder(projectName.length());
            for (int i = 0; i < projectName.length(); ++i) {
                char c = projectName.charAt(i);
                if (buf.length() == 0) {
                    if (!Character.isJavaIdentifierStart(c)) continue;
                    buf.append(c);
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) continue;
                buf.append(c);
            }
            return buf.length() > 0 ? buf.toString() : "MyApplication";
        }
        return projectName;
    }

    private Node getTemplatesRootNode() {
        try {
            FileObject shellFolder = FileUtil.getConfigFile((String)"org-netbeans-modules-swingapp/appshells");
            DataObject dobj = DataObject.find((FileObject)shellFolder);
            return new FilterNode(dobj.getNodeDelegate(), (Children)new FilterNode.Children(dobj.getNodeDelegate()){

                protected Node[] createNodes(Node key) {
                    try {
                        String className = (String)ConfigureProjectVisualPanel.fileFromNode(key).getAttribute("requiredClass");
                        if (className != null) {
                            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                            classLoader.loadClass(className);
                        }
                        return new Node[]{this.copyNode(key)};
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                        return new Node[0];
                    }
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return new AbstractNode((Children)new Children.Array());
        }
    }

    private static FileObject fileFromNode(Node n) {
        DataObject dobj = (DataObject)n.getCookie(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    public boolean isShareable() {
        return this.libFolderCheckBox.isSelected();
    }

    public String getLibFolderPath() {
        return this.libFolderTextField.getText();
    }

    private void initComponents() {
        this.separator = new JSeparator();
        this.descBrowser = new HtmlBrowser();
        this.createdFolderLabel = new JLabel();
        this.appNameTextField = new JTextField();
        this.appNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectNameLabel = new JLabel();
        this.mainProjectCheckBox = new JCheckBox();
        this.libHintLabel = new JLabel();
        this.libFolderButton = new JButton();
        this.libFolderTextField = new JTextField();
        this.libFolderLabel = new JLabel();
        this.projectLocationLabel = new JLabel();
        this.libFolderCheckBox = new JCheckBox();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderTextField = new JTextField();
        this.shellListLabel = new JLabel();
        this.shellList = new TemplatesListView();
        this.setName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name"));
        this.descBrowser.setStatusLineVisible(false);
        this.descBrowser.setToolbarVisible(false);
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.createdFolderLabel.text"));
        this.appNameLabel.setLabelFor(this.appNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.appNameLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.appNameLabel.text"));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.projectNameLabel.text"));
        this.mainProjectCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProjectCheckBox, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.text"));
        this.mainProjectCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainProjectCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.libHintLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libHintLabel.text"));
        this.libHintLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.libFolderButton, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderButton.text_1"));
        this.libFolderButton.setEnabled(false);
        this.libFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureProjectVisualPanel.this.libFolderButtonActionPerformed(evt);
            }
        });
        this.libFolderTextField.setText(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderTextField.text"));
        this.libFolderTextField.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.libFolderLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderLabel.text"));
        this.libFolderLabel.setEnabled(false);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.projectLocationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.libFolderCheckBox, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderCheckBox.text"));
        this.libFolderCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.libFolderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureProjectVisualPanel.this.libFolderCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureProjectVisualPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderTextField.setEditable(false);
        this.shellListLabel.setLabelFor((Component)this.shellList);
        Mnemonics.setLocalizedText((JLabel)this.shellListLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.text"));
        this.shellListLabel.setToolTipText(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.toolTipText"));
        this.shellList.setTraversalAllowed(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.shellList, -2, -1, -2).addPreferredGap(0).add((Component)this.descBrowser, -1, 204, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.shellListLabel).add(28, 28, 28)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel).add((Component)this.appNameLabel).add((GroupLayout.Group)layout.createSequentialGroup().add(19, 19, 19).add((Component)this.libFolderLabel))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.appNameTextField, -1, 277, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 277, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 277, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 277, Short.MAX_VALUE).add((Component)this.libFolderTextField, -1, 277, Short.MAX_VALUE).add((Component)this.libHintLabel, -1, 277, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.browseButton).add((Component)this.libFolderButton)))).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.libFolderCheckBox).add((Component)this.mainProjectCheckBox)).add(14, 14, 14)))));
        layout.linkSize(new Component[]{this.browseButton, this.libFolderButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationLabel).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.appNameLabel).add((Component)this.appNameTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.shellListLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.descBrowser, 0, 0, Short.MAX_VALUE).add((Component)this.shellList, -1, 88, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.libFolderCheckBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.libFolderTextField, -2, -1, -2).add((Component)this.libFolderButton).add((Component)this.libFolderLabel)).addPreferredGap(0).add((Component)this.libHintLabel).addPreferredGap(0).add((Component)this.mainProjectCheckBox).addContainerGap()));
        this.descBrowser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.descBrowser.accessibleName"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel3.accessibleDescription"));
        this.appNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel4.accessibleDescription"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel1.accessibleDescription"));
        this.mainProjectCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.accessibleDescription"));
        this.libFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderButton.AccessibleContext.accessibleDescription"));
        this.libFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel2.accessibleDescription"));
        this.libFolderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.libFolderCheckBox.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"TITLE_NewDesktopApp"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.locationChooserTitle"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocationTextField.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
        this.wizardPanel.visualPanelChanged(false);
    }

    private void libFolderCheckBoxActionPerformed(ActionEvent evt) {
        this.libFolderButton.setEnabled(this.libFolderCheckBox.isSelected());
        this.libFolderLabel.setEnabled(this.libFolderCheckBox.isSelected());
        this.libFolderTextField.setEnabled(this.libFolderCheckBox.isSelected());
        this.libHintLabel.setEnabled(this.libFolderCheckBox.isSelected());
        if (this.libFolderCheckBox.isSelected()) {
            this.libFolderTextField.setText(this.currentLibrariesLocation);
        } else {
            this.libFolderTextField.setText("");
        }
    }

    private void libFolderButtonActionPerformed(ActionEvent evt) {
        File f = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.libFolderTextField.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.libFolderCheckBox.isSelected()) {
                this.libFolderTextField.setText(this.currentLibrariesLocation);
            }
        }
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        public TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.setDefaultProcessor(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

