/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class DefaultJavaPlatformProvider
implements JavaPlatformProvider,
FileChangeListener {
    private static final String PLATFORM_STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private static final String DEFAULT_PLATFORM_ATTR = "default-platform";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject storage = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
    private JavaPlatform defaultPlatform;
    private static final Logger LOG = Logger.getLogger(DefaultJavaPlatformProvider.class.getName());

    public DefaultJavaPlatformProvider() {
        if (this.storage != null) {
            this.storage.addFileChangeListener((FileChangeListener)this);
        }
    }

    @Override
    public JavaPlatform[] getInstalledPlatforms() {
        ArrayList<JavaPlatform> platforms = new ArrayList<JavaPlatform>();
        if (this.storage != null) {
            try {
                for (FileObject platformDefinition : this.storage.getChildren()) {
                    DataObject dobj = DataObject.find((FileObject)platformDefinition);
                    InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                    if (ic == null) {
                        LOG.warning("DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " has no InstanceCookie");
                        continue;
                    }
                    if (ic instanceof InstanceCookie.Of) {
                        if (((InstanceCookie.Of)ic).instanceOf(JavaPlatform.class)) {
                            platforms.add((JavaPlatform)ic.instanceCreate());
                            continue;
                        }
                        LOG.warning("DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " is not an instance of JavaPlatform");
                        continue;
                    }
                    Object instance = ic.instanceCreate();
                    if (instance instanceof JavaPlatform) {
                        platforms.add((JavaPlatform)instance);
                        continue;
                    }
                    LOG.warning("DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " is not an instance of JavaPlatform");
                }
            }
            catch (ClassNotFoundException cnf) {
                Exceptions.printStackTrace((Throwable)cnf);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return platforms.toArray(new JavaPlatform[platforms.size()]);
    }

    @Override
    public JavaPlatform getDefaultPlatform() {
        if (this.defaultPlatform == null) {
            this.defaultPlatform = this.getDefaultPlatformByHint();
            if (this.defaultPlatform != null) {
                return this.defaultPlatform;
            }
            JavaPlatform[] allPlatforms = this.getInstalledPlatforms();
            for (int i = 0; i < allPlatforms.length; ++i) {
                if (!this.isDefaultPlatform(allPlatforms[i])) continue;
                this.defaultPlatform = allPlatforms[i];
                break;
            }
        }
        return this.defaultPlatform;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileChanged(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.firePropertyChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void firePropertyChange() {
        this.pcs.firePropertyChange("installedPlatforms", null, null);
    }

    private final boolean isDefaultPlatform(JavaPlatform platform) {
        return "default_platform".equals(platform.getProperties().get("platform.ant.name"));
    }

    private final JavaPlatform getDefaultPlatformByHint() {
        if (this.storage == null) {
            return null;
        }
        for (FileObject defFile : this.storage.getChildren()) {
            if (defFile.getAttribute(DEFAULT_PLATFORM_ATTR) != Boolean.TRUE) continue;
            try {
                Object instance;
                DataObject dobj = DataObject.find((FileObject)defFile);
                InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof JavaPlatform && this.isDefaultPlatform((JavaPlatform)instance)) {
                    return (JavaPlatform)instance;
                }
            }
            catch (IOException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            return null;
        }
        return null;
    }
}

