/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.spi.java.platform.CustomPlatformInstall;
import org.netbeans.spi.java.platform.GeneralPlatformInstall;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class InstallerRegistry {
    static final String INSTALLER_REGISTRY_FOLDER = "org-netbeans-api-java/platform/installers";
    static Reference<InstallerRegistry> defaultInstance = new WeakReference<Object>(null);
    private final Lookup lookup;
    private List<GeneralPlatformInstall> platformInstalls;

    InstallerRegistry(FileObject registryResource) {
        assert (registryResource != null);
        this.lookup = Lookups.forPath((String)INSTALLER_REGISTRY_FOLDER);
    }

    InstallerRegistry(GeneralPlatformInstall[] platformInstalls) {
        assert (platformInstalls != null);
        this.platformInstalls = Arrays.asList(platformInstalls);
        this.lookup = null;
    }

    public List<PlatformInstall> getInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), PlatformInstall.class);
    }

    public List<CustomPlatformInstall> getCustomInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), CustomPlatformInstall.class);
    }

    public List<GeneralPlatformInstall> getAllInstallers() {
        if (this.platformInstalls != null) {
            return this.platformInstalls;
        }
        this.lookup.lookupAll(CustomPlatformInstall.class);
        this.lookup.lookupAll(PlatformInstall.class);
        return Collections.unmodifiableList(new ArrayList(this.lookup.lookupAll(GeneralPlatformInstall.class)));
    }

    public static InstallerRegistry getDefault() {
        InstallerRegistry regs = defaultInstance.get();
        if (regs != null) {
            return regs;
        }
        regs = new InstallerRegistry(FileUtil.getConfigFile((String)INSTALLER_REGISTRY_FOLDER));
        defaultInstance = new WeakReference<InstallerRegistry>(regs);
        return regs;
    }

    static InstallerRegistry prepareForUnitTest(GeneralPlatformInstall[] platformInstalls) {
        InstallerRegistry regs = new InstallerRegistry(platformInstalls);
        defaultInstance = new WeakReference<InstallerRegistry>(regs);
        return regs;
    }

    private static <T> List<T> filter(List<?> list, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (Object item : list) {
            if (!clazz.isInstance(item)) continue;
            result.add(clazz.cast(item));
        }
        return result;
    }
}

