/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class MakeProjectFileOwnerQuery
implements FileOwnerQueryImplementation {
    public Project getOwner(URI uri) {
        return this.getOwner(this.toFileObject(uri));
    }

    private FileObject toFileObject(URI uri) {
        try {
            URL url = uri.toURL();
            return URLMapper.findFileObject((URL)url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Project getOwner(FileObject fo) {
        FileSystem fs;
        if (fo == null) {
            return null;
        }
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        String path = fo.getPath();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            MakeConfigurationDescriptor descriptor;
            if (!fs.equals(RemoteFileUtil.getProjectSourceFileSystem((Project)project))) {
                return null;
            }
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider == null || !provider.gotDescriptor() || (descriptor = provider.getConfigurationDescriptor()) == null || descriptor.findProjectItemByPath(path) == null && descriptor.findExternalItemByPath(path) == null) continue;
            return project;
        }
        return null;
    }
}

