/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;

public class ComboStringConfiguration {
    private ComboStringConfiguration master;
    private String def;
    private String value;
    private boolean modified;
    private boolean dirty = false;
    private DefaultPicklistModel picklist;

    public ComboStringConfiguration(ComboStringConfiguration master, String def, DefaultPicklistModel picklist) {
        this.master = master;
        this.def = def;
        this.picklist = picklist;
        this.reset();
    }

    protected ComboStringConfiguration() {
    }

    public void setMaster(ComboStringConfiguration master) {
        this.master = master;
    }

    public void setValue(String value) {
        this.value = value = value.trim();
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(!value.equals(this.getDefault()));
        }
    }

    public String getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        this.def = def;
        this.setModified(!this.value.equals(this.getDefault()));
    }

    public final void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public DefaultPicklistModel getPicklist() {
        return this.picklist;
    }

    public void assign(ComboStringConfiguration conf) {
        this.dirty = !this.getValue().equals(conf.getValue());
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public ComboStringConfiguration clone() {
        ComboStringConfiguration clone = new ComboStringConfiguration(this.master, this.def, (DefaultPicklistModel)this.picklist.clonePicklist());
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        return clone;
    }

    public String toString() {
        return "(" + this.getValue() + ")";
    }
}

