/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ConfigurationDescriptorProvider {
    public static final String USG_PROJECT_CONFIG_CND = "USG_PROJECT_CONFIG_CND";
    public static final String USG_PROJECT_OPEN_CND = "USG_PROJECT_OPEN_CND";
    public static final String USG_PROJECT_CREATE_CND = "USG_PROJECT_CREATE_CND";
    private static final String USG_CND_PROJECT_ACTION = "USG_CND_PROJECT_ACTION";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final RequestProcessor RP = new RequestProcessor("Configuration Updater", 1);
    private final FileObject projectDirectory;
    private final Project project;
    private volatile MakeConfigurationDescriptor projectDescriptor = null;
    private volatile boolean hasTried = false;
    private String relativeOffset = null;
    private List<FileObject> trackedFiles;
    private volatile boolean needReload;
    private final Object readLock = new Object();

    public ConfigurationDescriptorProvider(FileObject projectDirectory) {
        this(null, projectDirectory);
    }

    public ConfigurationDescriptorProvider(Project project, FileObject projectDirectory) {
        this.project = project;
        this.projectDirectory = projectDirectory;
    }

    public void setRelativeOffset(String relativeOffset) {
        this.relativeOffset = relativeOffset;
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.getConfigurationDescriptor(true);
    }

    private boolean shouldBeLoaded() {
        return (this.projectDescriptor == null || this.needReload) && !this.hasTried;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MakeConfigurationDescriptor getConfigurationDescriptor(boolean waitReading) {
        if (this.shouldBeLoaded()) {
            Object object = this.readLock;
            synchronized (object) {
                if (this.shouldBeLoaded()) {
                    LOGGER.log(Level.FINE, "Start reading project descriptor for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                    this.needReload = false;
                    if (this.trackedFiles == null) {
                        ConfigurationXMLChangeListener fcl = new ConfigurationXMLChangeListener();
                        ArrayList<FileObject> files = new ArrayList<FileObject>(2);
                        boolean first = true;
                        for (String path : new String[]{"nbproject/configurations.xml", "nbproject/private/configurations.xml"}) {
                            FileObject fo = this.projectDirectory.getFileObject(path);
                            if (fo != null) {
                                fo.addFileChangeListener((FileChangeListener)fcl);
                                files.add(fo);
                            } else if (first) {
                                new Exception("Attempt to read project before creation. Not found file " + this.projectDirectory.getPath() + "/" + path).printStackTrace(System.err);
                                return null;
                            }
                            first = false;
                        }
                        this.trackedFiles = files;
                    }
                    ConfigurationXMLReader reader = new ConfigurationXMLReader(this.project, this.projectDirectory);
                    try {
                        MakeConfigurationDescriptor newDescriptor = reader.read(this.relativeOffset);
                        LOGGER.log(Level.FINE, "End of reading project descriptor for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                        if (this.projectDescriptor == null) {
                            if (newDescriptor != null) {
                                this.projectDescriptor = newDescriptor;
                                LOGGER.log(Level.FINE, "Created project descriptor MakeConfigurationDescriptor@{0} for project {1} in ConfigurationDescriptorProvider@{2}", new Object[]{System.identityHashCode(this.projectDescriptor), this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                            } else {
                                LOGGER.log(Level.FINE, "Cannot create project descriptor for project {0} in ConfigurationDescriptorProvider@{1}", new Object[]{this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                            }
                        } else if (newDescriptor != null) {
                            newDescriptor.setProject(this.project);
                            newDescriptor.waitInitTask();
                            Delta delta = this.getDelta(newDescriptor);
                            this.projectDescriptor.assign(newDescriptor);
                            this.projectDescriptor.checkForChangedItems(delta);
                            LOGGER.log(Level.FINE, "Reassigned project descriptor MakeConfigurationDescriptor@{0} for project {1} in ConfigurationDescriptorProvider@{2}", new Object[]{System.identityHashCode(this.projectDescriptor), this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                        } else {
                            LOGGER.log(Level.FINE, "cannot reassign project descriptor MakeConfigurationDescriptor@{0} for project {1} in ConfigurationDescriptorProvider@{2}", new Object[]{System.identityHashCode(this.projectDescriptor), this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                        }
                    }
                    catch (IOException x) {
                        x.printStackTrace(System.err);
                    }
                    this.hasTried = true;
                }
            }
        }
        if (waitReading && this.projectDescriptor != null) {
            this.projectDescriptor.waitInitTask();
        }
        return this.projectDescriptor;
    }

    private Delta getDelta(MakeConfigurationDescriptor newDescriptor) {
        Item[] newItems;
        Item[] oldItems = this.projectDescriptor.getProjectItems();
        HashMap<String, Item> oldMap = new HashMap<String, Item>();
        HashSet<Item> oldSet = new HashSet<Item>();
        for (Item item : oldItems) {
            oldMap.put(item.getAbsolutePath(), item);
            oldSet.add(item);
        }
        Delta delta = new Delta();
        for (Item item : newItems = newDescriptor.getProjectItems()) {
            Item oldItem = (Item)oldMap.get(item.getAbsolutePath());
            if (oldItem == null) {
                delta.added.add(item);
                continue;
            }
            oldSet.remove(oldItem);
            if (item.isExcluded() && oldItem.isExcluded()) {
                delta.replaced.add(item);
                continue;
            }
            if (item.isExcluded() && !oldItem.isExcluded()) {
                delta.exluded.add(item);
                continue;
            }
            if (!item.isExcluded() && oldItem.isExcluded()) {
                delta.included.add(item);
                continue;
            }
            if (!((Object)item.getUserIncludePaths()).equals(oldItem.getUserIncludePaths()) || !((Object)item.getUserMacroDefinitions()).equals(oldItem.getUserMacroDefinitions())) {
                delta.changed.add(item);
                continue;
            }
            delta.replaced.add(item);
        }
        for (Item item : oldSet) {
            delta.deleted.add(item);
        }
        return delta;
    }

    public boolean gotDescriptor() {
        return this.projectDescriptor != null && this.projectDescriptor.getState() != ConfigurationDescriptor.State.READING;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet auxObjectProviders = new HashSet();
        Collection collection = Lookup.getDefault().lookupAll(ConfigurationAuxObjectProvider.class);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            auxObjectProviders.add(iterator.next());
        }
        return auxObjectProviders.toArray(new ConfigurationAuxObjectProvider[auxObjectProviders.size()]);
    }

    public static void recordMetrics(String msg, MakeConfigurationDescriptor descr) {
        ConfigurationDescriptorProvider.recordMetricsImpl(msg, null, descr, null);
    }

    public static void recordCreatedProjectMetrics(MakeConfiguration[] confs) {
        if (confs != null && confs.length > 0) {
            ConfigurationDescriptorProvider.recordMetricsImpl(USG_PROJECT_CREATE_CND, confs[0], null, null);
        }
    }

    public static void recordActionMetrics(String action, MakeConfigurationDescriptor descr) {
        ConfigurationDescriptorProvider.recordMetricsImpl(USG_CND_PROJECT_ACTION, null, descr, action);
    }

    private static void recordMetricsImpl(String msg, MakeConfiguration makeConfiguration, MakeConfigurationDescriptor descr, String action) {
        String family;
        String flavor;
        String[] families;
        CompilerSet compilerSet;
        String host;
        String type;
        if (CndUtils.isUnitTestMode()) {
            return;
        }
        if (descr == null && makeConfiguration == null) {
            return;
        }
        Item[] projectItems = null;
        if (makeConfiguration == null) {
            if (descr.getConfs() == null || descr.getConfs().getActive() == null) {
                return;
            }
            if (makeConfiguration == null) {
                makeConfiguration = descr.getActiveConfiguration();
            }
            projectItems = descr.getProjectItems();
            if (!(USG_PROJECT_CREATE_CND.equals(msg) || projectItems != null && projectItems.length != 0)) {
                return;
            }
        }
        switch (makeConfiguration.getConfigurationType().getValue()) {
            case 0: {
                type = "MAKEFILE";
                break;
            }
            case 1: {
                type = "APPLICATION";
                break;
            }
            case 2: {
                type = "DYNAMIC_LIB";
                break;
            }
            case 3: {
                type = "STATIC_LIB";
                break;
            }
            case 4: {
                type = "QT_APPLICATION";
                break;
            }
            case 5: {
                type = "QT_DYNAMIC_LIB";
                break;
            }
            case 6: {
                type = "QT_STATIC_LIB";
                break;
            }
            default: {
                type = "UNKNOWN";
            }
        }
        if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
            host = "LOCAL";
            compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        } else {
            host = "REMOTE";
            compilerSet = null;
        }
        if (compilerSet != null) {
            families = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
            flavor = compilerSet.getCompilerFlavor().toString();
        } else {
            families = new String[]{};
            if (makeConfiguration.getCompilerSet() != null) {
                families = new String[]{makeConfiguration.getCompilerSet().getName()};
            }
            flavor = makeConfiguration.getCompilerSet().getFlavor();
        }
        if (families.length == 0) {
            family = flavor;
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < families.length; ++i) {
                if (families[i] == null) continue;
                buffer.append(families[i]);
                if (i >= families.length - 1) continue;
                buffer.append(",");
            }
            family = buffer.toString();
        }
        int platformID = makeConfiguration.getDevelopmentHost().getBuildPlatform();
        String platform = Platforms.getPlatform(platformID) != null ? Platforms.getPlatform(platformID).getName() : "UNKNOWN_PLATFORM";
        String ideType = SunStudioUserCounter.getIDEType().getTag();
        if (USG_PROJECT_CREATE_CND.equals(msg)) {
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{type, flavor, family, host, platform, "USER_PROJECT", ideType});
        } else if (USG_CND_PROJECT_ACTION.equals(msg)) {
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{action, type, flavor, family, host, platform, ideType});
        } else if (projectItems != null) {
            makeConfiguration.reCountLanguages(descr);
            int size = 0;
            int allItems = projectItems.length;
            boolean cLang = false;
            boolean ccLang = false;
            boolean fLang = false;
            boolean aLang = false;
            block16: for (Item item : projectItems) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue()) continue;
                ++size;
                switch (itemConfiguration.getTool()) {
                    case CCompiler: {
                        cLang = true;
                        continue block16;
                    }
                    case CCCompiler: {
                        ccLang = true;
                        continue block16;
                    }
                    case FortranCompiler: {
                        fLang = true;
                        continue block16;
                    }
                    case Assembler: {
                        aLang = true;
                    }
                }
            }
            String ccUsage = ccLang ? "USE_CPP" : "NO_CPP";
            String cUsage = cLang ? "USE_C" : "NO_C";
            String fUsage = fLang ? "USE_FORTRAN" : "NO_FORTRAN";
            String aUsage = aLang ? "USE_ASM" : "NO_ASM";
            UIGesturesSupport.submit((String)msg, (Object[])new Object[]{type, flavor, family, host, platform, ConfigurationDescriptorProvider.toSizeString(allItems), ConfigurationDescriptorProvider.toSizeString(size), ccUsage, cUsage, fUsage, aUsage, ideType});
        }
    }

    private static String toSizeString(int size) {
        String strSize = size < 25 ? "25" : (size < 100 ? "100" : (size < 500 ? "500" : (size < 1000 ? "1000" : (size < 2000 ? "2000" : (size < 5000 ? "5000" : (size < 10000 ? "10000" : (size < 20000 ? "20000" : (size < 50000 ? "50000" : "99999"))))))));
        return strSize;
    }

    public static final class Delta {
        public List<Item> included = new ArrayList<Item>();
        public List<Item> added = new ArrayList<Item>();
        public List<Item> exluded = new ArrayList<Item>();
        public List<Item> deleted = new ArrayList<Item>();
        public List<Item> changed = new ArrayList<Item>();
        public List<Item> replaced = new ArrayList<Item>();

        public boolean isEmpty() {
            return this.included.isEmpty() && this.added.isEmpty() && this.exluded.isEmpty() && this.deleted.isEmpty() && this.changed.isEmpty();
        }
    }

    private class ConfigurationXMLChangeListener
    implements FileChangeListener {
        private ConfigurationXMLChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetConfiguration() {
            if (ConfigurationDescriptorProvider.this.projectDescriptor == null || !ConfigurationDescriptorProvider.this.projectDescriptor.isModified()) {
                Object object = ConfigurationDescriptorProvider.this.readLock;
                synchronized (object) {
                    if (ConfigurationDescriptorProvider.this.projectDescriptor == null || !ConfigurationDescriptorProvider.this.projectDescriptor.isModified()) {
                        LOGGER.log(Level.FINE, "Mark to reload project descriptor MakeConfigurationDescriptor@{0} for project {1} in ConfigurationDescriptorProvider@{2}", new Object[]{System.identityHashCode(ConfigurationDescriptorProvider.this.projectDescriptor), ConfigurationDescriptorProvider.this.projectDirectory.getNameExt(), System.identityHashCode(this)});
                        ConfigurationDescriptorProvider.this.needReload = true;
                        ConfigurationDescriptorProvider.this.hasTried = false;
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                ConfigurationDescriptorProvider.this.getConfigurationDescriptor();
                            }
                        });
                    }
                }
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.resetConfiguration();
        }

        public void fileDataCreated(FileEvent fe) {
            this.resetConfiguration();
        }

        public void fileChanged(FileEvent fe) {
            this.resetConfiguration();
        }

        public void fileDeleted(FileEvent fe) {
            this.resetConfiguration();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.resetConfiguration();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

