/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.platform.Platform;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class LibraryItem {
    public static final int PROJECT_ITEM = 0;
    public static final int STD_LIB_ITEM = 1;
    public static final int LIB_ITEM = 2;
    public static final int LIB_FILE_ITEM = 3;
    public static final int OPTION_ITEM = 4;
    private int type;

    protected LibraryItem() {
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getToolTip() {
        return "Should be overridden";
    }

    public String getIconName() {
        return "org/netbeans/modules/cnd/resources/blank.gif";
    }

    public void setValue(String value) {
    }

    public String getPath() {
        return null;
    }

    public String toString() {
        return "Should be overridden";
    }

    public String getOption(MakeConfiguration conf) {
        return "" + this.getOption(conf);
    }

    public boolean canEdit() {
        return false;
    }

    public LibraryItem clone() {
        return this;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(LibraryItem.class, (String)s);
    }

    public static class OptionItem
    extends LibraryItem {
        private String libraryOption;

        public OptionItem(String libraryOption) {
            this.libraryOption = libraryOption;
            this.setType(4);
        }

        public String getLibraryOption() {
            return this.libraryOption;
        }

        public void setLibraryOption(String libraryOption) {
            this.libraryOption = libraryOption;
        }

        @Override
        public String getToolTip() {
            return LibraryItem.getString("LibraryOptionTxt") + " " + this.getLibraryOption() + " (" + this.getOption(null) + ")";
        }

        @Override
        public String getIconName() {
            return "org/netbeans/modules/cnd/makeproject/ui/resources/general.gif";
        }

        @Override
        public String toString() {
            return this.getLibraryOption();
        }

        @Override
        public void setValue(String value) {
            this.setLibraryOption(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            return this.getLibraryOption();
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public OptionItem clone() {
            return new OptionItem(this.getLibraryOption());
        }
    }

    public static class LibFileItem
    extends LibraryItem {
        private String path;

        public LibFileItem(String path) {
            this.path = path;
            this.setType(3);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public String getToolTip() {
            return LibraryItem.getString("LibraryFileTxt") + " " + this.getPath() + " (" + this.getOption(null) + ")";
        }

        @Override
        public String getIconName() {
            if (this.getPath().endsWith(".so") || this.getPath().endsWith(".dll") || this.getPath().endsWith(".dylib")) {
                return "org/netbeans/modules/cnd/loaders/DllIcon.gif";
            }
            if (this.getPath().endsWith(".a")) {
                return "org/netbeans/modules/cnd/loaders/static_library.gif";
            }
            return "org/netbeans/modules/cnd/loaders/unknown.gif";
        }

        @Override
        public String toString() {
            return this.getPath();
        }

        @Override
        public void setValue(String value) {
            this.setPath(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            String lpath = this.getPath();
            if (conf != null) {
                CompilerSet cs = conf.getCompilerSet().getCompilerSet();
                lpath = CppUtils.normalizeDriveLetter(cs, lpath);
            }
            return lpath;
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public LibFileItem clone() {
            return new LibFileItem(this.getPath());
        }
    }

    public static class LibItem
    extends LibraryItem {
        private String libName;

        public LibItem(String libName) {
            this.libName = libName;
            this.setType(2);
        }

        public String getLibName() {
            return this.libName;
        }

        public void setLibName(String libName) {
            this.libName = libName;
        }

        @Override
        public String getToolTip() {
            return LibraryItem.getString("LibraryTxt") + "  " + this.getLibName() + " (" + this.getOption(null) + ")";
        }

        @Override
        public String getIconName() {
            return "org/netbeans/modules/cnd/loaders/LibraryIcon.gif";
        }

        @Override
        public String toString() {
            return this.getLibName();
        }

        @Override
        public void setValue(String value) {
            this.setLibName(value);
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            return "-l" + this.getLibName();
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public LibItem clone() {
            return new LibItem(this.getLibName());
        }
    }

    public static class StdLibItem
    extends LibraryItem {
        private final String name;
        private final String displayName;
        private final String[] libs;

        public StdLibItem(String name, String displayName, String[] libs) {
            this.name = name;
            this.displayName = displayName;
            this.libs = libs;
            this.setType(1);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String[] getLibs() {
            return this.libs;
        }

        @Override
        public String getToolTip() {
            return LibraryItem.getString("StandardLibraryTxt") + " " + this.getDisplayName() + " (" + this.getOption(null) + ")";
        }

        @Override
        public String getIconName() {
            return "org/netbeans/modules/cnd/resources/stdLibrary.gif";
        }

        @Override
        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            StringBuilder options = new StringBuilder();
            for (int i = 0; i < this.libs.length; ++i) {
                if (this.libs[i].charAt(0) != '-') {
                    options.append("-l").append(this.libs[i]).append(" ");
                    continue;
                }
                options.append(this.libs[i]).append(" ");
            }
            return options.toString();
        }

        @Override
        public boolean canEdit() {
            return false;
        }

        @Override
        public StdLibItem clone() {
            StdLibItem clone = new StdLibItem(this.getName(), this.getDisplayName(), this.getLibs());
            return clone;
        }
    }

    public static class ProjectItem
    extends LibraryItem {
        private MakeArtifact makeArtifact;
        private Project project;

        public ProjectItem(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
            this.setType(0);
        }

        public MakeArtifact getMakeArtifact() {
            return this.makeArtifact;
        }

        public void setMakeArtifact(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
        }

        public Project getProject(String baseDir) {
            if (this.project == null) {
                String location = CndPathUtilitities.toAbsolutePath((String)baseDir, (String)this.getMakeArtifact().getProjectLocation());
                try {
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.getCanonicalPath((CharSequence)location));
                    this.project = ProjectManager.getDefault().findProject(fo);
                }
                catch (Exception e) {
                    System.err.println("Cannot find subproject in '" + location + "' " + e);
                }
            }
            return this.project;
        }

        @Override
        public String getToolTip() {
            String ret = LibraryItem.getString("ProjectTxt") + " " + this.getMakeArtifact().getProjectLocation();
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                ret = ret + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return ret;
        }

        @Override
        public String getIconName() {
            return "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif";
        }

        @Override
        public String toString() {
            String ret = CndPathUtilitities.getBaseName((String)this.getMakeArtifact().getProjectLocation());
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                ret = ret + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return ret;
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public String getPath() {
            String libPath = this.getMakeArtifact().getOutput();
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)libPath)) {
                libPath = this.getMakeArtifact().getProjectLocation() + '/' + libPath;
            }
            return libPath;
        }

        @Override
        public String getOption(MakeConfiguration conf) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            Platform platform = Platforms.getPlatform(conf.getDevelopmentHost().getBuildPlatform());
            String libPath = this.getPath();
            String libDir = CndPathUtilitities.getDirName((String)libPath);
            String libName = CndPathUtilitities.getBaseName((String)libPath);
            return platform.getLibraryLinkOption(libName, libDir, libPath, compilerSet);
        }

        @Override
        public boolean canEdit() {
            return false;
        }

        @Override
        public ProjectItem clone() {
            ProjectItem clone = new ProjectItem(this.getMakeArtifact());
            return clone;
        }
    }
}

