/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakefileConfiguration {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration buildCommandWorkingDir;
    private StringConfiguration buildCommand;
    private StringConfiguration cleanCommand;
    private StringConfiguration output;
    private static ResourceBundle bundle;

    public MakefileConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildCommandWorkingDir = new StringConfiguration(null, ".");
        this.buildCommand = new StringConfiguration(null, "${MAKE}");
        this.cleanCommand = new StringConfiguration(null, "${MAKE} clean");
        this.output = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getBuildCommandWorkingDir() {
        return this.buildCommandWorkingDir;
    }

    public String getBuildCommandWorkingDirValue() {
        if (this.buildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.buildCommandWorkingDir.getValue();
    }

    public void setBuildCommandWorkingDir(StringConfiguration buildCommandWorkingDir) {
        this.buildCommandWorkingDir = buildCommandWorkingDir;
    }

    public StringConfiguration getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(StringConfiguration buildCommand) {
        this.buildCommand = buildCommand;
    }

    public StringConfiguration getCleanCommand() {
        return this.cleanCommand;
    }

    public void setCleanCommand(StringConfiguration cleanCommand) {
        this.cleanCommand = cleanCommand;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public boolean canBuild() {
        return this.getBuildCommand().getValue().length() > 0;
    }

    public String getAbsBuildCommandWorkingDir() {
        if (this.getBuildCommandWorkingDirValue().length() > 0 && CndPathUtilitities.isPathAbsolute((CharSequence)this.getBuildCommandWorkingDirValue())) {
            return this.getBuildCommandWorkingDirValue();
        }
        String wd = this.getMakeConfiguration().getBaseDir() + "/" + this.getBuildCommandWorkingDirValue();
        wd = CndFileUtils.normalizeAbsolutePath((String)wd);
        return wd;
    }

    public boolean canClean() {
        return this.getCleanCommand().getValue().length() > 0;
    }

    public String getAbsOutput() {
        if (this.getOutput().getValue().length() == 0) {
            return "";
        }
        if (CndPathUtilitities.isPathAbsolute((CharSequence)this.getOutput().getValue())) {
            return this.getOutput().getValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getOutput().getValue();
    }

    public void assign(MakefileConfiguration conf) {
        this.getBuildCommandWorkingDir().assign(conf.getBuildCommandWorkingDir());
        this.getBuildCommand().assign(conf.getBuildCommand());
        this.getCleanCommand().assign(conf.getCleanCommand());
        this.getOutput().assign(conf.getOutput());
    }

    public MakefileConfiguration clone() {
        MakefileConfiguration clone = new MakefileConfiguration(this.getMakeConfiguration());
        clone.setBuildCommandWorkingDir(this.getBuildCommandWorkingDir().clone());
        clone.setBuildCommand(this.getBuildCommand().clone());
        clone.setCleanCommand(this.getCleanCommand().clone());
        clone.setOutput(this.getOutput().clone());
        return clone;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Makefile");
        set.setDisplayName(MakefileConfiguration.getString("MakefileTxt"));
        set.setShortDescription(MakefileConfiguration.getString("MakefileHint"));
        set.put((Node.Property)new DirStringNodeProp(this.getBuildCommandWorkingDir(), "WorkingDirectory", MakefileConfiguration.getString("WorkingDirectory_LBL"), MakefileConfiguration.getString("WorkingDirectory_TT")));
        set.put((Node.Property)new StringNodeProp(this.getBuildCommand(), "BuildCommandLine", MakefileConfiguration.getString("BuildCommandLine_LBL"), MakefileConfiguration.getString("BuildCommandLine_TT")));
        set.put((Node.Property)new StringNodeProp(this.getCleanCommand(), "CleanCommandLine", MakefileConfiguration.getString("CleanCommandLine_LBL"), MakefileConfiguration.getString("CleanCommandLine_TT")));
        set.put((Node.Property)new OutputStringNodeProp(this.getOutput(), "BuildResult", MakefileConfiguration.getString("BuildResult_LBL"), MakefileConfiguration.getString("BuildResult_TT")));
        sheet.put(set);
        return sheet;
    }

    private ExecutionEnvironment getExecutionEnvironment() {
        DevelopmentHostConfiguration dhc;
        ExecutionEnvironment env = null;
        MakeConfiguration mc = this.getMakeConfiguration();
        if (mc != null && mc.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES && (dhc = mc.getDevelopmentHost()) != null) {
            env = dhc.getExecutionEnvironment();
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private JFileChooser createDirPanel(String seed, final PropertyEditorSupport editor, PropertyEnv propenv) {
        String titleText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("Run_Directory");
        String buttonText = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("SelectLabel");
        final JFileChooser chooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)this.getExecutionEnvironment(), (String)titleText, (String)buttonText, (int)1, null, (String)seed, (boolean)true);
        chooser.putClientProperty("title", chooser.getDialogTitle());
        chooser.setControlButtonsAreShown(false);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    File selectedFile = chooser.getSelectedFile();
                    String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilitities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            }
        });
        return chooser;
    }

    private void setElfFilters(final ExecutionEnvironment execEnv, final JFileChooser chooser) {
        final ArrayList filters = new ArrayList();
        Runnable setFiltersRunner = new Runnable(){

            @Override
            public void run() {
                for (FileFilter f : filters) {
                    chooser.addChoosableFileFilter(f);
                }
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            }
        };
        Runnable determineFiltersRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
                    chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getAllBinaryFileFilter());
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getPeExecutableFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getPeStaticLibraryFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getPeDynamicLibraryFileFilter());
                    } else if (hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX) {
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getMacOSXExecutableFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getMacOSXDynamicLibraryFileFilter());
                    } else {
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfExecutableFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        chooser.addChoosableFileFilter((FileFilter)FileFilterFactory.getElfDynamicLibraryFileFilter());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
        };
        RequestProcessor.getDefault().post(determineFiltersRunner);
    }

    private JFileChooser createElfPanel(String seed, final PropertyEditorSupport editor, PropertyEnv propenv) {
        ExecutionEnvironment execEnv = this.getExecutionEnvironment();
        final JFileChooser chooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)"", (String)"", (int)0, null, (String)seed, (boolean)true);
        chooser.setControlButtonsAreShown(false);
        chooser.putClientProperty("title", chooser.getDialogTitle());
        this.setElfFilters(execEnv, chooser);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File selectedFile = chooser.getSelectedFile();
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && selectedFile != null) {
                    String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilitities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            }
        });
        return chooser;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakefileConfiguration.class);
        }
        return bundle.getString(s);
    }

    private final class ElfEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public ElfEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getOutput().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getOutput().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return MakefileConfiguration.this.createElfPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public DirEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return MakefileConfiguration.this.createDirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class OutputStringNodeProp
    extends StringNodeProp {
        public OutputStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilitities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            String seed = MakefileConfiguration.this.getAbsOutput();
            if (seed.length() == 0) {
                seed = MakefileConfiguration.this.getMakeConfiguration().getBaseDir();
            }
            return new ElfEditor(seed);
        }
    }

    private class DirStringNodeProp
    extends StringNodeProp {
        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilitities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(MakefileConfiguration.this.getAbsBuildCommandWorkingDir());
        }
    }
}

