/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.IsChangedListener;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.ui.options.CodeAssistancePanelController;
import org.netbeans.modules.cnd.makeproject.ui.options.PredefinedPanel;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ParserSettingsPanel
extends JPanel
implements ChangeListener,
ActionListener,
IsChangedListener {
    private Map<Tool, PredefinedPanel> predefinedPanels = new WeakHashMap<Tool, PredefinedPanel>();
    private boolean updating = false;
    private boolean modified = false;
    private JPanel collectionPanel;
    private JComboBox compilerCollectionComboBox;
    private JLabel compilerCollectionLabel;
    private JScrollPane scrollPane;
    private JPanel tabPanel;
    private JTabbedPane tabbedPane;

    public ParserSettingsPanel() {
        this.setName("TAB_CodeAssistanceTab");
        this.initComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("MANAGE_COMPILERS_SETTINGS_AD"));
        this.compilerCollectionComboBox.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("COMPILER_COLLECTION_AD"));
        this.compilerCollectionComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                return label;
            }
        });
        ToolsPanelSupport.addCompilerSetChangeListener((ChangeListener)this);
        ToolsPanelSupport.addIsChangedListener((IsChangedListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.updating && this.isShowing()) {
            this.updateTabs();
        }
    }

    private CompilerSetManager getCompilerSetManager(ExecutionEnvironment execEnv) {
        ToolsCacheManager manager = ToolsPanelSupport.getToolsCacheManager();
        CompilerSetManager copy = manager.getCompilerSetManagerCopy(execEnv, true);
        while (copy.isPending()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        return copy;
    }

    private void updateCompilerCollections(final CompilerSet csToSelect) {
        final AtomicReference toSelect = new AtomicReference();
        final ArrayList allCS = new ArrayList();
        final Collection servers = ServerList.getRecords();
        final Runnable uiUpdater = new Runnable(){

            @Override
            public void run() {
                ParserSettingsPanel.this.compilerCollectionComboBox.removeActionListener(ParserSettingsPanel.this);
                ParserSettingsPanel.this.compilerCollectionComboBox.removeAllItems();
                for (CompilerSetPresenter cs : allCS) {
                    ParserSettingsPanel.this.compilerCollectionComboBox.addItem(cs);
                }
                if (toSelect.get() == null) {
                    if (ParserSettingsPanel.this.compilerCollectionComboBox.getItemCount() > 0) {
                        ParserSettingsPanel.this.compilerCollectionComboBox.setSelectedIndex(0);
                    }
                } else {
                    ParserSettingsPanel.this.compilerCollectionComboBox.setSelectedItem(toSelect.get());
                }
                ParserSettingsPanel.this.updateTabs();
                ParserSettingsPanel.this.compilerCollectionComboBox.addActionListener(ParserSettingsPanel.this);
            }
        };
        NamedRunnable worker = new NamedRunnable("ParserSettings worker"){

            protected void runImpl() {
                if (servers.size() > 1) {
                    for (ServerRecord record : servers) {
                        for (CompilerSet cs : ParserSettingsPanel.this.getCompilerSetManager(record.getExecutionEnvironment()).getCompilerSets()) {
                            CompilerSetPresenter csp = new CompilerSetPresenter(cs, record.getDisplayName() + " : " + cs.getName());
                            if (csToSelect == cs) {
                                toSelect.set(csp);
                            }
                            allCS.add(csp);
                        }
                    }
                } else {
                    assert (servers.iterator().hasNext());
                    assert (!((ServerRecord)servers.iterator().next()).isRemote());
                }
                if (allCS.isEmpty()) {
                    for (CompilerSet cs : ParserSettingsPanel.this.getCompilerSetManager(ExecutionEnvironmentFactory.getLocal()).getCompilerSets()) {
                        for (Tool tool : cs.getTools()) {
                            tool.waitReady(false);
                        }
                        CompilerSetPresenter csp = new CompilerSetPresenter(cs, cs.getName());
                        if (csToSelect == cs) {
                            toSelect.set(csp);
                        }
                        allCS.add(csp);
                    }
                }
                SwingUtilities.invokeLater(uiUpdater);
            }
        };
        RequestProcessor.getDefault().post((Runnable)worker);
    }

    private synchronized void updateTabs() {
        Tool cppCompiler;
        this.tabbedPane.removeAll();
        CompilerSetPresenter csp = (CompilerSetPresenter)this.compilerCollectionComboBox.getSelectedItem();
        if (csp == null || csp.cs == null) {
            return;
        }
        CompilerSet compilerCollection = csp.cs;
        if (compilerCollection.isUrlPointer()) {
            return;
        }
        ArrayList<Tool> toolSet = new ArrayList<Tool>();
        Tool cCompiler = compilerCollection.getTool((ToolKind)PredefinedToolKind.CCompiler);
        if (cCompiler != null && cCompiler.getPath().length() > 0) {
            toolSet.add(cCompiler);
        }
        if ((cppCompiler = compilerCollection.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null && cppCompiler.getPath().length() > 0) {
            toolSet.add(cppCompiler);
        }
        for (Tool tool : toolSet) {
            PredefinedPanel predefinedPanel = this.predefinedPanels.get(tool);
            if (predefinedPanel == null) {
                predefinedPanel = new PredefinedPanel((AbstractCompiler)tool, this);
                this.predefinedPanels.put(tool, predefinedPanel);
            } else {
                predefinedPanel.updateCompiler((AbstractCompiler)tool);
            }
            this.tabbedPane.addTab(tool.getDisplayName(), predefinedPanel);
        }
    }

    void setModified(boolean val) {
        this.modified = val;
    }

    private void fireFilesPropertiesChanged() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("fireFilesPropertiesChanged for ParserSettingsPanel");
        }
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            NativeProjectProvider npv = (NativeProjectProvider)openProjects[i].getLookup().lookup(NativeProjectProvider.class);
            if (npv == null) continue;
            npv.fireFilesPropertiesChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        Object o = ev.getSource();
        if (o instanceof CompilerSet) {
            this.updateCompilerCollections((CompilerSet)o);
        } else {
            this.updateCompilerCollections(null);
        }
    }

    private void initComponents() {
        this.collectionPanel = new JPanel();
        this.compilerCollectionLabel = new JLabel();
        this.compilerCollectionComboBox = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.tabPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.collectionPanel.setOpaque(false);
        this.compilerCollectionLabel.setLabelFor(this.compilerCollectionComboBox);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.compilerCollectionLabel, (String)bundle.getString("COMPILER_COLLECTION_LBL"));
        GroupLayout collectionPanelLayout = new GroupLayout(this.collectionPanel);
        this.collectionPanel.setLayout(collectionPanelLayout);
        collectionPanelLayout.setHorizontalGroup(collectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(collectionPanelLayout.createSequentialGroup().addComponent(this.compilerCollectionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compilerCollectionComboBox, 0, 327, Short.MAX_VALUE).addContainerGap()));
        collectionPanelLayout.setVerticalGroup(collectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(collectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compilerCollectionLabel).addComponent(this.compilerCollectionComboBox, -2, -1, -2)));
        this.scrollPane.setOpaque(false);
        this.tabPanel.setOpaque(false);
        GroupLayout tabPanelLayout = new GroupLayout(this.tabPanel);
        this.tabPanel.setLayout(tabPanelLayout);
        tabPanelLayout.setHorizontalGroup(tabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 428, Short.MAX_VALUE));
        tabPanelLayout.setVerticalGroup(tabPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 362, Short.MAX_VALUE));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AN"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AD"));
        this.scrollPane.setViewportView(this.tabPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.collectionPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane, -1, 446, Short.MAX_VALUE).addGap(0, 0, 0))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.collectionPanel, -2, -1, -2).addContainerGap(277, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.scrollPane, -1, 266, Short.MAX_VALUE).addGap(0, 0, 0))));
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ParserSettingsPanel.class, (String)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for ParserSettingsPanel");
        }
        try {
            this.updating = true;
            this.updateCompilerCollections(ToolsPanelSupport.getCurrentCompilerSet());
            PredefinedPanel[] viewedPanels = this.getPredefinedPanels();
            for (int i = 0; i < viewedPanels.length; ++i) {
                viewedPanels[i].update();
            }
        }
        finally {
            this.updating = false;
        }
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for ParserSettingsPanel");
        }
        PredefinedPanel[] viewedPanels = this.getPredefinedPanels();
        for (int i = 0; i < viewedPanels.length; ++i) {
            viewedPanels[i].cancel();
        }
        ToolsPanelSupport.getToolsCacheManager().discardChanges();
    }

    boolean isDataValid() {
        boolean isDataValid = true;
        PredefinedPanel[] viewedPanels = this.getPredefinedPanels();
        for (int i = 0; i < viewedPanels.length; ++i) {
            isDataValid &= viewedPanels[i].isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for ParserSettingsPanel is " + isDataValid);
        }
        return isDataValid;
    }

    public boolean isChanged() {
        boolean isChanged = false;
        PredefinedPanel[] viewedPanels = this.getPredefinedPanels();
        for (int i = 0; i < viewedPanels.length; ++i) {
            isChanged |= viewedPanels[i].isChanged();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for ParserSettingsPanel is " + isChanged);
        }
        return isChanged;
    }

    public Runnable saveChanges() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("save for ParserSettingsPanel");
        }
        PredefinedPanel[] viewedPanels = this.getPredefinedPanels();
        boolean wasChanges = false;
        Runnable res = null;
        for (int i = 0; i < viewedPanels.length; ++i) {
            wasChanges |= viewedPanels[i].save();
        }
        if (wasChanges || this.modified) {
            if (CodeAssistancePanelController.TRACE_CODEASSIST) {
                System.err.println("fireFilesPropertiesChanged in save for ParserSettingsPanel");
            }
            res = new Runnable(){

                @Override
                public void run() {
                    ParserSettingsPanel.this.fireFilesPropertiesChanged();
                }
            };
            this.modified = false;
        } else if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("not need to fireFilesPropertiesChanged in save for ParserSettingsPanel");
        }
        return res;
    }

    private PredefinedPanel[] getPredefinedPanels() {
        return this.predefinedPanels.values().toArray(new PredefinedPanel[this.predefinedPanels.size()]);
    }

    private static class CompilerSetPresenter {
        private CompilerSet cs;
        private String displayName;

        public CompilerSetPresenter(CompilerSet cs, String displayName) {
            this.cs = cs;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

