/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.j2ee.persistence.dd.common.JPAParseUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;

public final class PersistenceMetadata {
    private static final PersistenceMetadata DEFAULT = new PersistenceMetadata();
    private Map ddMap = new WeakHashMap(5);

    private PersistenceMetadata() {
    }

    public static PersistenceMetadata getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistence getRoot(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        Persistence persistence = null;
        Map map = this.ddMap;
        synchronized (map) {
            persistence = (Persistence)this.ddMap.get(fo);
            if (persistence == null) {
                InputStream is = fo.getInputStream();
                String version = "1.0";
                try {
                    version = JPAParseUtils.getVersion(is);
                }
                catch (SAXException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                is = fo.getInputStream();
                persistence = "2.0".equals(version) ? org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.Persistence.createGraph(is) : org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence.createGraph(is);
                is.close();
                this.ddMap.put(fo, persistence);
            }
        }
        return persistence;
    }

    public void refresh(FileObject fo) {
        if (fo != null) {
            this.ddMap.remove(fo);
        }
    }
}

