/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.ExecutionResults;
import org.netbeans.installer.utils.helper.FileEntry;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final Pack200.Unpacker unpacker = Pack200.newUnpacker();
    public static final int BUFFER_SIZE = 65536;
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String METAINF_MASK = "META-INF.*";
    public static final String JAR_EXTENSION = ".jar";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String PACK_GZ_SUFFIX = ".pack.gz";
    public static final String SUN_MICR_RSA = "META-INF/SUN_MICR.RSA";
    public static final String SUN_MICR_SF = "META-INF/SUN_MICR.SF";
    public static final String FILES_LIST_ENTRY = "META-INF/files.list";
    public static final String CURRENT = ".";
    public static final String PARENT = "..";
    public static final String SHA1_DIGEST_NAME = "SHA1";
    public static final String MD5_DIGEST_NAME = "MD5";
    public static final String INFO_PLIST_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">\n<plist version=\"0.9\">\n  <dict>\n    \n    <key>CFBundleName</key>\n    <string>{0}</string>\n    \n    <key>CFBundleVersion</key>\n    <string>{1}</string>\n    \n    <key>CFBundleExecutable</key>\n    <string>{3}</string>\n    \n    <key>CFBundlePackageType</key>\n    <string>APPL</string>\n    \n    <key>CFBundleShortVersionString</key>\n    <string>{2}</string>\n    \n    <key>CFBundleSignature</key>\n    <string>????</string>\n    \n    <key>CFBundleInfoDictionaryVersion</key>\n    <string>6.0</string>\n    \n    <key>CFBundleIconFile</key>\n    <string>{4}</string>\n  </dict>\n</plist>\n";
    public static final String ERROR_OUTPUT_FILE_ENTRY_KEY = "FU.error.output.file.entry";
    public static final String ERROR_OUTPUT_DIR_ENTRY_KEY = "FU.error.output.dir.entry";
    public static final String MESSAGE_MOVING = ResourceUtils.getString(FileUtils.class, "FU.message.moving");
    public static final String MESSAGE_EXTRACTING = ResourceUtils.getString(FileUtils.class, "FU.message.extracting");
    public static final String ERROR_LOAD_XML_FILE_LIST_KEY = "FU.error.load.xml.file.list";
    public static final String ERROR_UNJAR_TODIR_KEY = "FU.error.unjar.todir";
    public static final String MESSAGE_COPY_DIRECTORY = ResourceUtils.getString(FileUtils.class, "FU.message.copy.dir");
    public static final String MESSAGE_COPY_FILE = ResourceUtils.getString(FileUtils.class, "FU.message.copy.file");
    public static final String ERROR_CLOSE_STREAM_KEY = "FU.error.close.stream";
    public static final String ERROR_SOURCE_NOT_READABLE_KEY = "FU.error.source.not.readable";
    public static final String ERROR_DEST_NOT_FILE_KEY = "FU.error.dest.not.file";
    public static final String ERROR_DEST_CREATION_KEY = "FU.error.dest.creation";
    public static final String ERROR_DEST_NOT_WRITABLE_KEY = "FU.error.dest.not.writable";
    public static final String ERROR_CANT_GET_FREE_SPACE_KEY = "FU.error.freespace";
    public static final String ERROR_CANT_CLOSE_JAR_KEY = "FU.error.cannot.close.jar";
    public static final String ERROR_CANT_CREATE_DIR_EXIST_FILE_KEY = "FU.error.cannot.create.dir.exist.file";
    public static final String ERROR_CANT_CREATE_DIR_KEY = "FU.error.cannot.create.dir";
    public static final String ERROR_NOT_JAR_FILE_KEY = "FU.error.not.jar.file";
    public static final String ERROR_SHA1_NOT_SUPPORTED_KEY = "FU.error.sha1.not.supported";
    public static final String ERROR_MD5_NOT_SUPPORTED_KEY = "FU.error.md5.not.supported";
    public static final String ERROR_FILE_SECURITY_EXCEPTION_KEY = "FU.error.file.security.exception";
    public static final String MESSAGE_DELETE_FILE = ResourceUtils.getString(FileUtils.class, "FU.message.delete.file");
    public static final String MESSAGE_DELETE_DIR = ResourceUtils.getString(FileUtils.class, "FU.message.delete.dir");
    public static final String ERROR_PACK200_FAILED_KEY = "FU.error.pack200.failed";
    public static final String ERROR_UNPACK200_FAILED_KEY = "FU.error.unpack200.failed";
    public static final String USE_INTERNAL_UNPACK200_PROPERTY = "nbi.use.internal.unpack200";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
        BufferedReader reader = new BufferedReader(isr);
        try {
            int readLength;
            char[] buffer = new char[65536];
            StringBuilder stringBuilder = new StringBuilder();
            while ((readLength = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, readLength);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            try {
                ((Reader)reader).close();
                isr.close();
                fis.close();
            }
            catch (IOException ignord) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            int readLength;
            char[] buffer = new char[65536];
            StringBuilder stringBuilder = new StringBuilder();
            while ((readLength = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, readLength);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static FilesList writeFile(File file, CharSequence string) throws IOException {
        return FileUtils.writeFile(file, string, Charset.defaultCharset().name(), false);
    }

    public static FilesList writeFile(File file, CharSequence string, String charset) throws IOException {
        return FileUtils.writeFile(file, string, charset, false);
    }

    public static FilesList appendFile(File file, CharSequence string) throws IOException {
        return FileUtils.writeFile(file, string, Charset.defaultCharset().name(), true);
    }

    public static FilesList appendFile(File file, CharSequence string, String charset) throws IOException {
        return FileUtils.writeFile(file, string, charset, true);
    }

    public static FilesList writeFile(File file, CharSequence string, boolean append) throws IOException {
        return FileUtils.writeFile(file, string, Charset.defaultCharset().name(), append);
    }

    public static FilesList writeFile(File file, CharSequence string, String charset, boolean append) throws IOException {
        return FileUtils.writeFile(file, new ByteArrayInputStream(((Object)string).toString().getBytes(charset)), append);
    }

    public static FilesList writeFile(File file, InputStream input) throws IOException {
        return FileUtils.writeFile(file, input, false);
    }

    public static FilesList appendFile(File file, InputStream input) throws IOException {
        return FileUtils.writeFile(file, input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilesList writeFile(File file, InputStream input, boolean append) throws IOException {
        FilesList list = new FilesList();
        if (!FileUtils.exists(file)) {
            if (!FileUtils.exists(file.getParentFile())) {
                list.add(FileUtils.mkdirs(file.getParentFile()));
            }
            file.createNewFile();
            list.add(file);
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file, append);
            StreamUtils.transferData(input, (OutputStream)output);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CLOSE_STREAM_KEY), e);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> readStringList(File file, String charset) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        for (String line : StringUtils.splitByLines(FileUtils.readFile(file, charset))) {
            list.add(line);
        }
        return list;
    }

    public static List<String> readStringList(File file) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        for (String line : StringUtils.splitByLines(FileUtils.readFile(file))) {
            list.add(line);
        }
        return list;
    }

    public static FilesList writeStringList(File file, List<String> list) throws IOException {
        return FileUtils.writeStringList(file, list, Charset.defaultCharset().name(), false);
    }

    public static FilesList writeStringList(File file, List<String> list, String charset) throws IOException {
        return FileUtils.writeStringList(file, list, charset, false);
    }

    public static FilesList writeStringList(File file, List<String> list, boolean append) throws IOException {
        return FileUtils.writeStringList(file, list, Charset.defaultCharset().name(), append);
    }

    public static FilesList writeStringList(File file, List<String> list, String charset, boolean append) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            builder.append(list.get(i));
            if (i == list.size() - 1) continue;
            builder.append(SystemUtils.getLineSeparator());
        }
        return FileUtils.writeFile(file, builder, charset, append);
    }

    public static Date getLastModified(File file) {
        if (!FileUtils.exists(file)) {
            return null;
        }
        Date date = null;
        try {
            long modif = file.lastModified();
            date = new Date(modif);
        }
        catch (SecurityException ex) {
            Object var2_4 = null;
        }
        return date;
    }

    public static long getSize(File file) {
        long size = 0L;
        if (file != null && FileUtils.exists(file)) {
            try {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files != null) {
                        for (File f : files) {
                            size += FileUtils.getSize(f);
                        }
                    }
                } else {
                    size = file.length();
                }
            }
            catch (SecurityException e) {
                ErrorManager.notifyError(ResourceUtils.getString(FileUtils.class, ERROR_FILE_SECURITY_EXCEPTION_KEY, file), e);
            }
        }
        return size;
    }

    public static FilesList listFiles(File file) throws IOException {
        FilesList list = new FilesList();
        if (file != null && FileUtils.exists(file)) {
            try {
                File[] files;
                list.add(file);
                if (file.isDirectory() && (files = file.listFiles()) != null) {
                    for (File f : files) {
                        list.add(FileUtils.listFiles(f));
                    }
                }
            }
            catch (SecurityException e) {
                ErrorManager.notifyError(ResourceUtils.getString(FileUtils.class, ERROR_FILE_SECURITY_EXCEPTION_KEY, file), e);
            }
        }
        return list;
    }

    public static long getFreeSpace(File file) {
        long freeSpace = 0L;
        try {
            freeSpace = SystemUtils.getNativeUtils().getFreeSpace(file);
        }
        catch (NativeException e) {
            ErrorManager.notifyError(ResourceUtils.getString(FileUtils.class, ERROR_CANT_GET_FREE_SPACE_KEY, file), e);
        }
        return freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCrc32(File file) throws IOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            long l = FileUtils.getCrc32(input);
            return l;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ignord) {}
            }
        }
    }

    public static long getCrc32(InputStream input) throws IOException {
        int readLength;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[65536];
        while ((readLength = input.read(buffer)) != -1) {
            crc.update(buffer, 0, readLength);
        }
        return crc.getValue();
    }

    public static String getMd5(File file) throws IOException {
        return StringUtils.asHexString(FileUtils.getMd5Bytes(file));
    }

    public static String getMd5(InputStream input) throws IOException {
        return StringUtils.asHexString(FileUtils.getMd5Bytes(input));
    }

    public static byte[] getMd5Bytes(File file) throws IOException {
        try {
            return FileUtils.getDigestBytes(file, MD5_DIGEST_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            ErrorManager.notifyCritical(ResourceUtils.getString(FileUtils.class, ERROR_MD5_NOT_SUPPORTED_KEY), e);
            return null;
        }
    }

    public static byte[] getMd5Bytes(InputStream input) throws IOException {
        try {
            return FileUtils.getDigestBytes(input, MD5_DIGEST_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            ErrorManager.notifyCritical(ResourceUtils.getString(FileUtils.class, ERROR_MD5_NOT_SUPPORTED_KEY), e);
            return null;
        }
    }

    public static String getSha1(File file) throws IOException {
        return StringUtils.asHexString(FileUtils.getSha1Bytes(file));
    }

    public static byte[] getSha1Bytes(File file) throws IOException {
        try {
            return FileUtils.getDigestBytes(file, SHA1_DIGEST_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            ErrorManager.notifyCritical(ResourceUtils.getString(FileUtils.class, ERROR_SHA1_NOT_SUPPORTED_KEY), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigestBytes(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] byArray = FileUtils.getDigestBytes(input, algorithm);
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    LogManager.log(ex);
                }
            }
        }
    }

    public static byte[] getDigestBytes(InputStream input, String algorithm) throws IOException, NoSuchAlgorithmException {
        int readLength;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        byte[] buffer = new byte[65536];
        while ((readLength = input.read(buffer)) != -1) {
            md.update(buffer, 0, readLength);
        }
        return md.digest();
    }

    public static boolean isEmpty(File file) {
        if (!FileUtils.exists(file)) {
            return true;
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (list != null) {
                for (File child : list) {
                    if (FileUtils.isEmpty(child)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean canRead(File file) {
        return FileUtils.canAccessFile(file, true);
    }

    public static boolean canWrite(File file) {
        return FileUtils.canAccessFile(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isJarFile(File file) {
        if (file.getName().endsWith(JAR_EXTENSION)) {
            boolean bl;
            JarFile jar;
            block12: {
                jar = null;
                jar = new JarFile(file);
                bl = true;
                if (jar == null) break block12;
                try {
                    jar.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CLOSE_JAR_KEY, jar.getName()), e);
                }
            }
            return bl;
            catch (IOException e) {
                boolean bl2;
                block13: {
                    try {
                        ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_NOT_JAR_FILE_KEY, file), e);
                        bl2 = false;
                        if (jar == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException e2) {
                                ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CLOSE_JAR_KEY, jar.getName()), e2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        jar.close();
                    }
                    catch (IOException e3) {
                        ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CLOSE_JAR_KEY, jar.getName()), e3);
                    }
                }
                return bl2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSigned(File file) throws IOException {
        JarFile jar = new JarFile(file);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            boolean signatureInfoPresent = false;
            boolean signatureFilePresent = false;
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.startsWith("META-INF/")) continue;
                if (entryName.endsWith(".RSA") || entryName.endsWith(".DSA")) {
                    signatureFilePresent = true;
                    if (!signatureInfoPresent) continue;
                    break;
                }
                if (!entryName.endsWith(".SF")) continue;
                signatureInfoPresent = true;
                if (!signatureFilePresent) continue;
                break;
            }
            boolean bl = signatureFilePresent && signatureInfoPresent;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    public static boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if (!file.isFile() && !file.isDirectory()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.exists()) {
                return false;
            }
            File[] children = parent.listFiles();
            if (children == null) {
                return false;
            }
            for (File child : children) {
                if (!child.equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isParent(File candidate, File file) {
        File parent;
        for (parent = file.getParentFile(); parent != null && !candidate.equals(parent); parent = parent.getParentFile()) {
        }
        return parent != null && candidate.equals(parent);
    }

    public static File getRoot(File fileRequested, List<File> roots) {
        File result = null;
        File file = fileRequested;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            LogManager.log("... cannot get canonical file for " + file);
        }
        for (File root : roots) {
            if (!FileUtils.isParent(root, file) && !root.equals(file) || result != null && result.getAbsolutePath().length() >= root.getAbsolutePath().length()) continue;
            result = root;
        }
        if (result == null && SystemUtils.isWindows() && FileUtils.isUNCPath(file.getPath())) {
            return FileUtils.getRoot(file);
        }
        return result;
    }

    public static long countChildren(File file) {
        long count = 0L;
        if (!file.exists()) {
            return 0L;
        }
        ++count;
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                count += FileUtils.countChildren(child);
            }
        }
        return count;
    }

    public static void modifyFile(File file, String token, Object replacement) throws IOException {
        FileUtils.modifyFile(file, token, replacement, false, Charset.defaultCharset().name());
    }

    public static void modifyFile(File file, String token, Object replacement, String charset) throws IOException {
        FileUtils.modifyFile(file, token, replacement, false, charset);
    }

    public static void modifyFile(File file, String token, Object replacement, boolean regexp) throws IOException {
        FileUtils.modifyFile(file, token, replacement, regexp, Charset.defaultCharset().name());
    }

    public static void modifyFile(File file, String token, Object replacement, boolean regexp, String charset) throws IOException {
        HashMap<String, Object> replacementMap = new HashMap<String, Object>();
        replacementMap.put(token, replacement);
        FileUtils.modifyFile(file, replacementMap, regexp, charset);
    }

    public static void modifyFile(File file, Map<String, Object> map) throws IOException {
        FileUtils.modifyFile(file, map, false);
    }

    public static void modifyFile(File file, Map<String, Object> map, boolean regexp) throws IOException {
        FileUtils.modifyFile(file, map, regexp, Charset.defaultCharset().name());
    }

    public static void modifyFile(File file, Map<String, Object> map, boolean regexp, String charset) throws IOException {
        if (!FileUtils.exists(file)) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtils.modifyFile(child, map, regexp, charset);
            }
        } else {
            if (file.length() > 102400L) {
                return;
            }
            String original = FileUtils.readFile(file, charset);
            String modified = new String(original);
            for (String token : map.keySet()) {
                Object object = map.get(token);
                String replacement = object instanceof File ? ((File)object).getAbsolutePath() : object.toString();
                if (regexp) {
                    modified = Pattern.compile(token, 8).matcher(modified).replaceAll(replacement);
                    continue;
                }
                modified = modified.toString().replace(token, replacement);
            }
            if (!modified.equals(original)) {
                LogManager.log("modifying file: " + file.getAbsolutePath());
                FileUtils.writeFile(file, (CharSequence)modified, charset);
            }
        }
    }

    public static void modifyFiles(List<File> files, Map<String, Object> map, boolean regexp) throws IOException {
        FileUtils.modifyFiles(files, map, regexp, new Progress());
    }

    public static void modifyFiles(List<File> files, Map<String, Object> map, boolean regexp, Progress progress) throws IOException {
        progress.setPercentage(0);
        for (int i = 0; i < files.size(); ++i) {
            FileUtils.modifyFile(files.get(i), map, regexp);
            progress.setPercentage(100 * i / files.size());
        }
        progress.setPercentage(100);
    }

    public static void deleteFile(File file) throws IOException {
        FileUtils.deleteFile(file, false);
    }

    public static void deleteFile(File file, Progress progress) throws IOException {
        FileUtils.deleteFile(file, false, progress);
    }

    public static void deleteFile(File file, boolean recurse) throws IOException {
        FileUtils.deleteFile(file, recurse, new Progress());
    }

    public static void deleteFile(File file, boolean recurse, Progress progress) throws IOException {
        long childrenCount = recurse ? FileUtils.countChildren(file) : 1L;
        FileUtils.deleteFile(file, recurse, progress, 0L, childrenCount == 0L ? 1L : childrenCount);
        progress.setPercentage(100);
    }

    public static void deleteFiles(List<File> files) throws IOException {
        FileUtils.deleteFiles(files, new Progress());
    }

    public static void deleteFiles(List<File> files, Progress progress) throws IOException {
        long count = 0L;
        for (File file : files) {
            count = FileUtils.deleteFile(file, false, progress, count, files.size());
        }
        progress.setPercentage(100);
    }

    public static void deleteFiles(File ... files) throws IOException {
        FileUtils.deleteFiles(new Progress(), files);
    }

    public static void deleteFiles(Progress progress, File ... files) throws IOException {
        FileUtils.deleteFiles(Arrays.asList(files), progress);
    }

    public static void deleteFiles(FilesList files) throws IOException {
        FileUtils.deleteFiles(files, new Progress());
    }

    public static void deleteFiles(FilesList files, Progress progress) throws IOException {
        long count = 0L;
        for (FileEntry entry : files) {
            count = FileUtils.deleteFile(entry.getFile(), false, progress, count, files.getSize());
        }
        progress.setPercentage(100);
    }

    public static void deleteEmptyParents(File file) throws IOException {
        File parent;
        if (!FileUtils.exists(file) && FileUtils.isEmpty(parent = file.getParentFile())) {
            FileUtils.deleteWithEmptyParents(parent);
        }
    }

    public static void deleteWithEmptyParents(File file) throws IOException {
        if (file == null) {
            return;
        }
        File probe = file;
        do {
            FileUtils.deleteFile(probe);
        } while ((probe = probe.getParentFile()) != null && FileUtils.isEmpty(probe));
    }

    public static void deleteOnExit(File file) {
        SystemUtils.getNativeUtils().addDeleteOnExitFile(file);
    }

    public static File createTempFile() throws IOException {
        return FileUtils.createTempFile(SystemUtils.getTempDirectory());
    }

    public static File createTempFile(File parent) throws IOException {
        return FileUtils.createTempFile(parent, true);
    }

    public static File createTempFile(File parent, boolean create) throws IOException {
        return FileUtils.createTempFile(parent, create, false);
    }

    public static File createTempFile(File parent, boolean create, boolean directory) throws IOException {
        File file = File.createTempFile("nbi-", ".tmp", parent);
        if (!create || directory) {
            file.delete();
        }
        if (create && directory) {
            FileUtils.mkdirs(file);
        }
        file.deleteOnExit();
        return file;
    }

    public static FilesList copyFile(File source, File target) throws IOException {
        return FileUtils.copyFile(source, target, false);
    }

    public static FilesList copyFile(File source, File target, Progress progress) throws IOException {
        return FileUtils.copyFile(source, target, false, progress);
    }

    public static FilesList copyFile(File source, File target, boolean recurse) throws IOException {
        return FileUtils.copyFile(source, target, recurse, new Progress());
    }

    public static FilesList copyFile(File source, File target, boolean recurse, Progress progress) throws IOException {
        FilesList list = new FilesList();
        long childrenCount = recurse ? FileUtils.countChildren(source) : 1L;
        FileUtils.copyFile(source, target, recurse, list, progress, 0L, childrenCount == 0L ? 1L : childrenCount);
        progress.setPercentage(100);
        return list;
    }

    public static FilesList moveFile(File source, File target) throws IOException {
        return FileUtils.moveFile(source, target, new Progress());
    }

    public static FilesList moveFile(File source, File target, Progress progress) throws IOException {
        FilesList list = new FilesList();
        progress.setDetail(StringUtils.format(MESSAGE_MOVING, source, target));
        if (!source.renameTo(target)) {
            CompositeProgress composite = new CompositeProgress();
            Progress copyProgress = new Progress();
            Progress deleteProgress = new Progress();
            composite.synchronizeTo(progress);
            composite.addChild(copyProgress, 80);
            composite.addChild(deleteProgress, 20);
            list.add(FileUtils.copyFile(source, target, true, copyProgress));
            FileUtils.deleteFile(source, true, deleteProgress);
        } else {
            list.add(target);
        }
        progress.setPercentage(100);
        return list;
    }

    public static void zip(File file, ZipOutputStream output, File root, List<File> excludes) throws IOException {
        if (excludes.contains(file)) {
            return;
        }
        String entryName = file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
        if (file.isDirectory()) {
            output.putNextEntry(new ZipEntry(entryName + SLASH));
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileUtils.zip(child, output, root, excludes);
                }
            }
        } else {
            output.putNextEntry(new ZipEntry(entryName));
            StreamUtils.transferFile(file, output);
        }
    }

    public static FilesList unzip(File source, File target) throws IOException {
        return FileUtils.extractAll(source, target, null, new Progress());
    }

    public static FilesList unzip(File source, File target, Progress progress) throws IOException {
        return FileUtils.extractAll(source, target, null, progress);
    }

    public static FilesList unjar(File source, File target) throws IOException, XMLException {
        return FileUtils.unjar(source, target, new Progress());
    }

    public static FilesList unjar(File source, File target, Progress progress) throws IOException, XMLException {
        return FileUtils.extractAll(source, target, METAINF_MASK, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipEntryExists(File file, String entry) throws IOException {
        ZipFile zip = new ZipFile(file);
        try {
            boolean bl = zip.getEntry(entry) != null;
            return bl;
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean jarEntryExists(File file, String entry) throws IOException {
        JarFile jar = new JarFile(file);
        try {
            boolean bl = jar.getEntry(entry) != null;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    public static File extractJarEntry(String entry, File source) throws IOException {
        return FileUtils.extractJarEntry(entry, source, FileUtils.createTempFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractJarEntry(String entry, File source, File target) throws IOException {
        JarFile jar = new JarFile(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            StreamUtils.transferData(jar.getInputStream(jar.getEntry(entry)), (OutputStream)out);
            File file = target;
            return file;
        }
        finally {
            jar.close();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarAttribute(File file, String name) throws IOException {
        String string;
        JarFile jar = new JarFile(file);
        try {
            string = jar.getManifest().getMainAttributes().getValue(name);
        }
        catch (Throwable throwable) {
            try {
                jar.close();
            }
            catch (IOException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CLOSE_JAR_KEY, jar.getName()), e);
            }
            throw throwable;
        }
        try {
            jar.close();
        }
        catch (IOException e) {
            ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CLOSE_JAR_KEY, jar.getName()), e);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File pack(File source) throws IOException {
        File target;
        block8: {
            block7: {
                File tmpTarget;
                block6: {
                    target = new File(source.getParentFile(), source.getName() + PACK_GZ_SUFFIX);
                    if (!SystemUtils.isWindows() || source.getAbsolutePath().length() <= 255) break block7;
                    File tmpSource = null;
                    tmpTarget = null;
                    try {
                        tmpSource = File.createTempFile(source.getName(), JAR_EXTENSION);
                        FileUtils.copyFile(source, tmpSource);
                        tmpTarget = FileUtils.pack(tmpSource);
                        FileUtils.deleteFile(tmpSource);
                        tmpSource = null;
                        FileUtils.copyFile(tmpTarget, target);
                        FileUtils.deleteFile(tmpTarget);
                        tmpTarget = null;
                        if (tmpSource == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (tmpSource != null) {
                            FileUtils.deleteFile(tmpSource);
                        }
                        if (tmpTarget != null) {
                            FileUtils.deleteFile(tmpTarget);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteFile(tmpSource);
                }
                if (tmpTarget != null) {
                    FileUtils.deleteFile(tmpTarget);
                }
                break block8;
            }
            ExecutionResults er = SystemUtils.executeCommand(SystemUtils.getPacker().getAbsolutePath(), target.getAbsolutePath(), source.getAbsolutePath());
            if (er.getErrorCode() != 0) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_PACK200_FAILED_KEY, er.getErrorCode(), er.getStdOut(), er.getStdErr()));
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpack(File source) throws IOException {
        File target;
        block12: {
            block11: {
                File tmpTarget;
                block10: {
                    String name = source.getName();
                    target = new File(source.getParentFile(), name.substring(0, name.length() - PACK_GZ_SUFFIX.length()));
                    if (!SystemUtils.isWindows() || source.getAbsolutePath().length() <= 255) break block11;
                    File tmpSource = null;
                    tmpTarget = null;
                    try {
                        tmpSource = File.createTempFile(target.getName(), ".tmp.pack.gz");
                        FileUtils.copyFile(source, tmpSource);
                        tmpTarget = FileUtils.unpack(tmpSource);
                        FileUtils.deleteFile(tmpSource);
                        tmpSource = null;
                        FileUtils.copyFile(tmpTarget, target);
                        FileUtils.deleteFile(tmpTarget);
                        tmpTarget = null;
                        if (tmpSource == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (tmpSource != null) {
                            FileUtils.deleteFile(tmpSource);
                        }
                        if (tmpTarget != null) {
                            FileUtils.deleteFile(tmpTarget);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteFile(tmpSource);
                }
                if (tmpTarget != null) {
                    FileUtils.deleteFile(tmpTarget);
                }
                break block12;
            }
            if (System.getProperty("os.name").equals("AIX") && System.getProperty("java.version").startsWith("1.6") || Boolean.getBoolean(USE_INTERNAL_UNPACK200_PROPERTY)) {
                FileUtils.unpack200Internal(source, target);
            } else {
                ExecutionResults er = SystemUtils.executeCommand(SystemUtils.getUnpacker().getAbsolutePath(), source.getAbsolutePath(), target.getAbsolutePath());
                int errorCode = er.getErrorCode();
                if (errorCode != 0) {
                    if (errorCode == -1073741801 || errorCode == -1073741502) {
                        LogManager.log("\n\n");
                        LogManager.log("Attention!");
                        LogManager.log("You have run into the Issue 117334");
                        LogManager.log("http://www.netbeans.org/issues/show_bug.cgi?id=117334");
                        LogManager.log("This is the result of error in process lvprcsrv.exe (Logitech QuickCam)");
                        LogManager.log("You should turn it off if you have had any issues during installations");
                        LogManager.log("\n\n");
                    } else {
                        throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_UNPACK200_FAILED_KEY, errorCode, er.getStdOut(), er.getStdErr()));
                    }
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpack200Internal(File source, File target) throws IOException {
        InputStream is = null;
        ZipOutputStream os = null;
        try {
            LogManager.log("unpacking " + source);
            is = new GZIPInputStream(new FileInputStream(source));
            os = new JarOutputStream(new FileOutputStream(target));
            unpacker.unpack(is, (JarOutputStream)os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static FilesList mkdirs(File file) throws IOException {
        FilesList list = new FilesList();
        if (FileUtils.exists(file)) {
            if (file.isFile()) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CREATE_DIR_EXIST_FILE_KEY, file));
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !FileUtils.exists(parent)) {
                list.add(FileUtils.mkdirs(parent));
            }
            if (file.mkdir()) {
                list.add(file);
            } else {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_CANT_CREATE_DIR_KEY, file));
            }
        }
        return list;
    }

    public static String getRelativePath(File source, File target) {
        String path;
        if (source.equals(target)) {
            path = source.isDirectory() ? CURRENT : target.getName();
        } else if (FileUtils.isParent(source, target)) {
            String sourcePath = source.getAbsolutePath().replace(BACKSLASH, SLASH);
            String targetPath = target.getAbsolutePath().replace(BACKSLASH, SLASH);
            path = sourcePath.endsWith(SLASH) ? targetPath.substring(sourcePath.length()) : targetPath.substring(sourcePath.length() + 1);
        } else if (FileUtils.isParent(target, source)) {
            path = source.isDirectory() ? PARENT : CURRENT;
            File parent = source.getParentFile();
            while (!parent.equals(target)) {
                path = path + "/..";
                parent = parent.getParentFile();
            }
        } else {
            File parent;
            for (parent = source.getParentFile(); parent != null && !FileUtils.isParent(parent, target); parent = parent.getParentFile()) {
            }
            if (parent == null) {
                return null;
            }
            path = FileUtils.getRelativePath(source, parent) + SLASH + FileUtils.getRelativePath(parent, target);
        }
        if (path.startsWith("./")) {
            path = path.length() > 2 ? path.substring(2) : path.substring(0, 1);
        }
        path = path.replace("/./", SLASH);
        return path;
    }

    public static boolean isUNCPath(String path) {
        return SystemUtils.getNativeUtils().isUNCPath(path);
    }

    public static File eliminateRelativity(String path) {
        int index;
        String corrected = path;
        corrected = SystemUtils.isWindows() && FileUtils.isUNCPath(corrected) ? corrected.substring(0, 2) + corrected.substring(2).replace(BACKSLASH, SLASH) : corrected.replace(BACKSLASH, SLASH);
        while (corrected.indexOf("//") != -1) {
            corrected = corrected.replace("//", SLASH);
        }
        while (corrected.indexOf("/./") != -1) {
            corrected = corrected.replace("/./", SLASH);
        }
        Pattern pattern = Pattern.compile("(\\/([^\\/]+)\\/\\.\\.\\/)");
        Matcher matcher = pattern.matcher(corrected);
        while (matcher.find()) {
            if (matcher.group(2).equals(PARENT)) continue;
            corrected = corrected.replace(matcher.group(), SLASH);
            matcher = pattern.matcher(corrected);
        }
        if (corrected.endsWith("/.")) {
            corrected = corrected.substring(0, corrected.length() - SLASH.length() - CURRENT.length());
        }
        if (corrected.endsWith("/..") && (index = corrected.lastIndexOf(SLASH, corrected.length() - SLASH.length() - PARENT.length() - 1)) != -1) {
            corrected = corrected.substring(0, index);
        }
        return new File(corrected);
    }

    public static File getRoot(File file) {
        return SystemUtils.getNativeUtils().getRoot(file);
    }

    public static File findFile(File directory, String filename) {
        if (directory.getName().equals(filename)) {
            return directory;
        }
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                File match = FileUtils.findFile(child, filename);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    private static long deleteFile(File file, boolean recurse, Progress progress, long start, long total) throws IOException {
        long count = start;
        if (SystemUtils.isDeletingAllowed(file)) {
            File[] children;
            String type;
            boolean isDir = file.isDirectory();
            String string = type = isDir ? "directory" : "file";
            if (isDir && recurse && (children = file.listFiles()) != null) {
                for (File child : children) {
                    count = FileUtils.deleteFile(child, true, progress, count, total);
                }
            }
            LogManager.log("deleting " + type + ": " + file);
            progress.setDetail(StringUtils.format(isDir ? MESSAGE_DELETE_DIR : MESSAGE_DELETE_FILE, file));
            if (!FileUtils.exists(file)) {
                LogManager.log("    ... " + type + " does not exist");
                SystemUtils.getNativeUtils().removeDeleteOnExitFile(file);
            } else if (!file.delete()) {
                FileUtils.deleteOnExit(file);
            }
            progress.setPercentage(100L * ++count / total);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyFile(File source, File target, boolean recurse, FilesList list, Progress progress, long start, long total) throws IOException {
        long count = start;
        if (!FileUtils.exists(source)) {
            LogManager.log("    ... " + source + " does not exist");
            return count;
        }
        if (source.isFile()) {
            LogManager.log("copying file: " + source + " to: " + target);
            progress.setDetail(StringUtils.format(MESSAGE_COPY_FILE, source, target));
            if (!source.canRead()) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_SOURCE_NOT_READABLE_KEY, source));
            }
            if (FileUtils.exists(target) && !target.isFile()) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_DEST_NOT_FILE_KEY, target));
            }
            File parent = target.getParentFile();
            if (!FileUtils.exists(parent)) {
                list.add(FileUtils.mkdirs(parent));
            }
            if (!FileUtils.exists(target) && !target.createNewFile()) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_DEST_CREATION_KEY, target));
            }
            if (!target.canWrite()) {
                throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_DEST_NOT_WRITABLE_KEY, target));
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(target);
                StreamUtils.transferData(in, (OutputStream)out);
                list.add(target);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CLOSE_STREAM_KEY), e);
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_CLOSE_STREAM_KEY), e);
                }
            }
        }
        LogManager.log("copying directory: " + source + " to: " + target + (recurse ? " with recursion" : ""));
        progress.setDetail(StringUtils.format(MESSAGE_COPY_DIRECTORY, source, target));
        list.add(FileUtils.mkdirs(target));
        if (recurse) {
            for (File file : source.listFiles()) {
                count = FileUtils.copyFile(file, new File(target, file.getName()), recurse, list, progress, count, total);
            }
        }
        progress.setPercentage(100L * ++count / total);
        return count;
    }

    private static boolean canAccessDirectoryReal(File file, boolean isReadNotWrite) {
        if (isReadNotWrite) {
            boolean result = file.listFiles() != null;
            return result;
        }
        try {
            FileUtils.createTempFile(file).delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canAccessFileReal(File file, boolean isReadNotWrite) {
        Closeable stream = null;
        LogManager.indent();
        try {
            stream = isReadNotWrite ? new FileInputStream(file) : new FileOutputStream(file);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            LogManager.unindent();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    LogManager.log(ex);
                }
            }
        }
    }

    private static boolean canAccessFile(File fileToCheck, boolean isReadNotWrite) {
        boolean javaAccessCheck;
        File file = fileToCheck;
        if (!FileUtils.exists(file)) {
            File parent = file;
            while ((parent = parent.getParentFile()) != null && !FileUtils.exists(parent)) {
            }
            if (parent == null || !parent.isDirectory()) {
                return false;
            }
            file = parent;
        }
        boolean bl = javaAccessCheck = isReadNotWrite ? file.canRead() : file.canWrite();
        if (SystemUtils.isWindows() && !isReadNotWrite && file.isDirectory()) {
            javaAccessCheck = true;
        }
        if (javaAccessCheck) {
            boolean result = true;
            boolean needCheckDirectory = true;
            try {
                result = SystemUtils.getNativeUtils().checkFileAccess(file, isReadNotWrite);
                if (!isReadNotWrite) {
                    needCheckDirectory = false;
                }
            }
            catch (NativeException ex) {
                LogManager.log(ex);
            }
            if (!result) {
                return false;
            }
            if (file.isFile()) {
                return FileUtils.canAccessFileReal(file, isReadNotWrite);
            }
            if (file.isDirectory() && needCheckDirectory) {
                return FileUtils.canAccessDirectoryReal(file, isReadNotWrite);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FilesList extractAll(File file, File target, String excludes, Progress progress) throws IOException {
        FilesList list = new FilesList();
        if (FileUtils.exists(target) && target.isFile()) {
            throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_UNJAR_TODIR_KEY, target));
        }
        if (!FileUtils.exists(target)) {
            list.add(FileUtils.mkdirs(target));
        }
        ZipFile zip = new ZipFile(file);
        try {
            FilesList extracted = null;
            boolean extractedWithList = false;
            if (FileUtils.zipEntryExists(file, FILES_LIST_ENTRY)) {
                try {
                    File initialList = FileUtils.extractJarEntry(FILES_LIST_ENTRY, file);
                    FilesList toExtract = new FilesList().loadXml(initialList, target);
                    FileUtils.deleteFile(initialList);
                    extracted = FileUtils.extractByList(zip, target, toExtract, progress);
                    toExtract.clear();
                    extractedWithList = true;
                }
                catch (XMLException e) {
                    ErrorManager.notifyDebug(ResourceUtils.getString(FileUtils.class, ERROR_LOAD_XML_FILE_LIST_KEY), e);
                }
            }
            if (!extractedWithList) {
                extracted = FileUtils.extractNormal(zip, target, excludes, progress);
            }
            list.add(extracted);
            extracted.clear();
        }
        finally {
            zip.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FilesList extractByList(ZipFile zip, File target, FilesList list, Progress progress) throws IOException {
        FilesList newList = new FilesList();
        String targetPath = target.getAbsolutePath();
        int total = list.getSize();
        int extracted = 0;
        for (FileEntry listEntry : list) {
            if (progress.isCanceled()) {
                return newList;
            }
            String listEntryName = listEntry.getName();
            File listEntryFile = listEntry.getFile();
            String zipEntryName = listEntryName.substring(targetPath.length() + 1);
            progress.setPercentage(100 * ++extracted / total);
            progress.setDetail(StringUtils.format(MESSAGE_EXTRACTING, listEntryFile));
            LogManager.log("extracting " + listEntryFile);
            if (listEntry.isDirectory()) {
                newList.add(FileUtils.mkdirs(listEntryFile));
            } else {
                ZipEntry zipEntry = zip.getEntry(zipEntryName);
                newList.add(FileUtils.mkdirs(listEntryFile.getParentFile()));
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = zip.getInputStream(zipEntry);
                    out = new FileOutputStream(listEntryFile);
                    StreamUtils.transferData(in, out);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                if (listEntry.isPackedJarFile()) {
                    File packed = listEntry.getFile();
                    File unpacked = FileUtils.unpack(packed);
                    FileUtils.deleteFile(packed);
                    listEntry = new FileEntry(unpacked, listEntry.getSize(), listEntry.getMd5(), listEntry.isJarFile(), false, listEntry.isSignedJarFile(), listEntry.getLastModified(), listEntry.getPermissions());
                }
                listEntryFile.setLastModified(listEntry.getLastModified());
                SystemUtils.setPermissions(listEntry.getFile(), listEntry.getPermissions(), 1);
            }
            newList.add(listEntry);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FilesList extractNormal(ZipFile zip, File target, String excludes, Progress progress) throws IOException {
        FilesList list = new FilesList();
        int total = 0;
        int extracted = 0;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ++total;
            entries.nextElement();
        }
        entries = zip.entries();
        while (entries.hasMoreElements()) {
            if (progress.isCanceled()) {
                return list;
            }
            ZipEntry entry = entries.nextElement();
            progress.setPercentage(100 * ++extracted / total);
            if (excludes != null && entry.getName().matches(excludes)) continue;
            File file = new File(target, entry.getName()).getAbsoluteFile();
            progress.setDetail(StringUtils.format(MESSAGE_EXTRACTING, file));
            LogManager.log("extracting " + file);
            if (entry.getName().endsWith(SLASH)) {
                if (FileUtils.exists(file) && !file.isDirectory()) {
                    throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_OUTPUT_DIR_ENTRY_KEY, file));
                }
                if (!FileUtils.exists(file)) {
                    list.add(FileUtils.mkdirs(file));
                }
            } else {
                File parent = file.getParentFile();
                if (!FileUtils.exists(parent)) {
                    list.add(FileUtils.mkdirs(parent));
                }
                if (FileUtils.exists(file) && !file.isFile()) {
                    throw new IOException(ResourceUtils.getString(FileUtils.class, ERROR_OUTPUT_FILE_ENTRY_KEY, file));
                }
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = zip.getInputStream(entry);
                    out = new FileOutputStream(file);
                    StreamUtils.transferData(in, out);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                list.add(file);
            }
            file.setLastModified(entry.getTime());
        }
        return list;
    }

    private FileUtils() {
    }
}

