/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import java.util.MissingResourceException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.indent.IndentSupport;
import org.netbeans.modules.cnd.editor.indent.TokenItem;
import org.netbeans.modules.cnd.spi.editor.CsmDocGeneratorProvider;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.openide.util.Exceptions;

public class CppIndentTask
extends IndentSupport
implements IndentTask {
    private Context context;
    private Document doc;

    public CppIndentTask(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public void reindent() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        int caretOffset = this.context.caretOffset();
        int lineOffset = this.context.lineStartOffset(caretOffset);
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)lineOffset, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return;
        }
        int indent = this.indentLine(new TokenItem((TokenSequence<TokenId>)this.ts, true), caretOffset);
        if (indent >= 0) {
            this.context.modifyIndent(lineOffset, indent);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    private String spaces(int i) {
        StringBuilder buf = new StringBuilder(i);
        while (i > 0) {
            buf.append(' ');
            --i;
        }
        return buf.toString();
    }

    private StringBuilder createDoc(int indent, CsmDocGeneratorProvider.Function function) throws MissingResourceException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.spaces(indent));
        buf.append("* ").append("\n");
        for (CsmDocGeneratorProvider.Parameter p : function.getParametes()) {
            buf.append(this.spaces(indent));
            buf.append("* @param ").append(p.getName()).append('\n');
        }
        String returnType = function.getReturnType();
        if (returnType != null && !"void".equals(returnType)) {
            buf.append(this.spaces(indent));
            buf.append("* @return ").append('\n');
        }
        buf.append(this.spaces(indent));
        return buf;
    }

    private TokenItem moveToFirstLineImportantToken(TokenItem token) {
        TokenItem t = token;
        while (t != null) {
            TokenId tokenID = t.getTokenID();
            if (tokenID instanceof CppTokenId) {
                switch ((CppTokenId)tokenID) {
                    case NEW_LINE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        if (t.isSkipPP()) {
                            return token;
                        }
                        return t;
                    }
                    case WHITESPACE: {
                        break;
                    }
                    default: {
                        return t;
                    }
                }
            }
            token = t;
            t = token.getNext();
        }
        return token;
    }

    private int indentLine(TokenItem token, int caretOffset) {
        TokenItem prev;
        if (token.getTokenID() == CppTokenId.STRING_LITERAL || token.getTokenID() == CppTokenId.CHAR_LITERAL) {
            int start = token.getTokenSequence().offset();
            Token tok = token.getTokenSequence().token();
            if (start < caretOffset && caretOffset < start + tok.length() && caretOffset >= start + 2 && tok.text().charAt(caretOffset - start - 2) == '\\' && (caretOffset <= start + 2 || tok.text().charAt(caretOffset - start - 3) != '\\')) {
                return -1;
            }
        }
        if (token.getTokenID() == CppTokenId.NEW_LINE && (prev = token.getPrevious()) != null && prev.getTokenID() == CppTokenId.ESCAPED_LINE) {
            return -1;
        }
        if (this.isMultiLineComment(token)) {
            if (caretOffset == token.getTokenSequence().offset()) {
                return this.findIndent(token);
            }
            if (!this.getFormatLeadingStarInComment()) {
                return this.getTokenColumn(token) + 1;
            }
            int indent = this.getTokenColumn(token) + 1;
            try {
                if (caretOffset - token.getTokenSequence().offset() == 4 && this.doc.getLength() > token.getTokenSequence().offset() + 6 && "/**\n*/".equals(this.doc.getText(token.getTokenSequence().offset(), 6))) {
                    CsmDocGeneratorProvider.Function function = CsmDocGeneratorProvider.getDefault().getFunction(this.doc, caretOffset);
                    if (function != null) {
                        StringBuilder buf = this.createDoc(indent, function);
                        this.doc.insertString(caretOffset, buf.toString(), null);
                        this.context.setCaretOffset(caretOffset + indent + 2);
                    }
                } else if (!"*".equals(this.doc.getText(caretOffset, 1)) && caretOffset > 0 && "\n".equals(this.doc.getText(caretOffset - 1, 1))) {
                    this.doc.insertString(caretOffset, "* ", null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return indent;
        }
        TokenItem ppToken = this.moveToFirstLineImportantToken(new TokenItem((TokenSequence<TokenId>)this.ts, false));
        if (this.isPreprocessorLine(ppToken)) {
            if (this.codeStyle.sharpAtStartLine()) {
                return 0;
            }
            switch (this.codeStyle.indentPreprocessorDirectives()) {
                case PREPROCESSOR_INDENT: {
                    return this.findPPIndent(ppToken);
                }
                case START_LINE: {
                    return 0;
                }
            }
        }
        return this.findIndent(this.moveToFirstLineImportantToken(token));
    }

    private boolean isPreprocessorLine(TokenItem token) {
        if (token != null) {
            return "preprocessor-keyword".equals(token.getTokenID().primaryCategory()) || "preprocessor".equals(token.getTokenID().primaryCategory());
        }
        return false;
    }

    private boolean isMultiLineComment(TokenItem token) {
        return token.getTokenID() == CppTokenId.BLOCK_COMMENT || token.getTokenID() == CppTokenId.DOXYGEN_COMMENT;
    }

    private boolean isCCDocComment(TokenItem token) {
        return this.isMultiLineComment(token);
    }

    private int findPPIndent(TokenItem token) {
        int indent = -1;
        if (token != null) {
            CppTokenId currentId = token.getTokenPPID();
            TokenItem prev = this.findPreviousPP(token);
            if (prev == null) {
                return 0;
            }
            CppTokenId prevId = prev.getTokenPPID();
            block0 : switch (prevId) {
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: 
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    switch (currentId) {
                        case PREPROCESSOR_ELSE: 
                        case PREPROCESSOR_ELIF: 
                        case PREPROCESSOR_ENDIF: {
                            indent = this.getTokenIndent(prev);
                            break block0;
                        }
                    }
                    indent = this.getTokenIndent(prev) + this.getShiftWidth();
                    break;
                }
                case PREPROCESSOR_DIRECTIVE: 
                case PREPROCESSOR_START: 
                case PREPROCESSOR_DEFINE: 
                case PREPROCESSOR_UNDEF: 
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_LINE: 
                case PREPROCESSOR_IDENT: 
                case PREPROCESSOR_PRAGMA: 
                case PREPROCESSOR_WARNING: 
                case PREPROCESSOR_ERROR: 
                case PREPROCESSOR_DEFINED: {
                    switch (currentId) {
                        case PREPROCESSOR_ELSE: 
                        case PREPROCESSOR_ELIF: 
                        case PREPROCESSOR_ENDIF: {
                            TokenItem prevIf = this.matchPreviousPP(prev);
                            if (prevIf != null) {
                                indent = this.getTokenIndent(prevIf);
                                break block0;
                            }
                            indent = this.getTokenIndent(prev);
                            break block0;
                        }
                    }
                    indent = this.getTokenIndent(prev);
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    switch (currentId) {
                        case PREPROCESSOR_ELSE: 
                        case PREPROCESSOR_ELIF: 
                        case PREPROCESSOR_ENDIF: {
                            indent = this.getTokenIndent(prev) - this.getShiftWidth();
                            break block0;
                        }
                    }
                    indent = this.getTokenIndent(prev);
                }
            }
        }
        return indent;
    }

    private TokenItem findPreviousPP(TokenItem token) {
        while (token != null) {
            TokenItem t = token.getPrevious();
            if (t != null && this.isPreprocessorLine(t)) {
                return t;
            }
            token = t;
        }
        return null;
    }

    private TokenItem matchPreviousPP(TokenItem token) {
        int level = 1;
        while (token != null) {
            TokenItem t = this.findPreviousPP(token);
            if (t != null) {
                switch (t.getTokenPPID()) {
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: {
                        if (--level > 0) break;
                        return t;
                    }
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ELIF: {
                        if (level != 0) break;
                        return t;
                    }
                    case PREPROCESSOR_ENDIF: {
                        ++level;
                        break;
                    }
                }
            }
            token = t;
        }
        return null;
    }

    private int findIndent(TokenItem token) {
        TokenItem t;
        TokenId tokenID;
        int indent = -1;
        if (token != null && (tokenID = token.getTokenID()) instanceof CppTokenId) {
            block0 : switch ((CppTokenId)tokenID) {
                case ELSE: {
                    TokenItem ifss = this.findIf(token);
                    if (ifss == null) break;
                    indent = this.getTokenIndent(ifss);
                    break;
                }
                case LBRACE: {
                    TokenItem stmt = this.findStatement(token);
                    if (stmt == null) {
                        indent = 0;
                        break;
                    }
                    TokenId stmtTokenID = stmt.getTokenID();
                    if (!(stmtTokenID instanceof CppTokenId)) break;
                    switch ((CppTokenId)stmtTokenID) {
                        case DO: 
                        case FOR: 
                        case IF: 
                        case WHILE: 
                        case ELSE: 
                        case TRY: 
                        case ASM: 
                        case CATCH: {
                            indent = this.getTokenIndent(stmt);
                            if (!this.isHalfIndentNewlineBeforeBrace()) break block0;
                            indent += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case SWITCH: {
                            indent = this.getTokenIndent(stmt);
                            if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break block0;
                            indent += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case LBRACE: {
                            indent = this.getTokenIndent(stmt) + this.getShiftWidth();
                            break block0;
                        }
                        default: {
                            stmt = this.findStatementStart(token);
                            if (stmt == null) {
                                indent = 0;
                                break block0;
                            }
                            if (stmt == token) {
                                stmt = this.findStatement(token);
                                indent = stmt != null ? (indent = this.getTokenIndent(stmt)) : 0;
                                break block0;
                            }
                            indent = this.getTokenIndent(stmt);
                            if (stmt.getTokenID() != CppTokenId.LBRACE) break block0;
                            indent += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case RBRACE: {
                    TokenItem rbmt = this.findMatchingToken(token, null, CppTokenId.LBRACE, true);
                    if (rbmt != null) {
                        TokenId tTokenID;
                        TokenItem t2 = this.findStatement(rbmt);
                        boolean forceFirstNonWhitespace = false;
                        if (t2 == null) {
                            t2 = rbmt;
                        } else {
                            tTokenID = t2.getTokenID();
                            if (tTokenID instanceof CppTokenId) {
                                switch ((CppTokenId)tTokenID) {
                                    case LBRACE: 
                                    case SEMICOLON: 
                                    case RBRACE: {
                                        t2 = rbmt;
                                        forceFirstNonWhitespace = true;
                                    }
                                }
                            }
                        }
                        indent = forceFirstNonWhitespace ? this.getTokenColumnAfterBrace(t2) : this.getTokenIndent(t2);
                        tTokenID = t2.getTokenID();
                        if (tTokenID instanceof CppTokenId) {
                            switch ((CppTokenId)tTokenID) {
                                case DO: 
                                case FOR: 
                                case IF: 
                                case WHILE: 
                                case ELSE: 
                                case TRY: 
                                case ASM: 
                                case CATCH: {
                                    if (!this.isHalfIndentNewlineBeforeBrace()) break;
                                    indent += this.getShiftWidth() / 2;
                                    break;
                                }
                                case SWITCH: {
                                    if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                                    indent += this.getShiftWidth() / 2;
                                }
                            }
                        }
                        break;
                    }
                    indent = this.getTokenIndent(token);
                    break;
                }
                case CASE: 
                case DEFAULT: {
                    TokenItem swss = this.findSwitch(token);
                    if (swss == null) break;
                    indent = this.getTokenIndent(swss);
                    if (this.indentCasesFromSwitch()) {
                        indent += this.getShiftWidth();
                        break;
                    }
                    if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                    indent += this.getShiftWidth() / 2;
                    break;
                }
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: {
                    TokenItem cls = this.findClassifier(token);
                    if (cls == null) break;
                    indent = this.getTokenIndent(cls);
                    if (!this.isHalfIndentVisibility()) break;
                    indent += this.getShiftWidth() / 2;
                    break;
                }
                case CLASS: 
                case STRUCT: {
                    TokenItem clsTemplate = this.findClassifierStart(token);
                    if (clsTemplate == null) break;
                    indent = this.getTokenIndent(clsTemplate);
                }
            }
        }
        if (indent < 0 && (t = this.findImportantToken(token, null, true)) != null) {
            TokenId tokenID2 = t.getTokenID();
            if (tokenID2 instanceof CppTokenId) {
                block20 : switch ((CppTokenId)tokenID2) {
                    case SEMICOLON: {
                        TokenId ttTokenID;
                        TokenItem tt = this.findStatementStart(token);
                        if (tt == null || !((ttTokenID = tt.getTokenID()) instanceof CppTokenId)) break;
                        switch ((CppTokenId)ttTokenID) {
                            case PUBLIC: 
                            case PRIVATE: 
                            case PROTECTED: {
                                indent = this.getTokenIndent(tt) + this.getShiftWidth();
                                if (!this.isHalfIndentVisibility()) break block20;
                                indent -= this.getShiftWidth() / 2;
                                break block20;
                            }
                            case FOR: {
                                if (this.isForLoopSemicolon(t)) {
                                    TokenItem lparen;
                                    if (this.alignMultilineFor() && (lparen = this.getLeftParen(t, tt)) != null) {
                                        indent = this.getTokenColumn(lparen) + 1;
                                        break block20;
                                    }
                                    indent = this.getTokenIndent(tt) + this.getFormatStatementContinuationIndent();
                                    break block20;
                                }
                                indent = this.getTokenIndent(tt);
                                break block20;
                            }
                            default: {
                                indent = this.getTokenIndent(tt);
                            }
                        }
                        break;
                    }
                    case LBRACE: {
                        TokenId lbssTokenID;
                        TokenItem lbss = this.findStatementStart(t, false);
                        if (lbss == null) {
                            lbss = t;
                        }
                        if (!((lbssTokenID = lbss.getTokenID()) instanceof CppTokenId)) break;
                        switch ((CppTokenId)lbssTokenID) {
                            case DO: 
                            case FOR: 
                            case IF: 
                            case WHILE: 
                            case ELSE: 
                            case TRY: 
                            case ASM: 
                            case CATCH: 
                            case SWITCH: {
                                indent = this.getTokenIndent(lbss) + this.getShiftWidth();
                                break block20;
                            }
                            case NAMESPACE: {
                                if (this.indentNamespace()) {
                                    indent = this.getTokenIndent(lbss) + this.getRightIndentDeclaration();
                                    break block20;
                                }
                                indent = this.getTokenIndent(lbss);
                                break block20;
                            }
                        }
                        indent = this.getTokenIndent(lbss) + this.getRightIndentDeclaration();
                        break;
                    }
                    case RBRACE: {
                        TokenItem t3 = this.findStatementStart(token, true);
                        if (t3 == null) break;
                        indent = this.getTokenIndent(t3);
                        break;
                    }
                    case COLON: {
                        TokenId tttTokenID;
                        TokenItem ttt = this.getVisibility(t);
                        if (ttt != null) {
                            indent = this.getTokenIndent(ttt) + this.getRightIndentDeclaration();
                            if (!this.isHalfIndentVisibility()) break;
                            indent -= this.getShiftWidth() / 2;
                            break;
                        }
                        ttt = this.findAnyToken(t, null, new CppTokenId[]{CppTokenId.CASE, CppTokenId.DEFAULT, CppTokenId.QUESTION, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC}, true);
                        if (ttt == null || !((tttTokenID = ttt.getTokenID()) instanceof CppTokenId)) break;
                        switch ((CppTokenId)tttTokenID) {
                            case QUESTION: {
                                indent = this.getTokenIndent(ttt) + this.getShiftWidth();
                                break block20;
                            }
                            case CASE: 
                            case DEFAULT: {
                                indent = this.getTokenIndent(ttt) + this.getRightIndentSwitch();
                                break block20;
                            }
                        }
                        indent = this.getTokenIndent(t);
                        break;
                    }
                    case QUESTION: {
                        indent = this.getTokenIndent(t) + this.getShiftWidth();
                        break;
                    }
                    case DO: 
                    case ELSE: {
                        indent = this.getTokenIndent(t) + this.getRightIndent();
                        break;
                    }
                    case RPAREN: {
                        TokenId rpmtTokenID;
                        TokenItem rpmt = this.findMatchingToken(t, null, CppTokenId.LPAREN, true);
                        if (rpmt != null && (rpmt = this.findImportantToken(rpmt, null, true)) != null && (rpmtTokenID = rpmt.getTokenID()) instanceof CppTokenId) {
                            switch ((CppTokenId)rpmtTokenID) {
                                case FOR: 
                                case IF: 
                                case WHILE: {
                                    indent = this.getTokenIndent(rpmt) + this.getRightIndent();
                                    break;
                                }
                                case IDENTIFIER: {
                                    if (token == null || token.getTokenID() != CppTokenId.IDENTIFIER) break;
                                    indent = this.getTokenIndent(t);
                                }
                            }
                        }
                        if (indent >= 0) break;
                        indent = this.computeStatementIndent(t);
                        break;
                    }
                    case IDENTIFIER: {
                        if (token != null && token.getTokenID() == CppTokenId.IDENTIFIER) {
                            indent = this.getTokenIndent(t);
                            break;
                        }
                        indent = this.computeStatementIndent(t);
                        break;
                    }
                    case COMMA: {
                        if (this.isEnumComma(t)) {
                            indent = this.getTokenIndent(t);
                            break;
                        }
                        if (this.isFieldComma(t)) {
                            indent = this.getTokenIndent(t);
                            break;
                        }
                        indent = this.computeStatementIndent(t);
                        break;
                    }
                    default: {
                        indent = this.computeStatementIndent(t);
                    }
                }
            }
            if (indent < 0) {
                indent = this.getTokenIndent(t);
            }
        }
        if (indent < 0) {
            indent = 0;
        }
        return indent;
    }

    private int computeStatementIndent(TokenItem t) {
        TokenItem stmtStart = this.findStatementStart(t);
        int indent = this.getTokenIndent(stmtStart);
        if (stmtStart != null) {
            if (t != null && t.getTokenID() == CppTokenId.COMMA) {
                TokenItem prev;
                if (this.isArrayInitializationBraceBlock(t, null) && this.getLeftParen(t, stmtStart) == null) {
                    return indent;
                }
                TokenItem lparen = this.getLeftParen(t, stmtStart);
                if (lparen != null && (prev = this.findImportantToken(lparen, null, true)) != null && prev.getTokenID() == CppTokenId.IDENTIFIER && (this.isStatement(stmtStart) ? this.alignMultilineCallArgs() : this.alignMultilineMethodParams())) {
                    return this.getTokenColumn(lparen) + 1;
                }
            } else if (stmtStart.getTokenID() == CppTokenId.IF && this.alignMultilineIf() || stmtStart.getTokenID() == CppTokenId.WHILE && this.alignMultilineWhile() || stmtStart.getTokenID() == CppTokenId.FOR && this.alignMultilineFor()) {
                TokenItem lparen;
                if (t != null && (lparen = this.getLeftParen(t, stmtStart)) != null) {
                    return this.getTokenColumn(lparen) + 1;
                }
            } else if (!this.isStatement(stmtStart)) {
                return indent;
            }
            indent += this.getFormatStatementContinuationIndent();
        }
        return indent;
    }

    public CppIndentTask(Document doc) {
        this.doc = doc;
    }

    public int getLineIndentation(int caretOffset) {
        int lineOffset;
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        try {
            lineOffset = IndentUtils.lineStartOffset((Document)this.doc, (int)caretOffset);
        }
        catch (BadLocationException ex) {
            return 0;
        }
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)lineOffset, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return 0;
        }
        int indent = this.indentLine(new TokenItem((TokenSequence<TokenId>)this.ts, true), caretOffset);
        return indent;
    }

    public void reindent(int caretOffset) throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        int lineOffset = IndentUtils.lineStartOffset((Document)this.doc, (int)caretOffset);
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)lineOffset, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return;
        }
        int indent = this.indentLine(new TokenItem((TokenSequence<TokenId>)this.ts, true), caretOffset);
        if (indent >= 0) {
            this.modifyIndent(lineOffset, indent);
        }
    }

    private void modifyIndent(int lineStartOffset, int newIndent) throws BadLocationException {
        char ch;
        int oldIndentEndOffset;
        int indent = 0;
        int tabSize = -1;
        String docText = this.doc.getText(0, this.doc.getLength());
        for (oldIndentEndOffset = lineStartOffset; oldIndentEndOffset < docText.length() && (ch = docText.charAt(oldIndentEndOffset)) != '\n'; ++oldIndentEndOffset) {
            if (ch == '\t') {
                if (tabSize == -1) {
                    tabSize = IndentUtils.tabSize((Document)this.doc);
                }
                indent = (indent + tabSize) / tabSize * tabSize;
                continue;
            }
            if (!Character.isWhitespace(ch)) break;
            ++indent;
        }
        String newIndentString = IndentUtils.createIndentString((Document)this.doc, (int)newIndent);
        int offset = lineStartOffset;
        for (int i = 0; i < newIndentString.length() && lineStartOffset + i < oldIndentEndOffset; ++i) {
            if (newIndentString.charAt(i) == docText.charAt(lineStartOffset + i)) continue;
            offset = lineStartOffset + i;
            newIndentString = newIndentString.substring(i);
            break;
        }
        if (offset < oldIndentEndOffset) {
            this.doc.remove(offset, oldIndentEndOffset - offset);
        }
        if (newIndentString.length() > 0) {
            this.doc.insertString(offset, newIndentString, null);
        }
    }
}

