/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class J2SELibraryTypeProvider
implements LibraryTypeProvider {
    private static final Logger LOG = Logger.getLogger(J2SELibraryTypeProvider.class.getName());
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String VOLUME_TYPE_MAVEN_POM = "maven-pom";
    public static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc", "maven-pom"};
    private static final Set<String> VOLUME_TYPES_REQUIRING_FOLDER = new HashSet<String>(Arrays.asList("classpath", "src", "javadoc"));

    private J2SELibraryTypeProvider() {
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(J2SELibraryTypeProvider.class, (String)"TXT_J2SELibraryType");
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return new J2SELibraryImpl();
    }

    public void libraryCreated(final LibraryImplementation libraryImpl) {
        assert (libraryImpl != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    boolean save = J2SELibraryTypeProvider.addLibraryIntoBuild(libraryImpl, props);
                    if (save) {
                        PropertyUtils.putGlobalProperties((EditableProperties)props);
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImpl) {
        assert (libraryImpl != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String property = J2SELibraryTypeProvider.LIB_PREFIX + libraryImpl.getName() + '.' + VOLUME_TYPES[i];
                        props.remove((Object)property);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public Customizer getCustomizer(String volumeType) {
        if (VOLUME_TYPES[0].equals(volumeType) || VOLUME_TYPES[1].equals(volumeType) || VOLUME_TYPES[2].equals(volumeType)) {
            return new J2SEVolumeCustomizer(volumeType);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public static LibraryTypeProvider create() {
        return new J2SELibraryTypeProvider();
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation impl, EditableProperties props) {
        boolean modified = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            String propName = LIB_PREFIX + impl.getName() + '.' + VOLUME_TYPES[i];
            List roots = impl.getContent(VOLUME_TYPES[i]);
            if (roots == null) continue;
            StringBuffer propValue = new StringBuffer();
            boolean first = true;
            for (URL url : roots) {
                URI uri;
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                File f = null;
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo != null) {
                    f = FileUtil.toFile((FileObject)fo);
                } else if ("file".equals(url.getProtocol()) && (uri = URI.create(url.toExternalForm())) != null) {
                    f = new File(uri);
                }
                if (f != null) {
                    if (!first) {
                        propValue.append(File.pathSeparatorChar);
                    }
                    first = false;
                    f = FileUtil.normalizeFile((File)f);
                    propValue.append(f.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("J2SELibraryTypeProvider: Can not resolve URL: " + url);
            }
            String oldValue = props.getProperty(propName);
            String newValue = propValue.toString();
            if (newValue.equals(oldValue)) continue;
            props.setProperty(propName, newValue);
            modified = true;
        }
        return modified;
    }

    private static class J2SELibraryImpl
    implements LibraryImplementation {
        private String description;
        private Map<String, List<URL>> contents = new HashMap<String, List<URL>>();
        private String name;
        private String localizingBundle;
        private List<PropertyChangeListener> listeners;

        public J2SELibraryImpl() {
            for (String vtype : VOLUME_TYPES) {
                this.contents.put(vtype, Collections.emptyList());
            }
        }

        public String getType() {
            return J2SELibraryTypeProvider.LIBRARY_TYPE;
        }

        public void setName(String name) throws UnsupportedOperationException {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, this.name);
        }

        public String getName() {
            return this.name;
        }

        public List<URL> getContent(String contentType) throws IllegalArgumentException {
            List<URL> content = this.contents.get(contentType);
            if (content == null) {
                throw new IllegalArgumentException();
            }
            return Collections.unmodifiableList(content);
        }

        public void setContent(String contentType, List<URL> path) throws IllegalArgumentException {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            if (this.contents.keySet().contains(contentType)) {
                if (VOLUME_TYPES_REQUIRING_FOLDER.contains(contentType)) {
                    path = J2SELibraryImpl.check(path, this.name);
                }
            } else {
                throw new IllegalArgumentException("Volume '" + contentType + "' is not support by this library. The only acceptable values are: " + this.contents.keySet());
            }
            this.contents.put(contentType, new ArrayList<URL>(path));
            this.firePropertyChange("content", null, null);
        }

        /*
         * WARNING - void declaration
         */
        private static List<URL> check(List<? extends URL> resources, String libName) {
            ArrayList<URL> checkedResources = new ArrayList<URL>(resources.size());
            for (URL uRL : resources) {
                void var4_4;
                String surl = uRL.toString();
                if (!surl.endsWith("/")) {
                    try {
                        if (FileUtil.isArchiveFile((URL)uRL)) {
                            LOG.warning(String.format("Wrong Classpath entry %s in Library: %s", uRL.toString(), libName == null ? "" : libName));
                            URL uRL2 = FileUtil.getArchiveRoot((URL)uRL);
                        } else {
                            URL uRL3 = new URL(surl + '/');
                        }
                    }
                    catch (MalformedURLException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                checkedResources.add((URL)var4_4);
            }
            return checkedResources;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String text) {
            String oldDesc = this.description;
            this.description = text;
            this.firePropertyChange("description", oldDesc, this.description);
        }

        public String getLocalizingBundle() {
            return this.localizingBundle;
        }

        public void setLocalizingBundle(String resourceName) {
            this.localizingBundle = resourceName;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<PropertyChangeListener>();
            }
            this.listeners.add(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.name + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePropertyChange(String propName, Object oldValue, Object newValue) {
            ArrayList<PropertyChangeListener> ls;
            J2SELibraryImpl j2SELibraryImpl = this;
            synchronized (j2SELibraryImpl) {
                if (this.listeners == null) {
                    return;
                }
                ls = new ArrayList<PropertyChangeListener>(this.listeners);
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, propName, oldValue, newValue);
            for (PropertyChangeListener l : ls) {
                l.propertyChange(event);
            }
        }
    }
}

