/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public class JWSLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup baseContext) {
        if (this.hasJWS(baseContext)) {
            Project prj = (Project)baseContext.lookup(Project.class);
            J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)baseContext.lookup(J2SEPropertyEvaluator.class);
            return Lookups.singleton((Object)((Object)new JWSProjectOpenHook(prj, j2sepe.evaluator())));
        }
        return Lookup.EMPTY;
    }

    private boolean hasJWS(Lookup lkp) {
        J2SEPropertyEvaluator j2sePropEval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        return JWSProjectProperties.isTrue(j2sePropEval.evaluator().getProperty("jnlp.enabled"));
    }

    private static class JWSProjectOpenHook
    extends ProjectOpenedHook {
        private final Project project;
        private final PropertyEvaluator eval;

        private JWSProjectOpenHook(Project project, PropertyEvaluator eval) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            this.project = project;
            this.eval = eval;
        }

        protected void projectOpened() {
            try {
                JWSProjectProperties.updateWebStartJars(this.project, this.eval);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        protected void projectClosed() {
        }
    }
}

