/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class ConvertToRestAction
extends CookieAction {
    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 1) {
            Node node = nodeArray[0];
            Service service = (Service)node.getLookup().lookup(Service.class);
            FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                return false;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null || project.getLookup().lookup(RestSupport.class) == null) {
                return false;
            }
            if (service != null) {
                return !service.isUseProvider();
            }
        }
        return super.enable(nodeArray);
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{ConvertToRestCookie.class};
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodeArray) {
        Node node;
        ConvertToRestCookie convertToRestCookie;
        if (nodeArray.length == 1 && (convertToRestCookie = (ConvertToRestCookie)(node = nodeArray[0]).getCookie(ConvertToRestCookie.class)) != null) {
            convertToRestCookie.convertToRest();
            Object[] objectArray = new Object[]{"JAX-WS", "CONVERT TO REST"};
            LogUtils.logWsAction((Object[])objectArray);
        }
    }

    public String getName() {
        return NbBundle.getMessage(JaxWsRefreshAction.class, (String)"LBL_ConvertToRestAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

