/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.FileReferenceType;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WebUtils {
    static boolean UNIT_TESTING = false;
    static FileObject WEB_ROOT;

    public static FileObject resolve(FileObject source, String importedFileName) {
        FileReference ref = WebUtils.resolveToReference(source, importedFileName);
        return ref == null ? null : ref.target();
    }

    public static FileReference resolveToReference(FileObject source, String importedFileName) {
        try {
            URI u = new URI(importedFileName);
            File file = null;
            if (u.isAbsolute()) {
                if ("file".equals(u.getScheme())) {
                    try {
                        file = new File(u);
                    }
                    catch (IllegalArgumentException iae) {}
                }
            } else {
                file = new File(importedFileName);
            }
            if (file != null) {
                if (!WebUtils.isAbsolute(file, importedFileName)) {
                    File resolvedFile;
                    FileObject resolvedFileObject;
                    FileObject parent = source.getParent();
                    if (parent != null && (resolvedFileObject = parent.getFileObject(importedFileName)) != null && resolvedFileObject.isValid() && !resolvedFileObject.equals(parent) && (resolvedFile = FileUtil.toFile((FileObject)resolvedFileObject)) != null) {
                        FileObject resolvedFileObjectInCanonicalForm = FileUtil.toFileObject((File)resolvedFile.getCanonicalFile());
                        FileObject linkBase = WebUtils.findRelativeLinkBase(source, importedFileName);
                        FileReference ref = new FileReference(source, resolvedFileObjectInCanonicalForm, linkBase, importedFileName, FileReferenceType.RELATIVE);
                        return ref;
                    }
                } else {
                    FileObject resolved;
                    FileObject webRoot = ProjectWebRootQuery.getWebRoot(source);
                    if (UNIT_TESTING) {
                        webRoot = WEB_ROOT;
                    }
                    if (webRoot != null && (resolved = webRoot.getFileObject(file.getAbsolutePath())) != null && resolved.isValid()) {
                        FileReference ref = new FileReference(source, resolved, webRoot, importedFileName, FileReferenceType.ABSOLUTE);
                        return ref;
                    }
                }
            }
        }
        catch (URISyntaxException ex) {
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.INFO, "Cannot resolve import '" + importedFileName + "' from file " + source.getPath(), e);
        }
        return null;
    }

    private static boolean isAbsolute(File file, String link) {
        if (file.isAbsolute()) {
            return true;
        }
        return link.startsWith("/");
    }

    private static FileObject findRelativeLinkBase(FileObject source, String link) {
        assert (!source.isFolder()) : "The source file " + source.getPath() + " is not a folder!";
        assert (!link.startsWith("/")) : "The relative link " + link + "starts with a slash!";
        if (link.startsWith("./")) {
            link = link.substring(2);
        }
        StringTokenizer st = new StringTokenizer(link, "/");
        FileObject base = source.getParent();
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (part.equals("..")) {
                if ((base = base.getParent()) != null) continue;
                break;
            }
            return base;
        }
        return null;
    }

    public static ResultIterator getResultIterator(ResultIterator ri, String mimetype) {
        if (ri.getSnapshot().getMimeType().equals(mimetype)) {
            return ri;
        }
        for (Embedding e : ri.getEmbeddings()) {
            ResultIterator eri = ri.getResultIterator(e);
            if (e.getMimeType().equals(mimetype)) {
                return eri;
            }
            ResultIterator eeri = WebUtils.getResultIterator(eri, mimetype);
            if (eeri == null) continue;
            return eeri;
        }
        return null;
    }

    public static String unquotedValue(CharSequence value) {
        CharSequence unquoted = WebUtils.isValueQuoted(value) ? value.subSequence(1, value.length() - 1) : value;
        return ((Object)unquoted).toString();
    }

    public static boolean isValueQuoted(CharSequence value) {
        if (value.length() < 2) {
            return false;
        }
        return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
    }

    public static String toHexCode(Color color) {
        return '#' + WebUtils.toTwoDigitsHexCode(color.getRed()) + WebUtils.toTwoDigitsHexCode(color.getGreen()) + WebUtils.toTwoDigitsHexCode(color.getBlue());
    }

    private static String toTwoDigitsHexCode(int code) {
        StringBuilder sb = new StringBuilder(Integer.toHexString(code));
        if (sb.length() == 1) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String getRelativePath(FileObject source, FileObject target) {
        if (!source.isData()) {
            throw new IllegalArgumentException("The source file " + source.getPath() + " is not a data file!");
        }
        if (!target.isData()) {
            throw new IllegalArgumentException("The target file " + target.getPath() + " is not a data file!");
        }
        ArrayList<FileObject> targetPathFiles = new ArrayList<FileObject>();
        FileObject file = target;
        while ((file = file.getParent()) != null) {
            assert (file.isFolder());
            targetPathFiles.add(0, file);
        }
        FileObject common = null;
        file = source;
        StringBuilder link = new StringBuilder();
        while ((file = file.getParent()) != null) {
            if (targetPathFiles.contains(file)) {
                common = file;
                break;
            }
            link.append("../");
        }
        if (common == null) {
            return null;
        }
        int commonIndexInSourcePath = targetPathFiles.indexOf(common);
        assert (commonIndexInSourcePath >= 0);
        assert (targetPathFiles.size() > commonIndexInSourcePath);
        for (int i = commonIndexInSourcePath + 1; i < targetPathFiles.size(); ++i) {
            FileObject pathMember = (FileObject)targetPathFiles.get(i);
            link.append(pathMember.getNameExt());
            link.append('/');
        }
        link.append(target.getNameExt());
        return link.toString();
    }
}

