/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;

public class GrailsActionProvider
implements ActionProvider {
    public static final String COMMAND_GRAILS_SHELL = "grails-shell";
    public static final String COMMAND_COMPILE = "compile";
    public static final String COMMAND_UPGRADE = "upgrade";
    private static final Logger LOGGER = Logger.getLogger(GrailsActionProvider.class.getName());
    private static final String[] supportedActions = new String[]{"build", "run", "debug", "test", "clean", "delete", "grails-shell", "compile", "upgrade"};
    private final GrailsProject project;

    public GrailsActionProvider(GrailsProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        GrailsPlatform runtime = GrailsPlatform.getDefault();
        if (!runtime.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(runtime);
            return;
        }
        if ("run".equals(command)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction();
        } else if ("debug".equals(command)) {
            LifecycleManager.getDefault().saveAll();
            this.executeRunAction(true);
        } else if (COMMAND_GRAILS_SHELL.equals(command)) {
            this.executeSimpleAction("shell");
        } else if ("test".equals(command)) {
            this.executeSimpleAction("test-app");
        } else if ("clean".equals(command)) {
            this.executeSimpleAction("clean");
        } else if (COMMAND_COMPILE.equals(command)) {
            this.executeSimpleAction(COMMAND_COMPILE);
        } else if (COMMAND_UPGRADE.equals(command)) {
            this.executeSimpleAction(COMMAND_UPGRADE);
        } else if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        } else if ("build".equals(command)) {
            this.executeSimpleAction("war");
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return true;
    }

    private void executeRunAction() {
        this.executeRunAction(false);
    }

    private void executeRunAction(final boolean debug) {
        GrailsServerState serverState = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
        Process process = null;
        if (serverState != null && serverState.isRunning()) {
            if (!debug) {
                URL url = serverState.getRunningUrl();
                if (url != null) {
                    GrailsCommandSupport.showURL(url, debug, this.project);
                }
                return;
            }
            process = serverState.getProcess();
            if (process != null) {
                process.destroy();
            }
        }
        final Process oldProcess = process;
        Callable<Process> callable = new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                if (oldProcess != null) {
                    oldProcess.waitFor();
                }
                Callable inner = ExecutionSupport.getInstance().createRunApp(GrailsProjectConfig.forProject((Project)GrailsActionProvider.this.project), debug, new String[0]);
                Process process = (Process)inner.call();
                GrailsServerState serverState = (GrailsServerState)GrailsActionProvider.this.project.getLookup().lookup(GrailsServerState.class);
                if (serverState != null) {
                    serverState.setProcess(process);
                    serverState.setDebug(debug);
                }
                return process;
            }
        };
        ProjectInformation inf = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String displayName = inf.getDisplayName() + " (run-app)";
        ExecutionDescriptor descriptor = this.project.getCommandSupport().getRunDescriptor(debug);
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    private void executeSimpleAction(String command) {
        ProjectInformation inf = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String displayName = inf.getDisplayName() + " (" + command + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand(command, GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        ExecutionDescriptor descriptor = this.project.getCommandSupport().getDescriptor(command);
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }
}

