/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GrailsPluginsPanel
extends JPanel {
    private GrailsProject project;
    private GrailsPluginSupport pluginsManager;
    private boolean installedInitialized;
    private boolean installedModified;
    private boolean availablePluginsInitialized;
    private boolean availableModified;
    private List<GrailsPlugin> installedPluginsList = new ArrayList<GrailsPlugin>();
    private List<GrailsPlugin> availablePluginsList = new ArrayList<GrailsPlugin>();
    private final ExecutorService refreshExecutor = Executors.newCachedThreadPool();
    private JList availablePlugins;
    private JButton installButton;
    private JPanel installedPanel;
    private JList installedPlugins;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel newPluginPanel;
    private JButton pluginBrowseButton;
    private JLabel pluginLocationLabel;
    private JTextField pluginZipPath;
    private JTabbedPane pluginsPanel;
    private JButton reloadAvailableButton;
    private JButton reloadInstalledButton;
    private JButton uninstallButton;

    public GrailsPluginsPanel(Project project) {
        this.initComponents();
        this.project = (GrailsProject)project;
        this.pluginsManager = GrailsPluginSupport.forProject(this.project);
    }

    public void dispose() {
        this.refreshExecutor.shutdownNow();
    }

    private void refreshInstalled() {
        assert (SwingUtilities.isEventDispatchThread());
        DefaultListModel<GrailsPlugin> model = new DefaultListModel<GrailsPlugin>();
        this.reloadInstalledButton.setEnabled(false);
        this.installedPluginsList = this.pluginsManager.loadInstalledPlugins();
        for (GrailsPlugin plugin : this.installedPluginsList) {
            model.addElement(plugin);
        }
        this.installedPlugins.clearSelection();
        this.installedPlugins.setModel(model);
        this.installedPlugins.invalidate();
        this.installedPlugins.repaint();
        this.reloadInstalledButton.setEnabled(true);
    }

    private void refreshAvailable() {
        assert (SwingUtilities.isEventDispatchThread());
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<GrailsPlugin> plugins;
                boolean interrupted = false;
                try {
                    plugins = GrailsPluginsPanel.this.pluginsManager.refreshAvailablePlugins();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    plugins = Collections.emptyList();
                }
                try {
                    final List<GrailsPlugin> pluginsToLoad = plugins;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GrailsPluginsPanel.this.availablePluginsList = new ArrayList(pluginsToLoad);
                            DefaultListModel<GrailsPlugin> model = new DefaultListModel<GrailsPlugin>();
                            for (GrailsPlugin plugin : GrailsPluginsPanel.this.availablePluginsList) {
                                if (GrailsPluginsPanel.this.installedPluginsList.contains(plugin)) continue;
                                model.addElement(plugin);
                            }
                            GrailsPluginsPanel.this.availablePlugins.clearSelection();
                            GrailsPluginsPanel.this.availablePlugins.setModel(model);
                            GrailsPluginsPanel.this.availablePlugins.invalidate();
                            GrailsPluginsPanel.this.availablePlugins.repaint();
                            GrailsPluginsPanel.this.reloadAvailableButton.setEnabled(true);
                        }
                    });
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.reloadAvailableButton.setEnabled(false);
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"FetchingPlugins"));
        this.availablePlugins.setModel(model);
        this.refreshExecutor.submit(runner);
    }

    private void uninstallPlugins() {
        Object[] selected = this.installedPlugins.getSelectedValues();
        this.pluginsManager.uninstallPlugins(this.toPluginCollection(selected));
        this.refreshInstalled();
        this.availableModified = true;
    }

    private void installPlugins() {
        GrailsPlugin plugin;
        this.installButton.setEnabled(false);
        Object[] selected = this.availablePlugins.getSelectedValues();
        Collection<GrailsPlugin> selectedColl = this.toPluginCollection(selected);
        if (this.pluginZipPath.getText() != null && this.pluginZipPath.getText().trim().length() > 0 && (plugin = this.pluginsManager.getPluginFromZipFile(this.pluginZipPath.getText())) != null && !selectedColl.contains(plugin) && !this.installedPluginsList.contains(plugin)) {
            selectedColl.add(plugin);
        }
        this.availableModified = this.pluginsManager.installPlugins(selectedColl);
        this.refreshInstalled();
        if (this.availableModified) {
            this.pluginsPanel.setSelectedComponent(this.installedPanel);
            this.pluginsPanel.invalidate();
            this.pluginsPanel.repaint();
        }
        this.installButton.setEnabled(true);
    }

    private Collection<GrailsPlugin> toPluginCollection(Object[] selected) {
        ArrayList<GrailsPlugin> coll = new ArrayList<GrailsPlugin>();
        if (selected != null && selected.length > 0) {
            for (Object obj : selected) {
                coll.add((GrailsPlugin)obj);
            }
        }
        return coll;
    }

    private void initComponents() {
        this.pluginsPanel = new JTabbedPane();
        this.installedPanel = new JPanel();
        this.reloadInstalledButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.installedPlugins = new JList();
        this.uninstallButton = new JButton();
        this.newPluginPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.availablePlugins = new JList();
        this.installButton = new JButton();
        this.reloadAvailableButton = new JButton();
        this.pluginLocationLabel = new JLabel();
        this.pluginZipPath = new JTextField();
        this.pluginBrowseButton = new JButton();
        this.installedPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GrailsPluginsPanel.this.installedPanelComponentShown(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.setActionCommand(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsPluginsPanel.this.reloadInstalledButtonActionPerformed(evt);
            }
        });
        this.installedPlugins.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return GrailsPluginsPanel.this.installedPluginsList.size();
            }

            @Override
            public Object getElementAt(int arg0) {
                return GrailsPluginsPanel.this.installedPluginsList.get(arg0);
            }
        });
        this.installedPlugins.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GrailsPluginsPanel.this.installedPluginsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.installedPlugins);
        this.installedPlugins.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.installedPlugins.accessibleName"));
        this.installedPlugins.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.installedPlugins.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsPluginsPanel.this.uninstallButtonActionPerformed(evt);
            }
        });
        GroupLayout installedPanelLayout = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)installedPanelLayout);
        installedPanelLayout.setHorizontalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((Component)this.reloadInstalledButton).add((Component)this.uninstallButton).add((Component)this.jScrollPane1, -1, 660, Short.MAX_VALUE)).addContainerGap()));
        installedPanelLayout.setVerticalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.reloadInstalledButton).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 312, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.uninstallButton).addContainerGap()));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadInstalledButton.accessibleName"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadInstalledButton.accessibleDescription"));
        this.pluginsPanel.addTab(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.installed"), this.installedPanel);
        this.newPluginPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GrailsPluginsPanel.this.newPluginPanelComponentShown(evt);
            }
        });
        this.availablePlugins.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return GrailsPluginsPanel.this.availablePluginsList.size();
            }

            @Override
            public Object getElementAt(int arg0) {
                return GrailsPluginsPanel.this.availablePluginsList.get(arg0);
            }
        });
        this.availablePlugins.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GrailsPluginsPanel.this.availablePluginsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.availablePlugins);
        this.availablePlugins.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.availablePlugins.accessibleName"));
        this.availablePlugins.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.availablePlugins.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsPluginsPanel.this.installButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reloadAvailableButton, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadAvailableButton.text"));
        this.reloadAvailableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsPluginsPanel.this.reloadAvailableButtonActionPerformed(evt);
            }
        });
        this.pluginLocationLabel.setLabelFor(this.pluginZipPath);
        Mnemonics.setLocalizedText((JLabel)this.pluginLocationLabel, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginLocationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.pluginBrowseButton, (String)NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginBrowseButton.text"));
        this.pluginBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsPluginsPanel.this.pluginBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout newPluginPanelLayout = new GroupLayout((Container)this.newPluginPanel);
        this.newPluginPanel.setLayout((LayoutManager)newPluginPanelLayout);
        newPluginPanelLayout.setHorizontalGroup((GroupLayout.Group)newPluginPanelLayout.createParallelGroup(1).add((GroupLayout.Group)newPluginPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)newPluginPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 660, Short.MAX_VALUE).add((GroupLayout.Group)newPluginPanelLayout.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.pluginLocationLabel).addPreferredGap(0).add((Component)this.pluginZipPath, -1, 360, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pluginBrowseButton)).add((Component)this.reloadAvailableButton)).addContainerGap()));
        newPluginPanelLayout.setVerticalGroup((GroupLayout.Group)newPluginPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)newPluginPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.reloadAvailableButton).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 305, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)newPluginPanelLayout.createParallelGroup(3).add((Component)this.installButton).add((Component)this.pluginBrowseButton).add((Component)this.pluginLocationLabel).add((Component)this.pluginZipPath, -2, -1, -2)).addContainerGap()));
        this.reloadAvailableButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadAvailableButton.accessibleName"));
        this.reloadAvailableButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.reloadAvailableButton.accessibleDescription"));
        this.pluginZipPath.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginZipPath.accessibleName"));
        this.pluginZipPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginZipPath.accessibleDescription"));
        this.pluginBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginBrowseButton.accessibleName"));
        this.pluginBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginBrowseButton.accessibleDescription"));
        this.pluginsPanel.addTab(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.newPlugins"), this.newPluginPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pluginsPanel, -1, 721, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pluginsPanel, -1, 468, Short.MAX_VALUE).addContainerGap()));
        this.pluginsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginsPanel.accessibleName"));
        this.pluginsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.pluginsPanel.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"GrailsPluginPanel.accessibleDescription"));
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        this.uninstallPlugins();
    }

    private void reloadAvailableButtonActionPerformed(ActionEvent evt) {
        this.refreshAvailable();
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent evt) {
        this.refreshInstalled();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        this.installPlugins();
    }

    private void installedPluginsValueChanged(ListSelectionEvent evt) {
        this.uninstallButton.setEnabled(this.installedPlugins.getSelectedIndices() != null && this.installedPlugins.getSelectedIndices().length > 0);
    }

    private void availablePluginsValueChanged(ListSelectionEvent evt) {
        this.installButton.setEnabled(this.availablePlugins.getSelectedIndices() != null && this.availablePlugins.getSelectedIndices().length > 0);
        if (this.availablePlugins.getSelectedIndices().length == 1 && this.availablePlugins.getSelectedValue().equals(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"FetchingPlugins"))) {
            this.installButton.setEnabled(false);
        }
    }

    private void installedPanelComponentShown(ComponentEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.installedInitialized) {
            this.installedInitialized = true;
            this.installedPlugins.setSelectionMode(2);
            this.installedModified = true;
        } else {
            this.installedModified = false;
        }
        if (this.installedModified) {
            this.refreshInstalled();
        }
    }

    private void newPluginPanelComponentShown(ComponentEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.availablePluginsInitialized) {
            this.availablePluginsInitialized = true;
            this.availablePlugins.setSelectionMode(2);
            this.availableModified = true;
        }
        if (this.availableModified) {
            this.refreshAvailable();
            this.availableModified = false;
        }
    }

    private void pluginBrowseButtonActionPerformed(ActionEvent evt) {
        File current = new File(this.pluginZipPath.getText());
        JFileChooser chooser = new JFileChooser(current);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getPath().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "*.zip";
            }
        };
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(fileFilter);
        chooser.setDialogTitle(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"TITLE_BrowsePluginLocation"));
        chooser.setApproveButtonText(NbBundle.getMessage(GrailsPluginsPanel.class, (String)"LBL_BrowsePluginLocation_OK_Button"));
        if (chooser.showOpenDialog(null) == 0) {
            this.pluginZipPath.setText(chooser.getSelectedFile().getAbsolutePath());
            this.installButton.setEnabled(true);
        }
    }
}

