/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Image;
import java.util.EventListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.editor.pub.J2MEDataObject;
import org.netbeans.modules.mobility.project.MIDletsCacheHelper;
import org.netbeans.modules.mobility.project.MIDletsCacheListener;
import org.openide.filesystems.FileObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public class J2MENode
extends FilterNode
implements MIDletsCacheListener {
    public static final Image entryPointImage = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/editor/resources/entrypoint.gif", (boolean)true);
    private final J2MEDataObject dao;
    private final Node node;
    private MIDletsCacheListener listener;

    public J2MENode(J2MEDataObject dao, Node node) {
        super(node);
        this.node = node;
        this.dao = dao;
    }

    public Image createIcon(int type) {
        ClassPath cp;
        Image original = this.node.getIcon(type);
        Project p = FileOwnerQuery.getOwner((FileObject)this.dao.getPrimaryFile());
        if (p == null) {
            return original;
        }
        MIDletsCacheHelper cache = (MIDletsCacheHelper)p.getLookup().lookup(MIDletsCacheHelper.class);
        if (cache == null) {
            return original;
        }
        FileObject file = this.dao.getPrimaryFile();
        if (file == null) {
            return original;
        }
        if (this.listener == null) {
            this.listener = (MIDletsCacheListener)WeakListeners.create(MIDletsCacheListener.class, (EventListener)((Object)this), (Object)cache);
            cache.addMIDletsCacheListener(this.listener);
        }
        if ((cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source")) == null) {
            return original;
        }
        String midlet = cp.getResourceName(file, '.', false);
        if (cache.contains(midlet) && original != null && entryPointImage != null) {
            original = ImageUtilities.mergeImages((Image)original, (Image)entryPointImage, (int)0, (int)0);
        }
        return original;
    }

    public Image getIcon(int type) {
        return this.createIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void cacheChanged() {
        this.fireIconChange();
        this.fireOpenedIconChange();
    }
}

