/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ProjectCustomizerProvider
implements CustomizerProvider {
    private final FreeformProject project;
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-ant-freeform/Customizer";
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();

    public ProjectCustomizerProvider(FreeformProject project) {
        this.project = project;
    }

    public void showCustomizer() {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        InstanceContent ic = new InstanceContent();
        AbstractLookup context = new AbstractLookup((AbstractLookup.Content)ic);
        ic.add((Object)this.project);
        ic.add(this.project.getLookup().lookup(ProjectAccessor.class));
        ic.add(this.project.getLookup().lookup(AuxiliaryConfiguration.class));
        ic.add((Object)ic);
        OptionListener listener = new OptionListener(this.project);
        dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)context, null, (ActionListener)listener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(ProjectCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }
}

