/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.nodes;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.junit.nodes.JUnitTestMethodNode;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;

final class OutputUtils {
    static final Action[] NO_ACTIONS = new Action[0];
    static final String CALLSTACK_LINE_PREFIX = "at ";
    static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    private static final String JAVA_ID_START_REGEX = "\\p{javaJavaIdentifierStart}";
    private static final String JAVA_ID_PART_REGEX = "\\p{javaJavaIdentifierPart}";
    public static final String JAVA_ID_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*";
    public static final String JAVA_ID_REGEX_FULL = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*";
    static final String LOCATION_IN_FILE_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?";
    static final Pattern LOC_PATTERN = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?");

    private OutputUtils() {
    }

    static String specialTrim(String string) {
        char c;
        int lead;
        int len = string.length();
        if (len == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        for (lead = 0; lead < len && ((c = chars[lead]) == ' ' || c == '\t'); ++lead) {
        }
        if (lead == len) {
            return string.substring(len);
        }
        int trail = len;
        while ((c = chars[--trail]) == ' ' || c == '\t') {
        }
        if (lead == 0 && trail == len - 1) {
            return string;
        }
        return string.substring(lead, trail + 1);
    }

    static void openTestsuite(TestsuiteNode node) {
        Node child;
        Children childrens = node.getChildren();
        if (childrens != null && (child = childrens.getNodeAt(0)) != null && child instanceof JUnitTestMethodNode) {
            FileObject fo = ((JUnitTestMethodNode)child).getTestcaseFileObject();
            OutputUtils.openFile(fo, 1);
        }
    }

    static void openCallstackFrame(Node node, String frameInfo) {
        String[] st;
        JUnitTestMethodNode methodNode = OutputUtils.getTestMethodNode(node);
        LineConvertors.FileLocator locator = methodNode.getTestcase().getSession().getFileLocator();
        if (locator == null) {
            return;
        }
        int[] lineNumStorage = new int[1];
        FileObject file = OutputUtils.getFile(frameInfo, lineNumStorage, locator);
        if (file == null && methodNode.getTestcase().getTrouble() != null && (st = methodNode.getTestcase().getTrouble().getStackTrace()) != null && st.length > 0) {
            file = OutputUtils.getFile(st[st.length - 1], lineNumStorage, locator);
        }
        OutputUtils.openFile(file, lineNumStorage[0]);
    }

    static String determineStackFrame(Trouble trouble) {
        String[] frames = trouble.getStackTrace();
        return frames != null && frames.length != 0 ? frames[frames.length - 1] : null;
    }

    private static JUnitTestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof JUnitTestMethodNode)) {
            node = node.getParentNode();
        }
        return (JUnitTestMethodNode)node;
    }

    private static FileObject getFile(String callstackLine, int[] lineNumStorage, LineConvertors.FileLocator locator) {
        String ending;
        String slashName;
        int lastSlashIndex;
        int lineNum;
        String fileName;
        String clsName;
        block15: {
            String methodName;
            int bracketIndex;
            String line = OutputUtils.specialTrim(callstackLine);
            if (line.startsWith(CALLSTACK_LINE_PREFIX_CATCH)) {
                line = line.substring(CALLSTACK_LINE_PREFIX_CATCH.length());
            }
            if (line.startsWith(CALLSTACK_LINE_PREFIX)) {
                line = line.substring(CALLSTACK_LINE_PREFIX.length());
            }
            String beforeBrackets = (bracketIndex = line.indexOf(40)) == -1 ? line : line.substring(0, bracketIndex).trim();
            int endBracketIndex = line.lastIndexOf(41);
            String inBrackets = bracketIndex == -1 || endBracketIndex < bracketIndex ? (String)null : line.substring(bracketIndex + 1, endBracketIndex);
            int lastDotIndex = beforeBrackets.lastIndexOf(46);
            if (lastDotIndex != -1) {
                clsName = beforeBrackets.substring(0, lastDotIndex);
                methodName = beforeBrackets.substring(lastDotIndex + 1);
            } else {
                clsName = beforeBrackets;
                methodName = "";
            }
            fileName = null;
            lineNum = -1;
            if (inBrackets != null && LOC_PATTERN.matcher(inBrackets).matches()) {
                int ddotIndex = inBrackets.lastIndexOf(58);
                if (ddotIndex == -1) {
                    fileName = inBrackets;
                } else {
                    fileName = inBrackets.substring(0, ddotIndex);
                    try {
                        lineNum = Integer.parseInt(inBrackets.substring(ddotIndex + 1));
                        if (lineNum <= 0) {
                            lineNum = 1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block15;
                        throw new AssertionError();
                    }
                }
            }
        }
        String clsNameSlash = clsName.replace('.', '/');
        if (fileName == null) {
            lastSlashIndex = clsNameSlash.length();
            slashName = clsNameSlash;
            ending = ".java";
        } else {
            lastSlashIndex = clsNameSlash.lastIndexOf(47);
            slashName = lastSlashIndex != -1 ? clsNameSlash.substring(0, lastSlashIndex) : clsNameSlash;
            ending = '/' + fileName;
        }
        String thePath = slashName + ending;
        FileObject file = locator.find(thePath);
        while (file == null && lastSlashIndex != -1) {
            thePath = (slashName = slashName.substring(0, lastSlashIndex)) + ending;
            file = locator.find(thePath);
            if (file != null) continue;
            lastSlashIndex = slashName.lastIndexOf(47, lastSlashIndex - 1);
        }
        if (file == null && fileName != null) {
            thePath = fileName;
            file = locator.find(thePath);
        }
        if (file == null) {
            lineNum = -1;
        }
        lineNumStorage[0] = lineNum;
        return file;
    }

    public static void openFile(FileObject file, int lineNum) {
        block8: {
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (lineNum == -1) {
                        ed.open();
                        break block8;
                    }
                    ed.openDocument();
                    try {
                        Line l = ed.getLineSet().getOriginal(lineNum - 1);
                        if (!l.isDeleted()) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                        break block8;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block8;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

