/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    static Node getRootNode(final FileObject fileObject) throws IOException {
        final Node[] node = new Node[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Node document = null;
                if (fileObject != null) {
                    FileLock lock = null;
                    try {
                        lock = fileObject.lock();
                        document = XMLUtil.getXMLDocument(fileObject.getInputStream());
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                node[0] = document != null ? document.getFirstChild() : null;
            }
        });
        return node[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getXMLDocument(InputStream is) throws IOException {
        Document doc = null;
        try {
            doc = org.openide.xml.XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void warning(SAXParseException e) {
                    Debug.warning((Object[])new Object[]{e});
                }
            }, null);
        }
        catch (SAXException e) {
            try {
                throw Debug.error((Object[])new Object[]{e});
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw Debug.error((Object[])new Object[]{e2});
                }
            }
        }
        try {
            is.close();
            return doc;
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    static Node[] getChildren(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }

    static List<Node> getChildren(Node node, String nodeName) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!nodeName.equals(child.getNodeName())) continue;
            children.add(child);
        }
        return children;
    }

    static Node getChild(Node node, String nodeName) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!nodeName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Debug.warning((Object[])new Object[]{e});
        }
        return null;
    }
}

