/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class RemoteIndexTransferListener
implements TransferListener,
Cancellable {
    private ProgressHandle handle;
    private RepositoryInfo info;
    private int lastunit;
    private int units;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private static Map<Thread, Integer> transfers = new HashMap<Thread, Integer>();
    private static final Object TRANSFERS_LOCK = new Object();

    public RemoteIndexTransferListener(RepositoryInfo info) {
        this.info = info;
        Cancellation.register(this);
    }

    public void transferInitiated(TransferEvent arg0) {
    }

    public void transferStarted(TransferEvent arg0) {
        long contentLength = arg0.getResource().getContentLength();
        this.close();
        this.handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer", (Object)this.info.getName()), (Cancellable)this);
        this.units = (int)contentLength / 1024;
        this.handle.start(this.units);
    }

    public boolean cancel() {
        return this.canceled.compareAndSet(false, true);
    }

    public void transferProgress(TransferEvent arg0, byte[] arg1, int arg2) {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
        int work = arg2 / 1024;
        if (this.handle != null) {
            this.handle.progress(arg0.getResource().getName(), Math.min(this.units, this.lastunit += work));
        }
    }

    public void transferCompleted(TransferEvent arg0) {
        this.close();
    }

    public void transferError(TransferEvent arg0) {
    }

    public void debug(String arg0) {
        if (this.canceled.get()) {
            throw new Cancellation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            transfers.put(t, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromActive(Thread t) {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            Integer count = transfers.get(t);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                transfers.remove(t);
            } else {
                count = count - 1;
                transfers.put(t, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Thread> getActiveTransfersOrScans() {
        Object object = TRANSFERS_LOCK;
        synchronized (object) {
            return transfers.keySet();
        }
    }

    void close() {
        if (this.handle != null) {
            this.handle.finish();
        }
    }
}

