/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector;

import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorManagerView;
import org.netbeans.modules.vmd.inspector.InspectorWrapperTree;
import org.openide.util.WeakSet;

public final class InspectorRegistry {
    private static WeakHashMap<DesignDocument, InspectorRegistry> registryMap;
    private Collection<DesignComponent> components = new WeakSet();

    public static InspectorRegistry getInstance(DesignDocument document) {
        if (registryMap == null) {
            registryMap = new WeakHashMap();
        }
        if (registryMap.get(document) == null) {
            registryMap.put(document, new InspectorRegistry());
        }
        return registryMap.get(document);
    }

    private InspectorRegistry() {
    }

    public void addComponent(DesignComponent component) {
        this.components.add(component);
    }

    public Collection<DesignComponent> getComponentsToUpdate() {
        if (this.components == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this.components);
    }

    public void cleanUpRegistry() {
        if (!Debug.isFriend(InspectorManagerView.class)) {
            throw new IllegalStateException("This method is only accessible from class InspectorWrapperTree");
        }
        if (this.components != null) {
            this.components.clear();
        }
    }

    public void remove(Collection<DesignComponent> components) {
        if (!Debug.isFriend(InspectorWrapperTree.class)) {
            throw new IllegalStateException("This method is only accessible from class InspectorWrapperTree");
        }
        if (this.components != null && this.components.size() > 0 && components != null && components.size() == 0) {
            this.components.removeAll(components);
        }
    }
}

