/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.xml.sax.SAXParseException;

public class XMLDisplayer {
    private final String FORMAT = "{0} [{1}] {2}";
    private InputOutput xmlIO;
    private OutputWriter ow = null;

    public XMLDisplayer() {
        this(NbBundle.getMessage(XMLDisplayer.class, (String)"TITLE_XML_check_window"));
    }

    protected XMLDisplayer(String tab) {
        this.initInputOutput(tab);
    }

    public void display(String msg) {
        this.ow.println(msg);
    }

    public void display(String msg, boolean takeFocus) {
        if (takeFocus) {
            boolean wasFocusTaken = this.xmlIO.isFocusTaken();
            this.xmlIO.select();
            this.xmlIO.setFocusTaken(true);
            this.ow.println(msg);
            this.xmlIO.setFocusTaken(wasFocusTaken);
        } else {
            this.ow.println(msg);
        }
    }

    public final void moveToFront() {
        boolean wasFocusTaken = this.xmlIO.isFocusTaken();
        this.xmlIO.select();
        this.xmlIO.setFocusTaken(true);
        this.ow.write("\r");
        this.xmlIO.setFocusTaken(wasFocusTaken);
    }

    public void display(DataObject dobj, SAXParseException sex) {
        DataObject actualDataObject = null;
        try {
            FileObject fo = URLMapper.findFileObject((URL)new URL(sex.getSystemId()));
            if (fo != null) {
                actualDataObject = DataObject.find((FileObject)fo);
            }
        }
        catch (MalformedURLException ex) {
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        String external = "";
        if (actualDataObject == null) {
            external = sex.getSystemId();
        }
        this.display(actualDataObject, sex.getMessage(), external, new Integer(sex.getLineNumber()), new Integer(sex.getColumnNumber()));
    }

    protected void display(DataObject dobj, String message, String ext, Integer line, Integer col) {
        Object[] args = new Object[]{message, line, ext};
        String text = MessageFormat.format("{0} [{1}] {2}", args);
        try {
            if (dobj == null) {
                throw new IOException("catchIt");
            }
            IOCtl ec = new IOCtl(dobj, Math.max(line - 1, 0), Math.max(col - 1, 0));
            this.ow.println(text, (OutputListener)ec);
        }
        catch (IOException catchIt) {
            this.ow.println(text);
        }
    }

    private void initInputOutput(String name) {
        if (this.ow != null) {
            return;
        }
        this.xmlIO = IOProvider.getDefault().getIO(name, false);
        this.xmlIO.setFocusTaken(false);
        this.ow = this.xmlIO.getOut();
        try {
            this.ow.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final class IOCtl
    implements OutputListener {
        Line xline;
        int column;

        public IOCtl(DataObject data, int line, int column) throws IOException {
            this.column = column;
            LineCookie cookie = (LineCookie)data.getCookie(LineCookie.class);
            if (cookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = cookie.getLineSet().getOriginal(line);
        }

        public void outputLineSelected(OutputEvent ev) {
            try {
                this.xline.markError();
                this.xline.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.column);
            }
            catch (IndexOutOfBoundsException ex) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineAction(OutputEvent ev) {
            try {
                this.xline.markError();
                this.xline.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column);
            }
            catch (IndexOutOfBoundsException ex) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            try {
                this.xline.unmarkError();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

