/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.BackgroundModel;
import org.netbeans.modules.css.visual.model.BackgroundPositionData;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.model.Utils;
import org.netbeans.modules.css.visual.ui.BackgroundImageUrlDialog;
import org.netbeans.modules.css.visual.ui.ColorSelectionField;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class BackgroundStyleEditor
extends StyleEditor {
    ColorSelectionField colorField;
    BackgroundPositionData bgPositionData;
    private JButton browseButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel colorSelectionPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JComboBox horizontalPosComboBox;
    private JLabel horizontalPosLabel;
    private JComboBox horizontalUnitComboBox;
    private JTextField imageFileField;
    private JLabel imageScrollLabel;
    private JLabel imageTileLabel;
    private JLabel lineHeightLabel;
    private JComboBox repeatComboBox;
    private JComboBox scrollComboBox;
    private JComboBox verticalPosComboBox;
    private JLabel verticalPosLabel;
    private JComboBox verticalUnitComboBox;

    public BackgroundStyleEditor() {
        super("backgroundStyleEditor", NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_EDITOR_DISPNAME"));
    }

    @Override
    protected void lazyInitializePanel() {
        this.colorField = new ColorSelectionField();
        this.bgPositionData = new BackgroundPositionData();
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BackgroundStyleEditor.this.setBackgroundColor();
            }
        });
        this.initialize();
        final JTextField horizontalPosComboBoxEditor = (JTextField)this.horizontalPosComboBox.getEditor().getEditorComponent();
        horizontalPosComboBoxEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BackgroundStyleEditor.this.horizontalUnitComboBox.setEnabled(Utils.isInteger(horizontalPosComboBoxEditor.getText()));
                        BackgroundStyleEditor.this.enablePositionCombo();
                    }
                });
            }
        });
        final JTextField verticalPosComboBoxEditor = (JTextField)this.verticalPosComboBox.getEditor().getEditorComponent();
        verticalPosComboBoxEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BackgroundStyleEditor.this.verticalUnitComboBox.setEnabled(Utils.isInteger(verticalPosComboBoxEditor.getText()));
                    }
                });
            }
        });
    }

    protected void initialize() {
        BackgroundModel backgroundModel = new BackgroundModel();
        DefaultComboBoxModel backgroundRepeatList = backgroundModel.getBackgroundRepeatList();
        this.repeatComboBox.setModel(backgroundRepeatList);
        DefaultComboBoxModel backgroundScrollList = backgroundModel.getBackgroundScrollList();
        this.scrollComboBox.setModel(backgroundScrollList);
        this.horizontalPosComboBox.setModel(backgroundModel.getBackgroundPositionList());
        this.verticalPosComboBox.setModel(backgroundModel.getBackgroundPositionList());
        this.horizontalUnitComboBox.setModel(backgroundModel.getBackgroundPositionUnitList());
        this.verticalUnitComboBox.setModel(backgroundModel.getBackgroundPositionUnitList());
    }

    @Override
    protected void setCssPropertyValues(CssRuleContent cssStyleData) {
        this.removeCssPropertyChangeListener();
        String backGroundColor = cssStyleData.getProperty("background-color");
        if (backGroundColor != null) {
            this.colorField.setColorString(backGroundColor);
        } else {
            this.colorField.setColorString(Utils.NOT_SET);
        }
        String backGroundImage = cssStyleData.getProperty("background-image");
        if (backGroundImage != null && !backGroundImage.trim().equals("")) {
            int openBracketPos = backGroundImage.indexOf("(");
            int endBracketPos = backGroundImage.indexOf(")");
            if (openBracketPos >= 0 && endBracketPos >= 0) {
                String imgString = backGroundImage.substring(openBracketPos + 1, endBracketPos);
                this.imageFileField.setText(imgString);
            } else {
                this.imageFileField.setText(backGroundImage);
            }
        } else {
            this.imageFileField.setText(Utils.NOT_SET);
        }
        String backGroundRepeat = cssStyleData.getProperty("background-repeat");
        if (backGroundRepeat != null) {
            this.repeatComboBox.setSelectedItem(backGroundRepeat);
        } else {
            this.repeatComboBox.setSelectedIndex(0);
        }
        String backGroundScroll = cssStyleData.getProperty("background-attachment");
        if (backGroundScroll != null) {
            this.scrollComboBox.setSelectedItem(backGroundScroll);
        } else {
            this.scrollComboBox.setSelectedIndex(0);
        }
        String backgroundPosition = cssStyleData.getProperty("background-position");
        if (backgroundPosition != null) {
            this.bgPositionData.setBackgroundPosition(backgroundPosition);
            this.horizontalPosComboBox.setSelectedItem(this.bgPositionData.getHorizontalValue());
            this.horizontalUnitComboBox.setSelectedItem(this.bgPositionData.getHorizontalUnit());
            this.verticalPosComboBox.setSelectedItem(this.bgPositionData.getVerticalValue());
            this.verticalUnitComboBox.setSelectedItem(this.bgPositionData.getVerticalUnit());
        } else {
            this.horizontalPosComboBox.setSelectedIndex(0);
            this.verticalPosComboBox.setSelectedIndex(0);
        }
        this.setCssPropertyChangeListener(cssStyleData);
    }

    private void initComponents() {
        this.colorPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.browseButton = new JButton();
        this.imageFileField = new JTextField();
        this.lineHeightLabel = new JLabel();
        this.imageTileLabel = new JLabel();
        this.imageScrollLabel = new JLabel();
        this.scrollComboBox = new JComboBox();
        this.repeatComboBox = new JComboBox();
        this.horizontalPosLabel = new JLabel();
        this.verticalPosLabel = new JLabel();
        this.horizontalPosComboBox = new JComboBox();
        this.verticalPosComboBox = new JComboBox();
        this.horizontalUnitComboBox = new JComboBox();
        this.verticalUnitComboBox = new JComboBox();
        this.colorSelectionPanel = new JPanel();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_COLOR").charAt(0));
        this.colorLabel.setLabelFor(this.colorPanel);
        this.colorLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_COLOR"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.colorPanel.add((Component)this.colorLabel, gridBagConstraints);
        this.browseButton.setText("...");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.colorPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(null);
        this.browseButton.getAccessibleContext().setAccessibleDescription(null);
        this.imageFileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackgroundStyleEditor.this.imageFileFieldActionPerformed(evt);
            }
        });
        this.imageFileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BackgroundStyleEditor.this.imageFileFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.colorPanel.add((Component)this.imageFileField, gridBagConstraints);
        this.imageFileField.getAccessibleContext().setAccessibleName(null);
        this.imageFileField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_IMG_TEXTFIELD_ACCESS_DESC"));
        this.lineHeightLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_IMAGE").charAt(0));
        this.lineHeightLabel.setLabelFor(this.imageFileField);
        this.lineHeightLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_IMAGE"));
        this.lineHeightLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.lineHeightLabel, gridBagConstraints);
        this.imageTileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUNDTILE").charAt(0));
        this.imageTileLabel.setLabelFor(this.repeatComboBox);
        this.imageTileLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUNDTILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageTileLabel, gridBagConstraints);
        this.imageScrollLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_SCROLL").charAt(0));
        this.imageScrollLabel.setLabelFor(this.scrollComboBox);
        this.imageScrollLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_SCROLL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageScrollLabel, gridBagConstraints);
        this.scrollComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.scrollComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.scrollComboBox, gridBagConstraints);
        this.scrollComboBox.getAccessibleContext().setAccessibleName(null);
        this.scrollComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.repeatComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.repeatComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.repeatComboBox, gridBagConstraints);
        this.repeatComboBox.getAccessibleContext().setAccessibleName(null);
        this.repeatComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.horizontalPosLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BG_HORIZONTAL_POS").charAt(0));
        this.horizontalPosLabel.setLabelFor(this.horizontalPosComboBox);
        this.horizontalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_HORIZONTAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.horizontalPosLabel, gridBagConstraints);
        this.verticalPosLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BG_VERTICAL_POS").charAt(0));
        this.verticalPosLabel.setLabelFor(this.verticalPosComboBox);
        this.verticalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_VERTICAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.verticalPosLabel, gridBagConstraints);
        this.horizontalPosComboBox.setEditable(true);
        this.horizontalPosComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.horizontalPosComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.horizontalPosComboBox, gridBagConstraints);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleName(null);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.verticalPosComboBox.setEditable(true);
        this.verticalPosComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.verticalPosComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.verticalPosComboBox, gridBagConstraints);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleName(null);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.horizontalUnitComboBox.setEnabled(false);
        this.horizontalUnitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.horizontalUnitComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.horizontalUnitComboBox, gridBagConstraints);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleName(null);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.verticalUnitComboBox.setEnabled(false);
        this.verticalUnitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackgroundStyleEditor.this.verticalUnitComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.verticalUnitComboBox, gridBagConstraints);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleName(null);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.colorPanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.add((Component)this.colorPanel, "North");
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.errorPanel.setLayout(new BorderLayout());
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorPanel.add((Component)this.errorLabel, "North");
        this.add((Component)this.errorPanel, "Center");
    }

    private void verticalUnitComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setVerticalUnit((String)this.verticalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalUnitComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setHorizontalUnit((String)this.horizontalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalPosComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void scrollComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBackgroundAttachment();
        }
    }

    private void repeatComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBackgroundRepeat();
        }
    }

    private void imageFileFieldFocusLost(FocusEvent evt) {
        this.setBackgroundImage();
    }

    private void imageFileFieldActionPerformed(ActionEvent evt) {
        this.setBackgroundImage();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        BackgroundImageUrlDialog imageUrlDialog = new BackgroundImageUrlDialog(this.content().base());
        if (imageUrlDialog.show(this)) {
            this.imageFileField.setText(imageUrlDialog.getImageUrl());
        }
        this.setBackgroundImage();
    }

    private void setBackgroundColor() {
        PropertyData backgroundColorData = new PropertyData();
        backgroundColorData.setValue(this.colorField.getColorString());
        this.cssPropertyChangeSupport().firePropertyChange("background-color", null, backgroundColorData.toString());
    }

    private void setBackgroundImage() {
        PropertyData backgroundImageData = new PropertyData();
        String imgPath = this.imageFileField.getText();
        if (imgPath == null || imgPath.equals("")) {
            imgPath = Utils.NOT_SET;
            this.imageFileField.setText(imgPath);
        }
        if (!imgPath.equals(Utils.NOT_SET)) {
            backgroundImageData.setValue("url(" + imgPath + ")");
        } else {
            backgroundImageData.setValue(Utils.NOT_SET);
        }
        this.cssPropertyChangeSupport().firePropertyChange("background-image", null, backgroundImageData.toString());
    }

    private void setBackgroundRepeat() {
        PropertyData backgroundRepeatData = new PropertyData();
        backgroundRepeatData.setValue(this.repeatComboBox.getSelectedItem().toString());
        this.cssPropertyChangeSupport().firePropertyChange("background-repeat", null, backgroundRepeatData.toString());
    }

    private void setBackgroundAttachment() {
        PropertyData backgroundAttachmentData = new PropertyData();
        backgroundAttachmentData.setValue(this.scrollComboBox.getSelectedItem().toString());
        this.cssPropertyChangeSupport().firePropertyChange("background-attachment", null, backgroundAttachmentData.toString());
    }

    private void setBackgroundPosition() {
        this.cssPropertyChangeSupport().firePropertyChange("background-position", null, this.bgPositionData.toString());
        this.enablePositionCombo();
    }

    private void enablePositionCombo() {
        String horizontalPos = this.bgPositionData.getHorizontalValue();
        if (Utils.isInteger(horizontalPos)) {
            this.horizontalUnitComboBox.setEnabled(true);
        } else {
            this.horizontalUnitComboBox.setEnabled(false);
        }
        String verticalPos = this.bgPositionData.getVerticalValue();
        if (Utils.isInteger(verticalPos)) {
            this.verticalUnitComboBox.setEnabled(true);
        } else {
            this.verticalUnitComboBox.setEnabled(false);
        }
    }
}

