/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OldJSPDebug;
import org.openide.filesystems.FileObject;

public final class JSPServletFinder {
    public static final String SERVLET_FINDER_CHANGED = "servlet-finder-changed";
    private Project project;

    public static JSPServletFinder findJSPServletFinder(FileObject f) {
        Project prj = FileOwnerQuery.getOwner((FileObject)f);
        return prj == null ? null : new JSPServletFinder(prj);
    }

    private JSPServletFinder(Project project) {
        this.project = project;
    }

    private J2eeModuleProvider getProvider() {
        return (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
    }

    private ServerString getServerString() {
        J2eeModuleProvider dl = this.getProvider();
        if (dl == null) {
            return null;
        }
        ServerInstance instance = ServerRegistry.getInstance().getServerInstance(dl.getServerInstanceID());
        return instance == null ? null : new ServerString(instance);
    }

    private String getWebURL() {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return provider.getConfigSupport().getWebContextRoot();
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    private FindJSPServlet getServletFinder() {
        ServerString serverS = this.getServerString();
        if (serverS == null) {
            return null;
        }
        ServerInstance inst = serverS.getServerInstance();
        if (inst == null) {
            return null;
        }
        return inst.getFindJSPServlet();
    }

    public File getServletTempDirectory() {
        FindJSPServlet find = this.getServletFinder();
        if (find == null) {
            return null;
        }
        String webURL = this.getWebURL();
        if (webURL == null) {
            return null;
        }
        return find.getServletTempDirectory(webURL);
    }

    public String getServletResourcePath(String jspResourcePath) {
        FindJSPServlet find = this.getServletFinder();
        if (find == null) {
            return null;
        }
        String webURL = this.getWebURL();
        if (webURL == null) {
            return null;
        }
        if (null == jspResourcePath) {
            throw new NullPointerException("jspResourcePath");
        }
        return find.getServletResourcePath(webURL, jspResourcePath);
    }

    public String getServletEncoding(String jspResourcePath) {
        FindJSPServlet find = this.getServletFinder();
        if (find == null) {
            return null;
        }
        String webURL = this.getWebURL();
        if (webURL == null) {
            return null;
        }
        return find.getServletEncoding(webURL, jspResourcePath);
    }

    public OldJSPDebug.JspSourceMapper getSourceMapper(String jspResourcePath) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

